package ru.yandex.autotests.directapi.rules;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

import ru.yandex.autotests.directapi.apiclient.RequestHeader;
import ru.yandex.autotests.directapi.exceptions.DirectAPIException;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.qatools.allure.Allure;
import ru.yandex.qatools.allure.events.StepFinishedEvent;
import ru.yandex.qatools.allure.events.StepStartedEvent;

/**
 * User: mariabye
 * Date: 24.02.12
 * Use only for @Rule. Not for @ClassRule
 */
public class Trashman extends TestWatcher {
    public static Log log = LogFactory.getLog(Trashman.class);

    private ApiSteps apiSteps;
    private RequestHeader requestHeaderState;

    @Override
    protected void starting(Description description) {
        this.requestHeaderState = apiSteps.requestHeader.clone();

        apiSteps.addGeneratedDataToResourceHolder();

        apiSteps.userSteps.campaignStepsV4().bin.openBin();
        apiSteps.userSteps.campaignSteps().bin.openBin();
        apiSteps.userSteps.imagesSteps().bin.openBin();
        apiSteps.userSteps.retargetingSteps().bin.openBin();
        apiSteps.userSteps.statisticsSteps().bin.openBin();
        apiSteps.userSteps.forecastSteps().bin.openBin();
        apiSteps.userSteps.subscriptionSteps().bin.openBin();
        apiSteps.userSteps.sitelinksSteps().bin.openBin();
        apiSteps.userSteps.retargetingListsSteps().bin.openBin();
        //apiSteps.userSteps.adExtensionsSteps().bin.openBin();
    }

    /**
     * Here must be called all clean test methods
     * In the future would be possible to specify Class Annotation to call only needed ones
     *
     * @param description class description
     */
    @Override
    protected void finished(Description description) {
        Allure.LIFECYCLE.fire(new StepStartedEvent("Удаление данных созданных для теста"));
        log.info("Trashman starting its filthy work");
        try {
            apiSteps.userSteps.statisticsSteps().bin.clearBin();
            apiSteps.userSteps.forecastSteps().bin.clearBin();
            apiSteps.userSteps.imagesSteps().bin.clearBin();
            apiSteps.userSteps.subscriptionSteps().bin.clearBin();
            apiSteps.as(Logins.SUPER_LOGIN);
            apiSteps.userSteps.campaignStepsV4().bin.clearBin();
            apiSteps.userSteps.campaignSteps().bin.clearBin();
            apiSteps.userSteps.retargetingSteps().bin.clearBin();
            apiSteps.userSteps.sitelinksSteps().bin.clearBin();
            apiSteps.userSteps.retargetingListsSteps().bin.clearBin();
            //apiSteps.userSteps.adExtensionsSteps().bin.clearBin();
        } finally {
            try {
                apiSteps.as(requestHeaderState.getLogin(), requestHeaderState.getFakeLogin())
                        .clientLogin(requestHeaderState.getClientLogin());
            } catch (NullPointerException e) {
                throw new DirectAPIException(
                        "Не удалось перелогиниться после удаления тестовых данных. Проблемы со средой"
                );
            }
            log.info("Trashman finished");
        }
        Allure.LIFECYCLE.fire(new StepFinishedEvent());
    }

    public Trashman(ApiSteps api) {
        this.apiSteps = api;
    }
}
