package ru.yandex.autotests.directapi.steps;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;

import com.yandex.direct.api.v5.adextensions.AddResponse;
import com.yandex.direct.api.v5.adextensions.DeleteRequest;
import com.yandex.direct.api.v5.adextensions.DeleteResponse;
import com.yandex.direct.api.v5.adextensions.GetResponse;
import com.yandex.direct.api.v5.general.ActionResult;

import ru.yandex.autotests.directapi.apiclient.RequestHeader;
import ru.yandex.autotests.directapi.apiclient.config.ConnectionConfig;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.version5.ServiceNames;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.adextensions.AdExtensionAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adextensions.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.adextensions.DeleteRequestMap;
import ru.yandex.autotests.directapi.model.api5.adextensions.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.adextensiontypes.CalloutMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.Api5Bin;
import ru.yandex.autotests.directapi.rules.Api5Binable;
import ru.yandex.qatools.allure.annotations.Step;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by proxeter on 18.02.16.
 */
public class AdExtensionsSteps extends BaseApiSteps implements Api5Binable<Long> {

    private static AdExtensionsSteps _instance;

    public Api5Bin<Long> bin = new Api5Bin<>(this);

    private AdExtensionsSteps(ConnectionConfig connectionConfig, RequestHeader requestHeader) {
        super(connectionConfig, requestHeader);
    }

    public static AdExtensionsSteps getInstance(ConnectionConfig connectionConfig, RequestHeader requestHeader) {
        if (_instance == null) {
            _instance = new AdExtensionsSteps(connectionConfig, requestHeader);
        } else {
            _instance.setConnectionConfig(connectionConfig);
            _instance.setRequestHeader(requestHeader);
        }
        return _instance;

    }

    @Step("[AdExtensions]: Add")
    public AddResponse adExtensionsAdd(AddRequestMap parameters, String login) {
        AddResponse response =
                defaultClientV5().invokeMethod(ServiceNames.AD_EXTENSIONS, login, Action.ADD, parameters.getBean());
        throwToBin(login, response);
        return response;
    }

    public AddResponse adExtensionsAdd(AddRequestMap parameters) {
        return adExtensionsAdd(parameters, null);
    }

    public List<Long> addAdExtensions(String login, AdExtensionAddItemMap... adExtensions) {
        AddResponse response = adExtensionsAdd(new AddRequestMap().withAdExtensions(adExtensions), login);
        List<ActionResult> results = response.getAddResults();
        lookForResponseExceptions(results);
        return getIDsFromActionResults(results);
    }

    public List<Long> addAdExtensions(AdExtensionAddItemMap... adExtensions) {
        return addAdExtensions(null, adExtensions);
    }

    public Long addCalloutWithText(String text, String login) {
        return addAdExtensions(login, new AdExtensionAddItemMap().withCallout(new CalloutMap().withCalloutText(text)))
                .get(0);
    }

    public Long addCalloutWithText(String text) {
        return addCalloutWithText(text, null);
    }

    public AddResponse shouldGetResultOnAdExtensionsAdd(AddRequestMap parameters, String login,
            ExpectedResult... expectedResults)
    {
        AddResponse response =
                (AddResponse) shouldGetResultOn(ServiceNames.AD_EXTENSIONS, login, Action.ADD, parameters,
                        expectedResults);
        throwToBin(login, response);
        return response;
    }

    public AddResponse shouldGetResultOnAdExtensionsAdd(AddRequestMap parameters, ExpectedResult... expectedResults) {
        return shouldGetResultOnAdExtensionsAdd(parameters, null, expectedResults);
    }

    public void expectErrorOnAdExtensionsAdd(AddRequestMap parameters, Api5Error api5Error) {
        expectErrorOnAdExtensionsAdd(parameters, null, api5Error);
    }

    public void expectErrorOnAdExtensionsAdd(AddRequestMap parameters, String login, Api5Error api5Error) {
        shouldGetErrorOn(ServiceNames.AD_EXTENSIONS, login, Action.ADD, parameters, api5Error);
    }

    public void expectErrorOnAdd(String login, Object parameters, Api5Error api5Error) {
        shouldGetJSONErrorOn(ServiceNames.AD_EXTENSIONS, login, Action.ADD, parameters, api5Error);
    }

    public void expectErrorOnAdd(Object parameters, Api5Error api5Error) {
        expectErrorOnAdd(null, parameters, api5Error);
    }

    @Step("[AdExtensions]: Get")
    public GetResponse getAdExtensions(GetRequestMap params, String login) {
        return defaultClientV5().invokeMethod(ServiceNames.AD_EXTENSIONS, login, Action.GET, params.getBean());
    }

    public GetResponse getAdExtensions(GetRequestMap params) {
        return getAdExtensions(params, null);
    }

    public GetResponse shouldGetResultOnAdExtensionsGet(GetRequestMap parameters, String login,
            ExpectedResult... expectedResults)
    {
        return (GetResponse) shouldGetResultOn(ServiceNames.AD_EXTENSIONS, login, Action.GET, parameters,
                expectedResults);
    }

    public GetResponse shouldGetResultOnAdExtensionsGet(GetRequestMap parameters, ExpectedResult... expectedResults) {
        return shouldGetResultOnAdExtensionsGet(parameters, null, expectedResults);
    }

    public void expectErrorOnAdExtensionsGet(GetRequestMap parameters, Api5Error api5Error) {
        expectErrorOnAdExtensionsGet(parameters, null, api5Error);
    }

    public void expectErrorOnAdExtensionsGet(GetRequestMap parameters, String login, Api5Error api5Error) {
        shouldGetErrorOn(ServiceNames.AD_EXTENSIONS, login, Action.GET, parameters, api5Error);
    }

    public void expectErrorOnGet(String login, Object parameters, Api5Error api5Error) {
        shouldGetJSONErrorOn(ServiceNames.AD_EXTENSIONS, login, Action.GET, parameters, api5Error);
    }

    public void expectErrorOnGet(Object parameters, Api5Error api5Error) {
        expectErrorOnGet(null, parameters, api5Error);
    }

    //region Delete
    @Step("[AdExtensions]: Delete")
    public DeleteResponse adExtensionsDelete(DeleteRequestMap parameters, String login) {
        DeleteResponse response =
                defaultClientV5().invokeMethod(ServiceNames.AD_EXTENSIONS, login, Action.DELETE,
                        (DeleteRequest) parameters.getBean());
        removeFromBin(response);
        return response;
    }

    public DeleteResponse adExtensionsDelete(DeleteRequestMap parameters) {
        return adExtensionsDelete(parameters, null);
    }

    public DeleteResponse adExtensionsDelete(String login, Long... ids) {
        return adExtensionsDelete(new DeleteRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds(ids)),
                login);
    }

    public DeleteResponse adExtensionsDelete(Long... ids) {
        return adExtensionsDelete(null, ids);
    }

    public DeleteResponse shouldGetResultOnDelete(
            DeleteRequestMap parameters, String login, ExpectedResult... expectedResults)
    {
        DeleteResponse response =
                (DeleteResponse) shouldGetResultOn(ServiceNames.AD_EXTENSIONS, login, Action.DELETE, parameters,
                        expectedResults);
        removeFromBin(response);
        return response;
    }

    public DeleteResponse shouldGetResultOnDelete(DeleteRequestMap parameters, ExpectedResult... expectedResults) {
        return shouldGetResultOnDelete(parameters, null, expectedResults);
    }

    public DeleteResponse shouldGetResultOnDelete(
            IdsCriteriaMap parameters, String login, ExpectedResult... expectedResults)
    {
        return shouldGetResultOnDelete(
                new DeleteRequestMap().withSelectionCriteria(parameters), login, expectedResults);
    }

    public DeleteResponse shouldGetResultOnDelete(IdsCriteriaMap parameters, ExpectedResult... expectedResults) {
        return shouldGetResultOnDelete(parameters, null, expectedResults);
    }

    public void expectErrorOnAdExtensionsDelete(DeleteRequestMap parameters, String login, Api5Error api5Error) {
        shouldGetErrorOn(ServiceNames.AD_EXTENSIONS, login, Action.DELETE, parameters, api5Error);
    }

    public void expectErrorOnAdExtensionsDelete(DeleteRequestMap parameters, Api5Error api5Error) {
        expectErrorOnAdExtensionsDelete(parameters, null, api5Error);
    }

    public void expectErrorOnAdExtensionsDelete(Object parameters, String login, Api5Error api5Error) {
        shouldGetJSONErrorOn(ServiceNames.AD_EXTENSIONS, login, Action.DELETE, parameters, api5Error);
    }

    public void expectErrorOnAdExtensionsDelete(Object parameters, Api5Error api5Error) {
        expectErrorOnAdExtensionsDelete(parameters, null, api5Error);
    }
    //endregion

    private void lookForResponseExceptions(List<ActionResult> results) {
        Optional<ActionResult> notSuccessfullResult =
                results.stream()
                        .filter(result -> (result.getErrors().size() != 0) || (result.getWarnings().size() != 0))
                        .findFirst();
        assertThat("отсутствуют ошибки и ворнинги при вызове метода", notSuccessfullResult.isPresent(), equalTo(false));
    }

    private List<Long> getIDsFromActionResults(List<ActionResult> results) {
        return results.stream().map(ActionResult::getId).collect(Collectors.toList());
    }

    private void throwToBin(String login, AddResponse addResponse) {
        List<Long> ids = getIDsFromActionResults(addResponse.getAddResults());
        for (Long id : ids) {
            if (id != null) {
                bin.throwToBin(id, login != null ? login :
                        (requestHeader.getFakeLogin() != null ? requestHeader.getFakeLogin()
                                : requestHeader.getLogin()));
            }
        }
    }

    private void removeFromBin(DeleteResponse deleteResponse) {
        List<Long> ids = getIDsFromActionResults(deleteResponse.getDeleteResults());
        for (Long id : ids) {
            bin.removeFromBin(id);
        }
    }

    @Override
    public Callable clearBin(Map<Long, String> binData) {
        return () -> {
            Map<String, List<Long>> loginToIds = new HashMap<>();
            for (Map.Entry<Long, String> entry : binData.entrySet()) {
                Long id = entry.getKey();
                String login = entry.getValue();
                if (!loginToIds.containsKey(login)) {
                    loginToIds.put(login, new ArrayList<>());
                }
                loginToIds.get(login).add(id);
            }
            for (Map.Entry<String, List<Long>> entry : loginToIds.entrySet()) {
                String login = entry.getKey();
                List<Long> ids = entry.getValue();
                adExtensionsDelete(login, ids.toArray(new Long[0]));
            }
            return null;
        };
    }

}
