package ru.yandex.autotests.directapi.steps;

import ru.yandex.autotests.balance.lib.environment.Environment;
import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.directapi.apiclient.balancexmlrpc.BalanceXmlRpcClient;
import ru.yandex.autotests.directapi.exceptions.DirectAPIException;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Step;

public class BalanceNewSteps {
    private LogSteps log = LogSteps.getLogger(this.getClass());
    private static DirectTestRunProperties properties = DirectTestRunProperties.getInstance();
    private static final int SERVICE_ID = 7;
    private static final int FIRM_ID = 1;
    private BalanceXmlRpcClient balanceXmlRpcClient;
    private User operator;

    private static BalanceNewSteps _instance;

    private BalanceNewSteps() {
        try {
            Environment balanceEnvironment = Environment.valueOf(properties.getBalanceStageType());
            balanceXmlRpcClient = new BalanceXmlRpcClient(balanceEnvironment.getTestXmlRpcUrl());
        } catch (IllegalArgumentException e) {
            throw new DirectAPIException("Unknown balance environment: " + properties.getBalanceStageType(), e);
        }
    }

    public static BalanceNewSteps getInstance() {
        if (_instance == null) {
            _instance = new BalanceNewSteps();
        }
        return _instance;
    }

    /**
     *
     * @param clientId идентификатор клиента
     * @param autoOverdraftLimit сумма лимита без учета НДС
     */
    @Step("Устанавливаем овердрафт: clientId = {0} , autoOverdraftLimit = {1}")
    public void setClientOverdraft(Long clientId, int autoOverdraftLimit) {
        try {
            balanceXmlRpcClient.setClientOverdraft(clientId.intValue(), SERVICE_ID, autoOverdraftLimit);
        } catch (Exception e) {
            throw new DirectAPIException("Ошибка установки овердрафта для clientId: " + clientId);
        }
    }

    public void setClientOverdraft(Long clientId) {
        setClientOverdraft(clientId, 99999);
    }

    public BalanceNewSteps operator(User user) {
        this.operator = user;
        return this;
    }
}
