package ru.yandex.autotests.directapi.steps;

import java.io.IOException;

import com.fasterxml.jackson.databind.ObjectMapper;

import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.direct.utils.config.balancesimple.BalanceSimpleEnvironment;
import ru.yandex.autotests.directapi.apiclient.balancesimple.BalanceSimpleClient;
import ru.yandex.autotests.directapi.exceptions.DirectAPIException;
import ru.yandex.autotests.directapi.model.balancesimple.request.BalanceSimpleRequest;
import ru.yandex.autotests.directapi.model.balancesimple.request.BindCreditCardRequest;
import ru.yandex.autotests.directapi.model.balancesimple.request.SupplyPaymentDataRequest;
import ru.yandex.autotests.directapi.model.balancesimple.response.BalanceSimpleResponse;
import ru.yandex.autotests.directapi.model.balancesimple.response.BindCreditCardResponse;
import ru.yandex.autotests.directapi.model.balancesimple.response.ListPaymentMethodResponse;

/**
 * Created by semkagtn on 15.09.15.
 */
public class BalanceSimpleSteps {

    private static final String BIND_CREDIT_CARD = "bind_credit_card";
    private static final String LIST_PAYMENT_METHODS = "list_payment_methods";
    private static final String SUPPLY_PAYMENT_DATA = "supply_payment_data";
    private static DirectTestRunProperties properties = DirectTestRunProperties.getInstance();

    private static BalanceSimpleSteps instance;

    public static BalanceSimpleSteps getInstance(String token) {
        if (instance == null) {
            instance = new BalanceSimpleSteps(token);
        } else {
            instance.client.setToken(token);
        }
        return instance;
    }

    private BalanceSimpleClient client;

    private BalanceSimpleSteps(String token) {
        try {
            BalanceSimpleEnvironment simpleEnvironment =
                    BalanceSimpleEnvironment.valueOf(properties.getBalanceSimpleStageType());
            this.client = new BalanceSimpleClient(token, simpleEnvironment);
        } catch (IllegalArgumentException e) {
            throw new DirectAPIException("Unknown balance environment: " + properties.getBalanceStageType(), e);
        }
    }

    public BindCreditCardResponse bindCreditCard(BindCreditCardRequest request) {
        String response = client.sendRequest(BIND_CREDIT_CARD, request);
        return parseResponse(response, BindCreditCardResponse.class);
    }

    public ListPaymentMethodResponse listPaymentMethods() {
        String response = client.sendRequest(LIST_PAYMENT_METHODS, new BalanceSimpleRequest());
        return parseResponse(response, ListPaymentMethodResponse.class);
    }

    public String getPaymentMethod() {
        return listPaymentMethods().getPaymentMethods().keySet().stream()
                .findFirst().orElseThrow(() -> new DirectAPIException("у клиента отсутствует привязанная карточка"));
    }

    public BalanceSimpleResponse supplyPaymentData(SupplyPaymentDataRequest request) {
        String response = client.sendRequest(SUPPLY_PAYMENT_DATA, request);
        return parseResponse(response, BalanceSimpleResponse.class);
    }

    private static <T> T parseResponse(String response, Class<T> clazz) {
        try {
            return new ObjectMapper().readValue(response, clazz);
        } catch (IOException e) {
            throw new DirectAPIException("Не удалось распарсить ответ: " + response);
        }
    }
}
