package ru.yandex.autotests.directapi.steps;

import java.util.concurrent.TimeUnit;

import com.jayway.awaitility.Duration;
import com.jayway.awaitility.core.ConditionFactory;

import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;

import static com.jayway.awaitility.Awaitility.with;

/**
 * Created with IntelliJ IDEA.
 * User: mariabye
 * Date: 17.10.13
 * Time: 12:08
 * To change this template use File | Settings | File Templates.
 */
@SuppressWarnings("unused")
public class ConditionFactories {
    private ConditionFactories() {
    }

    private static DirectTestRunProperties properties = DirectTestRunProperties.getInstance();

    public static final ConditionFactory NOTIFY_PAYMENT = with().timeout(Duration.FIVE_MINUTES)
            .and().with().pollDelay(Duration.TEN_SECONDS)
            .and().with().pollInterval(Duration.TEN_SECONDS)
            .await("payment notification");
    public static final ConditionFactory NOTIFY_ORDER2 = with().timeout(Duration.FIVE_MINUTES)
            .and().with().pollDelay(Duration.ONE_SECOND)
            .and().with().pollInterval(Duration.TEN_SECONDS)
            .await("processing NotifyOrder2");
    public static final ConditionFactory CLIENT_UNIFIED_ACCOUNT = with().timeout(new Duration(180, TimeUnit.SECONDS))
            .and().with().pollDelay(Duration.TEN_SECONDS)
            .and().with().pollInterval(Duration.TEN_SECONDS)
            .await("unified account enable/disable");
    public static final ConditionFactory OFFLINE_REPORT = with().timeout(new Duration(1200, TimeUnit.SECONDS))
            .and().with().pollDelay(Duration.ONE_SECOND)
            .and().with().pollInterval(Duration.ONE_MINUTE)
            .await("API4 offline report is ready");
    public static final ConditionFactory IMAGE = with().timeout(new Duration(15, TimeUnit.MINUTES))
            .and().with().pollDelay(Duration.ONE_SECOND)
            .and().with().pollInterval(new Duration(20, TimeUnit.SECONDS))
            .await("image is handled");
    public static final ConditionFactory FORECAST = with().timeout(new Duration(180, TimeUnit.SECONDS))
            .and().with().pollDelay(Duration.TEN_SECONDS)
            .and().with().pollInterval(Duration.TEN_SECONDS)
            .await("API4 forecast report is ready");
    public static final ConditionFactory BANNER_PARAMS = with().timeout(new Duration(180, TimeUnit.SECONDS))
            .and().with().pollDelay(Duration.TEN_SECONDS)
            .and().with().pollInterval(Duration.TEN_SECONDS)
            .await("banner params is changed");
    public static final ConditionFactory SUBSCRIPTION = with().timeout(new Duration(3, TimeUnit.MINUTES))
            .and().with().pollDelay(Duration.TEN_SECONDS)
            .and().with().pollInterval(Duration.TEN_SECONDS)
            .await("subscription is changed");
    public static final ConditionFactory SANDBOX_STATUS = with().timeout(new Duration(600, TimeUnit.SECONDS))
            .and().with().pollDelay(Duration.TEN_SECONDS)
            .and().with().pollInterval(Duration.TEN_SECONDS)
            .await("status is changed");
    public static final ConditionFactory DATABASE = with().timeout(new Duration(120, TimeUnit.SECONDS))
            .and().with().pollDelay(Duration.TEN_SECONDS)
            .and().with().pollInterval(Duration.TEN_SECONDS)
            .await("database value is changed");
    public static final ConditionFactory NOTIFY_CLIENT = with().timeout(Duration.ONE_MINUTE)
            .and().with().pollDelay(Duration.ONE_SECOND)
            .and().with().pollInterval(Duration.TEN_SECONDS)
            .await("processing NotifyClient");
    public static final ConditionFactory FAKE_STATUS = with().timeout(Duration.ONE_MINUTE)
            .and().with().pollDelay(Duration.ONE_SECOND)
            .and().with().pollInterval(Duration.TEN_SECONDS)
            .await("status moderate is changed");
    public static final ConditionFactory CAMP_AGGREGATE_LAST_CHANGE_JOB = with().timeout(Duration.ONE_MINUTE)
            .and().with().pollDelay(Duration.ONE_SECOND)
            .and().with().pollInterval(Duration.ONE_SECOND)
            .await("job is executed");
    public static final ConditionFactory PHRASE_ID_IS_SET = with().timeout(new Duration(30L, TimeUnit.SECONDS))
            .and().with().pollDelay(Duration.ONE_SECOND)
            .and().with().pollInterval(Duration.ONE_SECOND)
            .await("Nonzero PhraseID is set in bids table");
}
