package ru.yandex.autotests.directapi.steps;

import com.yandex.direct.api.v5.dictionaries.DictionaryNameEnum;
import com.yandex.direct.api.v5.dictionaries.GetResponse;
import com.yandex.direct.api.v5.dictionaries.InterestsItem;
import com.yandex.direct.api.v5.general.YesNoEnum;

import ru.yandex.autotests.directapi.apiclient.RequestHeader;
import ru.yandex.autotests.directapi.apiclient.config.ConnectionConfig;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.version5.ServiceNames;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.dictionaries.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlApi5Error;
import ru.yandex.qatools.allure.annotations.Step;

import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by proxeter on 25.01.16.
 */
public class DictionariesSteps extends BaseApiSteps {

    private static DictionariesSteps _instance;

    private DictionariesSteps(ConnectionConfig connectionConfig, RequestHeader requestHeader) {
        super(connectionConfig, requestHeader);
    }

    public static DictionariesSteps getInstance(ConnectionConfig connectionConfig, RequestHeader requestHeader) {
        if (_instance == null) {
            _instance = new DictionariesSteps(connectionConfig, requestHeader);
        } else {
            _instance.setConnectionConfig(connectionConfig);
            _instance.setRequestHeader(requestHeader);
        }
        return _instance;

    }

    @Step("[Dictionaries]: Get")
    public GetResponse getDictionaries(GetRequestMap params, String login) {
        return defaultClientV5().invokeMethod(ServiceNames.DICTIONARIES, login, Action.GET, params.getBean());
    }

    @Step("[Dictionaries]: Get")
    public GetResponse getDictionaries(GetRequestMap params) {
        return getDictionaries(params, null);
    }

    public void expectErrorOnDictionariesGet(GetRequestMap parameters, String login, Api5Error api5Error) {
        shouldGetErrorOn(ServiceNames.DICTIONARIES, login, Action.GET, parameters, api5Error);
    }

    public void expectErrorOnDictionariesGet(GetRequestMap parameters, Api5Error api5Error) {
        shouldGetErrorOn(ServiceNames.DICTIONARIES, null, Action.GET, parameters, api5Error);
    }

    public void expectErrorOnDictionariesGet(GetRequestMap parameters, JavaOrPerlApi5Error api5Error) {
        shouldGetErrorOn(ServiceNames.DICTIONARIES, null, Action.GET, parameters, api5Error);
    }

    public Long getInterestIdByIsTargetable(YesNoEnum yesNoEnum) {
        GetResponse getResponse = getDictionaries(
                new GetRequestMap().withDictionaryNames(DictionaryNameEnum.INTERESTS)
        );
        assumeThat("интересы получены", getResponse.getInterests(), notNullValue());
        Long interestId = getResponse.getInterests()
                .stream()
                .filter(interest -> interest.getIsTargetable() == yesNoEnum)
                .map(InterestsItem::getInterestId)
                .findFirst().get();
        return interestId;
    }

}
