package ru.yandex.autotests.directapi.steps;


import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.GetResponse;
import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.CampaignStateEnum;
import com.yandex.direct.api.v5.general.ActionResult;
import org.apache.commons.beanutils.BeanMap;
import org.joda.time.DateTime;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsRecord;
import ru.yandex.autotests.direct.db.steps.CampaignsSteps;
import ru.yandex.autotests.direct.utils.ReflectionUtils;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.directapi.apiclient.RequestHeader;
import ru.yandex.autotests.directapi.apiclient.config.ConnectionConfig;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.BannerPhraseFakeInfo;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.CampaignFakeInfo;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.GroupFakeInfo;
import ru.yandex.autotests.directapi.darkside.steps.TransportSteps;
import ru.yandex.autotests.directapi.darkside.steps.fakesteps.*;
import ru.yandex.autotests.directapi.enums.AdGroupType;
import ru.yandex.autotests.directapi.enums.BannerType;
import ru.yandex.autotests.directapi.exceptions.DirectAPIException;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.banners.BannerInfoMap;
import ru.yandex.autotests.directapi.model.banners.phrases.BannerPhraseInfoMap;
import ru.yandex.autotests.directapi.model.campaigns.Status;
import ru.yandex.autotests.directapi.model.clients.CreateNewSubclientRequestMap;
import ru.yandex.autotests.directapi.model.common.Value;
import ru.yandex.autotests.directapi.model.finances.PayCampElementMap;
import ru.yandex.autotests.directapi.steps.agencyclients.AgencyClientsStepsV5;
import ru.yandex.autotests.directapi.steps.banners.*;
import ru.yandex.autotests.directapi.steps.businesses.BusinessesSteps;
import ru.yandex.autotests.directapi.steps.campaigns.CampaignSteps;
import ru.yandex.autotests.directapi.steps.campaigns.CampaignStepsV5;
import ru.yandex.autotests.directapi.steps.campaignsext.CampExtSteps;
import ru.yandex.autotests.directapi.steps.clients.ClientSteps;
import ru.yandex.autotests.directapi.steps.clients.ClientsStepsV5;
import ru.yandex.autotests.directapi.steps.common.GetRegionsSteps;
import ru.yandex.autotests.directapi.steps.common.GetRubricsSteps;
import ru.yandex.autotests.directapi.steps.common.GetVersionsSteps;
import ru.yandex.autotests.directapi.steps.common.PingAPISteps;
import ru.yandex.autotests.directapi.steps.creatives.CreativeSteps;
import ru.yandex.autotests.directapi.steps.dynamictextadtargets.DynamicTextAdTargetsSteps;
import ru.yandex.autotests.directapi.steps.finance.FinanceSteps;
import ru.yandex.autotests.directapi.steps.forecast.ForecastSteps;
import ru.yandex.autotests.directapi.steps.getchanges.ChangesSteps;
import ru.yandex.autotests.directapi.steps.getchanges.GetChangesSteps;
import ru.yandex.autotests.directapi.steps.geteventslog.GetEventsLogSteps;
import ru.yandex.autotests.directapi.steps.geteventslog.SubscriptionSteps;
import ru.yandex.autotests.directapi.steps.leads.LeadsSteps;
import ru.yandex.autotests.directapi.steps.prices.BidModifiersSteps;
import ru.yandex.autotests.directapi.steps.prices.BidsSteps;
import ru.yandex.autotests.directapi.steps.prices.KeywordBidsSteps;
import ru.yandex.autotests.directapi.steps.prices.PricesSteps;
import ru.yandex.autotests.directapi.steps.sandbox.SandboxSteps;
import ru.yandex.autotests.directapi.steps.statistics.ReportsSteps;
import ru.yandex.autotests.directapi.steps.statistics.StatisticsSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Title;

import java.math.RoundingMode;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

import static org.apache.commons.lang.StringUtils.capitalize;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created with IntelliJ IDEA.
 * User: mariabye
 * Date: 20.08.13
 * Time: 12:24
 * To change this template use File | Settings | File Templates.
 */
public class UserSteps extends BaseApiSteps {

    //region Sub-steps

    public CampaignFakeSteps campaignFakeSteps() {
        return getDarkSideSteps().getCampaignFakeSteps();
    }

    @Deprecated
    public CampaignSteps campaignStepsV4() {
        return CampaignSteps.getInstance(connectionConfig, requestHeader);
    }

    public BannersFakeSteps bannersFakeSteps() {
        return getDarkSideSteps().getBannersFakeSteps();
    }

    public GroupsFakeSteps groupFakeSteps() {
        return getDarkSideSteps().getGroupsFakeSteps();
    }

    public BannerPhrasesFakeSteps phrasesFakeSteps() {
        return getDarkSideSteps().getBannerPhrasesFakeSteps();
    }

    @Deprecated
    public BannerSteps bannerSteps() {
        return BannerSteps.getInstance(connectionConfig, requestHeader);
    }

    public ImagesSteps imagesSteps() {
        return ImagesSteps.getInstance(connectionConfig, requestHeader);
    }

    @Deprecated
    public BannerPhrasesSteps phrasesSteps() {
        return BannerPhrasesSteps.getInstance(connectionConfig, requestHeader);
    }

    public RetargetingSteps retargetingSteps() {
        return RetargetingSteps.getInstance(connectionConfig, requestHeader);
    }

    public PricesSteps pricesSteps() {
        return PricesSteps.getInstance(connectionConfig, requestHeader);
    }

    public TagSteps tagSteps() {
        return TagSteps.getInstance(connectionConfig, requestHeader);
    }

    public ClientFakeSteps clientFakeSteps() {
        return getDarkSideSteps().getClientFakeSteps();
    }

    public ClientSteps clientSteps() {
        return ClientSteps.getInstance(connectionConfig, requestHeader);
    }

    public CreativeSteps creativeSteps() {
        return CreativeSteps.getInstance(connectionConfig, requestHeader);
    }

    public FinanceSteps financeSteps() {
        return FinanceSteps.getInstance(connectionConfig, requestHeader);
    }

    public GetRubricsSteps getRubricsSteps() {
        return GetRubricsSteps.getInstance(connectionConfig, requestHeader);
    }

    public GetVersionsSteps getVersionsSteps() {
        return GetVersionsSteps.getInstance(connectionConfig, requestHeader);
    }

    public GetRegionsSteps getRegionsSteps() {
        return GetRegionsSteps.getInstance(connectionConfig, requestHeader);
    }

    public ForecastSteps forecastSteps() {
        return ForecastSteps.getInstance(connectionConfig, requestHeader);
    }


    @Deprecated
    public GetChangesSteps getChangesSteps() {
        return GetChangesSteps.getInstance(connectionConfig, requestHeader);
    }

    public StatisticsSteps statisticsSteps() {
        return StatisticsSteps.getInstance(connectionConfig, requestHeader);
    }

    public StatisticsFakeSteps statisticsFakeSteps() {
        return getDarkSideSteps().getStatisticsFakeSteps();
    }

    public GetEventsLogSteps getEventsLogSteps() {
        return GetEventsLogSteps.getInstance(connectionConfig, requestHeader);
    }

    public PingAPISteps pingAPISteps() {
        return PingAPISteps.getInstance(connectionConfig, requestHeader);
    }

    public EventLogFakeSteps eventLogFakeSteps() {
        return getDarkSideSteps().getEventLogFakeSteps();
    }

    public SubscriptionSteps subscriptionSteps() {
        return SubscriptionSteps.getInstance(connectionConfig, requestHeader);
    }

    public BalanceSteps balanceSteps() {
        return BalanceSteps.getInstance();
    }

    public BalanceNewSteps balanceNewSteps() {
        return BalanceNewSteps.getInstance();
    }

    public BalanceSimpleSteps balanceSimpleSteps() {
        return BalanceSimpleSteps.getInstance(requestHeader.getToken());
    }

    public SandboxSteps sandboxSteps() {
        return SandboxSteps.getInstance(connectionConfig, requestHeader);
    }

    public TransportSteps transportSteps() {
        return getDarkSideSteps().getTransportSteps();
    }

    private static UserSteps _instance;
    //endregion

    //region Steps for API5
    public AdExtensionsSteps adExtensionsSteps() {
        return AdExtensionsSteps.getInstance(connectionConfig, requestHeader);
    }

    public AdGroupsSteps adGroupsSteps() {
        return AdGroupsSteps.getInstance(connectionConfig, requestHeader);
    }

    public BidsSteps bidsSteps() {
        return BidsSteps.getInstance(connectionConfig, requestHeader);
    }

    public KeywordBidsSteps keywordBidsSteps() {
        return KeywordBidsSteps.getInstance(connectionConfig, requestHeader);
    }

    public DictionariesSteps dictionariesSteps() {
        return DictionariesSteps.getInstance(connectionConfig, requestHeader);
    }

    public VCardsSteps vCardsSteps() {
        return VCardsSteps.getInstance(connectionConfig, requestHeader);
    }

    public KeywordsSteps keywordsSteps() {
        return KeywordsSteps.getInstance(connectionConfig, requestHeader);
    }

    public KeywordsResearchSteps keywordsResearchSteps() {
        return KeywordsResearchSteps.getInstance(connectionConfig, requestHeader);
    }

    public SitelinksSteps sitelinksSteps() {
        return SitelinksSteps.getInstance(connectionConfig, requestHeader);
    }

    public AdsSteps adsSteps() {
        return AdsSteps.getInstance(connectionConfig, requestHeader);
    }

    public ChangesSteps changesSteps() {
        return ChangesSteps.getInstance(connectionConfig, requestHeader);
    }

    @Deprecated
    public CampaignStepsV5 campaignStepsV5() {
        return campaignSteps();
    }

    public CampaignStepsV5 campaignSteps() {
        return CampaignStepsV5.getInstance(connectionConfig, requestHeader);
    }

    public CampExtSteps campExtSteps() {
        return CampExtSteps.getInstance(connectionConfig, requestHeader);
    }

    public ImagesStepsV5 imagesStepsV5() {
        return ImagesStepsV5.getInstance(connectionConfig, requestHeader);
    }

    public ReportsSteps reportsSteps() {
        return ReportsSteps.getInstance(connectionConfig, requestHeader);
    }

    public RetargetingListsSteps retargetingListsSteps() {
        return RetargetingListsSteps.getInstance(connectionConfig, requestHeader);
    }

    public AudienceTargetsSteps audienceTargetsSteps() {
        return AudienceTargetsSteps.getInstance(connectionConfig, requestHeader);
    }

    public TurboPagesSteps turboPagesSteps() {
        return TurboPagesSteps.getInstance(connectionConfig, requestHeader);
    }

    public NegativeKeywordsSharedSetsSteps negativeKeywordsSharedSetsSteps() {
        return NegativeKeywordsSharedSetsSteps.getInstance(connectionConfig, requestHeader);
    }

    //endregion

    public BidModifiersSteps bidModifiersSteps() {
        return BidModifiersSteps.getInstance(connectionConfig, requestHeader);
    }

    public DynamicTextAdTargetsSteps dynamicTextAdTargetsSteps() {
        return DynamicTextAdTargetsSteps.getInstance(connectionConfig, requestHeader);
    }

    public ClientsStepsV5 clientsStepsV5() {
        return ClientsStepsV5.getInstance(connectionConfig, requestHeader);
    }

    public AgencyClientsStepsV5 agencyClientsStepsV5() {
        return AgencyClientsStepsV5.getInstance(connectionConfig, requestHeader);
    }

    public LeadsSteps leadsSteps() {
        return LeadsSteps.getInstance(connectionConfig, requestHeader);
    }

    public BusinessesSteps businessesSteps() {
        return BusinessesSteps.getInstance(connectionConfig, requestHeader);
    }

    public UserSteps(ConnectionConfig connectionConfig, RequestHeader requestHeader) {
        super(connectionConfig, requestHeader);
    }

    public static UserSteps getInstance() {
        if (_instance == null) {
            _instance = new UserSteps(
                    new ConnectionConfig(properties.getDirectAPIHost()),
                    new RequestHeader(properties.getDirectAPILogin()));
        }

        return _instance;

    }

    public static UserSteps getInstance(ConnectionConfig connectionConfig, RequestHeader requestHeader) {
        if (_instance == null) {
            _instance = new UserSteps(connectionConfig, requestHeader);
        } else {
            _instance.setConnectionConfig(connectionConfig);
            _instance.setRequestHeader(requestHeader);
        }
        return _instance;
    }


    //region User steps with campaigns
    @Deprecated
    @Description("использует устаревший степ API4, нужно использовать одноименный метод с API5")
    public void deleteActiveCampaignsQuietly(Integer... campaignIds) {
        campaignFakeSteps().makeCampaignReadyForDelete(campaignIds);
        campaignStepsV4().deleteCampaignsQuietly(campaignIds);
    }

    public void deleteActiveCampaignsQuietly(String login, Integer... campaignIds) {
        campaignFakeSteps().makeCampaignReadyForDelete(campaignIds);
        campaignSteps().campaignsDelete(login, Stream.of(campaignIds).mapToLong(i -> i).boxed().toArray(Long[]::new));
    }

    public void deleteActiveCampaignsQuietly(Long... campaignIds) {
        campaignFakeSteps().makeCampaignReadyForDelete(campaignIds);
        campaignSteps().campaignsDelete(campaignIds);
    }

    public void deleteActiveCampaignsQuietly(String login, Long... campaignIds) {
        campaignFakeSteps().makeCampaignReadyForDelete(campaignIds);
        campaignSteps().campaignsDelete(login, campaignIds);
    }

    public void deleteAllActiveCampaignsByLogin(String login) {
        List<Long> allCampaignIds = campaignSteps().getAllCampaignIds(login);
        if (!allCampaignIds.isEmpty()) {
            deleteActiveCampaignsQuietly(login, allCampaignIds.toArray(new Long[0]));
        }
    }

    @Deprecated
    @Description("использует устаревший степ API4, нужно использовать метод addModeratedCampaign с API5")
    public int createModeratedCampaign() {
        int campaignID = campaignStepsV4().createDefaultCampaign();
        bannerSteps().createDefaultBanner(campaignID);
        makeCampaignModerated(campaignID);
        return campaignID;
    }

    public Long addModeratedCampaign() {
        return addModeratedCampaign(null);
    }

    @Deprecated
    @Description("использует устаревший степ API4, нужно использовать метод addModeratedCampaign с API5")
    public int createModeratedCampaign(String clientLogin) {
        int campaignID = campaignStepsV4().createDefaultCampaign(clientLogin);
        bannerSteps().createDefaultBanner(campaignID);
        makeCampaignModerated(campaignID);
        return campaignID;
    }

    public Long addModeratedCampaign(String clientLogin) {
        Long campaignId = campaignSteps().addDefaultTextCampaign(clientLogin);
        Long adGroupId = adGroupsSteps().addDefaultGroup(campaignId, clientLogin);
        adsSteps().addDefaultTextAd(adGroupId, clientLogin);
        keywordsSteps().addDefaultKeyword(clientLogin, adGroupId);
        makeCampaignModerated(campaignId.intValue());
        return campaignId;
    }


    @Deprecated
    public int createActiveCampaign(String clientLogin) {
        return createActiveCampaign(clientLogin, 1);
    }

    @Deprecated
    @Title("вместо этого степа нужно использовать степ с 5ой версией API addActiveCampaign")
    public int createActiveCampaign(String clientLogin, int bannersCount) {
        int campaignID = campaignStepsV4().createDefaultCampaign(clientLogin);
        bannerSteps().createManyBanners(campaignID, bannersCount);
        makeCampaignActive(campaignID);
        return campaignID;
    }

    public Long addActiveCampaign(String clientLogin, int adsCount) {
        Long campaignId = campaignSteps().addDefaultTextCampaign(clientLogin);
        Long adGroupId = adGroupsSteps().addDefaultGroup(campaignId, clientLogin);
        keywordsSteps().addDefaultKeyword(clientLogin, adGroupId);
        adsSteps().addDefaultAds(adGroupId, clientLogin, adsCount, BannerType.TEXT);
        makeCampaignActiveV5(clientLogin, campaignId);
        return campaignId;
    }

    @Deprecated
    public int createDraftCampaign() {
        int campaignID = campaignStepsV4().createDefaultCampaign();
        bannerSteps().createDefaultBanner(campaignID);
        return campaignID;
    }

    @Deprecated
    @Title("вместо этого степа нужно использовать степ с 5ой версией API addDraftCampaign")
    public int createDraftCampaign(String clientLogin) {
        return createDraftCampaign(clientLogin, 1);
    }

    public Long addDraftCampaign() {
        Long campaignID = campaignSteps().addDefaultTextCampaign();
        Long adGroupId = adGroupsSteps().addDefaultGroup(campaignID);
        adsSteps().addDefaultAds(adGroupId, 1, BannerType.TEXT);
        return campaignID;
    }

    public Long addDraftCampaign(String clientLogin) {
        return addDraftCampaign(clientLogin, 1);
    }

    @Deprecated
    @Title("вместо этого степа нужно использовать степ с 5ой версией API addDraftCampaign")
    public int createDraftCampaign(String clientLogin, int bannersCount) {
        int campaignID = campaignStepsV4().createDefaultCampaign(clientLogin);
        bannerSteps().createManyBanners(campaignID, bannersCount);
        return campaignID;
    }

    public Long addDraftCampaign(String clientLogin, int adsCount) {
        Long campaignID = campaignSteps().addDefaultTextCampaign(clientLogin);
        Long adGroupId = adGroupsSteps().addDefaultGroup(campaignID, clientLogin);
        adsSteps().addDefaultAds(adGroupId, clientLogin, adsCount, BannerType.TEXT);
        return campaignID;
    }

    @Deprecated
    public int createStoppedCampaign(String login, int bannersCount) {
        int campaignID = campaignStepsV4().createDefaultCampaign(login);
        Long[] bannerIDS = bannerSteps().createManyBanners(campaignID, bannersCount);
        bannersFakeSteps().makeBannerReadyForDelete(bannerIDS);
        campaignFakeSteps().makeCampaignStopped(campaignID);
        return campaignID;
    }


    public String getCampaignOwner(int campaignID) {
        CampaignFakeInfo campaignFakeInfo = campaignFakeSteps().fakeGetCampaignParams(campaignID);
        String login;
        if (campaignFakeInfo.getAgencyID().equals(new Integer(0))) {
            login = campaignFakeInfo.getLogin();
        } else {
            login = campaignFakeSteps().getAgencyLogin(campaignID);
        }
        return login;
    }

    public String getAccountOwner(int accountID) {
        CampaignFakeInfo campaignFakeInfo = campaignFakeSteps().fakeGetCampaignParams(accountID);
        String login;
        if (campaignFakeInfo.getAgencyID().equals(new Integer(0))) {
            login = campaignFakeInfo.getLogin();
        } else {
            login = requestHeader.getLogin();
        }
        return login;
    }

    @Deprecated
    public int createActiveCampaign(float sum, Currency currency) {
        return createActiveCampaign(null, sum, currency, 1);
    }

    @Deprecated
    @Title("вместо этого степа нужно использовать степ с 5ой версией API addActiveCampaign")
    public int createActiveCampaign(String clientLogin, Float sum, Currency currency) {
        return createActiveCampaign(clientLogin, sum, currency, 1);
    }

    public long addActiveCampaign(float sum, Currency currency) {
        return addActiveCampaign(null, sum, currency, 1);
    }

    public Long addActiveCampaign(String clientLogin, Float sum, Currency currency) {
        return addActiveCampaign(clientLogin, sum, currency, 1);
    }


    @Deprecated
    public int createActiveCampaign(String clientLogin, Float sum, int bannersCount) {
        return createActiveCampaign(clientLogin, sum, null, bannersCount);
    }

    @Deprecated
    @Title("вместо этого степа нужно использовать степ с 5ой версией API addActiveCampaign")
    public int createActiveCampaign(String clientLogin, Float sum, Currency currency, int bannersCount) {
        int campaignID = createActiveCampaign(clientLogin, bannersCount);
        int invoiceID = createInvoice(campaignID, sum, currency);
        balanceSteps().turnOnInvoice(invoiceID);
        return campaignID;
    }

    public Long addActiveCampaign(String clientLogin, Float sum, Currency currency, int adsCount) {
        Long campaignId = addActiveCampaign(clientLogin, adsCount);
        int invoiceID = createInvoice(campaignId.intValue(), sum, currency);
        balanceSteps().turnOnInvoice(invoiceID);
        return campaignId;
    }

    @Deprecated
    public int createActiveCampaignFakeMoney(String clientLogin, float money) {
        int campaignID = createDraftCampaign(clientLogin);
        makeCampaignActive(campaignID);
        campaignFakeSteps().setCampaignSum(campaignID, money);
        return campaignID;
    }

    @Deprecated
    public void makeCampaignArchived(int campaignID, DateTime lastShowTime) {
        campaignFakeSteps().setLastShowTime(campaignID, lastShowTime);
        campaignStepsV4().stopCampaign(campaignID);
        campaignStepsV4().archiveCampaign(campaignID);
    }

    /** @deprecated Устарело в пользу archiveCampaign (с использованием только степов 5й версии) */
    @Deprecated
    public void makeCampaignArchived(int campaignID) {
        campaignFakeSteps().setLastShowTimeAnHourAndMinuteAgo(campaignID);
        campaignStepsV4().stopCampaign(campaignID);
        campaignStepsV4().archiveCampaign(campaignID);
    }

    public void verifyHasActiveCampaign(String login) {
        CampaignsSelectionCriteriaMap selectionCriteria = new CampaignsSelectionCriteriaMap()
                .withStates(CampaignStateEnum.ON);
        ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap getRequestMap =
                new ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap()
                .withSelectionCriteria(selectionCriteria)
                .withFieldNames(CampaignFieldEnum.ID);
        com.yandex.direct.api.v5.campaigns.GetResponse getResponse = campaignSteps().campaignsGet(getRequestMap, login);
        boolean hasCampaigns = getResponse.getCampaigns().stream().map(CampaignGetItem::getId).findAny().isPresent();
        if (!hasCampaigns) {
            Long campaignId = addActiveCampaign(login, 1);
            campaignSteps().removeCampaignsFromQueue(Arrays.asList(campaignId));
        }
    }


    public void archiveCampaign(Long campaignID) {
        campaignFakeSteps().setLastShowTimeAnHourAndMinuteAgo(campaignID);
        campaignSteps().campaignsSuspend(campaignID);
        campaignSteps().campaignsArchive(campaignID);
    }
    //endregion

    //region User steps with banners
    public void makeBannerModerate(Long adId) {
        bannersFakeSteps().makeBannersModerated(adId);
        Long adGroupID = bannersFakeSteps().getBannerParams(adId).getPid();
        GroupFakeInfo groupFakeInfo = groupFakeSteps().getGroupParams(adGroupID);
        groupFakeInfo.setStatusModerate(Status.YES);
        groupFakeInfo.setStatusPostModerate(Status.YES);
        groupFakeSteps().updateGroupParams(groupFakeInfo);

        phrasesFakeSteps().setBannerFakePhraseIds(adGroupID);
        phrasesFakeSteps().setPhraseStatusModerateYes(adGroupID);
    }

    public void makeBannerActive(Long adId) {
        makeBannerModerate(adId);
        bannersFakeSteps().makeBannerActive(adId);
        Long adGroupID = bannersFakeSteps().getBannerParams(adId).getPid();
        GroupFakeInfo groupFakeInfo = groupFakeSteps().getGroupParams(adGroupID);
        groupFakeInfo.setStatusBsSynced(Status.YES);
        groupFakeSteps().updateGroupParams(groupFakeInfo);
        phrasesFakeSteps().setPhraseStatusBsSyncedYes(adGroupID);
    }

    @Deprecated
    public Long createActiveBannerWithFakePhraseIDs(int campaignID) {
        Long bannerID = bannerSteps().createDefaultBanner(campaignID);
        makeBannerActive(bannerID);
        return bannerID;
    }
    //endregion

    //region Retargeting

    /**
     * Удалить все условия подбора аудитории у пользователя с заданным login-ом
     *
     * @param login Логин пользователя
     */
    public void deleteAllRetargetingListsByLogin(String login) {
        Objects.requireNonNull(login, "login");

        List<Long> retargetingListIds = retargetingListsSteps().getIdsByLogin(login);
        if (retargetingListIds.isEmpty()) {
            return;
        }

        // Находим и удаляем все те AudienceTarget-ы в которых используются данные условия подбора
        audienceTargetsSteps().deleteByRetargetingListIds(login, retargetingListIds);

        retargetingListsSteps().deleteByIds(login, retargetingListIds);
    }

    //endregion

    //region Fake status modifications
    @Deprecated
    public void makeCampaignDeclined(int campaignID) {
        campaignFakeSteps().setCampaignStatusRejectedModerate(campaignID, Status.NO);

        bannersFakeSteps().makeBannersDeclined(bannerSteps().getBannerIDs(campaignID));
    }

    public void makeCampaignModerated(int campaignId) {
        campaignFakeSteps().makeCampaignModerated(campaignId);
        CampaignFakeInfo campaign = campaignFakeSteps().fakeGetCampaignParams(campaignId);
        List<AdGetItem> ads = adsSteps().adsGet(new GetRequestMap()
                        .withFieldNames(AdFieldEnum.ID)
                        .withSelectionCriteria(new AdsSelectionCriteriaMap().withCampaignIds(campaignId)),
                campaign.getLogin()).getAds();
        Long[] adIds = ads.stream().mapToLong(AdGetItem::getId).boxed().toArray(Long[]::new);
        bannersFakeSteps().makeBannersModerated(adIds);
    }

    @Deprecated
    @Title("вместо этого степа нужно использовать степ с 5ой версией API makeCampaignActiveV5()")
    public void makeCampaignActive(int campaignID) {
        campaignFakeSteps().makeCampaignActive(campaignID);
        for (Long bannerID : bannerSteps().getBannerIDs(campaignID)) {
            makeBannerActive(bannerID);
        }
    }

    public void makeCampaignActiveV5(Long campaignId) {
        makeCampaignActiveV5(null, campaignId);
    }

    public void makeCampaignActiveV5(String clientLogin, Long campaignId) {
        campaignFakeSteps().makeCampaignActive(campaignId);
        GetResponse ads = adsSteps().adsGet(new GetRequestMap()
                        .withSelectionCriteria(new AdsSelectionCriteriaMap()
                                .withCampaignIds(campaignId))
                        .withFieldNames(AdFieldEnum.ID),
                clientLogin);
        assumeThat("у кампании есть объявления", ads.getAds(), hasSize(notNullValue()));
        long[] adIds = ads.getAds().stream().mapToLong(AdGetItem::getId).toArray();
        for (Long adId : adIds) {
            makeBannerActive(adId);
        }
    }
    //endregion

    //region Finance
    public int createInvoice(int campaignId, float amount, Currency currency) {
        String login = getCampaignOwner(campaignId);
        PayCampElementMap payCampElement = new PayCampElementMap(soapClient().getPackageName())
                .withCampaignID(campaignId)
                .withCurrency(currency)
                .withSum(amount);
        String requestID = financeSteps().getRequestID(payCampElement);
        return balanceSteps().operator(User.get(login))
                .createInvoice(requestID);
    }


    /*
     CreateInvoice for login account and turn it on
     */
    public int payAccountWithBalance(String login, float sum, Currency currency) {
        int accountID = financeSteps().getAccountID(login);
        String requestID = financeSteps().getInvoiceRequestID(accountID, sum, currency);
        String operator = getAccountOwner(accountID);
        int invoiceID = balanceSteps().operator(User.get(operator)).createInvoice(requestID);
        balanceSteps().turnOnInvoice(invoiceID);
        return accountID;
    }

    public String createFreeClient(String baseLogin) {
        Object subClient = clientSteps().createServicedClient(baseLogin, soapClient().login());
        String login = (String) ReflectionUtils.invokeGetter(subClient, "Login");
        clientFakeSteps().enableToCreateSelfCampaigns(login);
        clientFakeSteps().setAPIEnabled(login, Value.YES);
        return login;
    }

    public <Account> Account enableAndGetAccount(String login) {
        try {
            return financeSteps().getAccount(login);

        } catch (DirectAPIException exception) {
            financeSteps().enableSharedAccount(login);
            return financeSteps().getAccount(login);
        }
    }

    public void createAccount(String login) {
        Long campaignID = campaignSteps().addDefaultTextCampaign(login);
        campaignFakeSteps().resetWalletCreateDate(campaignID);
        financeSteps().verifySharedAccount(login);
    }

    public void createAccountForFreeClient(String login) {
        // Через API5 нельзя создать клиентскую кампанию для субклиента агентства, поэтому создаётся агентская,
        // затем исправляется в базе
        Long campaignId = campaignSteps().addDefaultTextCampaign(login);

        // отсоединяем кампанию от агентства
        CampaignsSteps campaignsSteps = getDirectJooqDbSteps().useShardForLogin(login).campaignsSteps();
        CampaignsRecord camp = campaignsSteps.getCampaignById(campaignId);
        camp.setAgencyuid(null);
        camp.setAgencyid(0L);
        camp.setWalletCid(0L);
        campaignsSteps.updateCampaigns(camp);

        campaignFakeSteps().resetWalletCreateDate(campaignId);
        financeSteps().verifySharedAccount(login);
    }

    @Deprecated
    public void createAccountWithMoney(String login, float sum, Currency currency) {
        int campaignID = createActiveCampaign(login, sum, currency);
        campaignFakeSteps().resetWalletCreateDate(campaignID);
        financeSteps().verifySharedAccount(login);
    }

    public void addAccountWithMoney(String login, float sum, Currency currency) {
        long campaignID = addActiveCampaign(login, sum, currency);
        campaignFakeSteps().resetWalletCreateDate(campaignID);
        financeSteps().verifySharedAccount(login);
    }

    @Step("Перевод средств и проверка остатков на кошельке")
    public void transferAndCheck(String loginFrom, String loginTo, Money amount) {
        int fromAccountId = financeSteps().getAccountID(loginFrom);
        int toAccountId = financeSteps().getAccountID(loginTo);

        Money fromAccountAmountBefore = financeSteps().getAccountAmount(fromAccountId);
        assumeThat(MessageFormat.format("У клиента {0} включен ОС", loginFrom),
                fromAccountAmountBefore, notNullValue());

        Money toAccountAmountBefore = financeSteps().getAccountAmount(toAccountId);
        assumeThat(MessageFormat.format("У клиента {0} включен ОС", loginTo),
                toAccountAmountBefore, notNullValue());

        balanceSteps().synchronizeWithBalance(fromAccountId);
        balanceSteps().synchronizeWithBalance(toAccountId);

        financeSteps().transfer(fromAccountId, toAccountId, amount.floatValue(), amount.getCurrency().toString());

        Money expectedChange;
        if (amount.getCurrency() == Currency.RUB) {
            expectedChange = amount;
        } else {
            expectedChange = amount.convert(Currency.RUB).setScale(2, RoundingMode.HALF_UP);
        }

        ConditionFactories.NOTIFY_ORDER2.until(
                financeSteps().accountAmountChangedOnSum(
                        fromAccountId, fromAccountAmountBefore, expectedChange.negate()));

        ConditionFactories.NOTIFY_ORDER2.until(
                financeSteps().accountAmountChangedOnSum(toAccountId, toAccountAmountBefore, expectedChange));
    }

    public void deleteAccountByLogin(String login) {
        int accountID = financeSteps().getAccountID(login);
        deleteActiveCampaignsQuietly(login, accountID);
    }
    //endregion

    public Long getIDForIntapiMethods(Long bannerID, String methodName) {
        return bannersFakeSteps().getBannerParams(bannerID).getPid();
    }

    /*
        Получение фраз группы баннера по bannerID
    */
    @Deprecated
    public BannerPhraseFakeInfo[] getBannerPhrasesParams(Long bannerID) {
        Object banner = bannerSteps().getBanner(bannerID);
        Long adGroupID = (Long) ReflectionUtils.invokeGetter(banner, capitalize(BannerInfoMap.AD_GROUP_ID));
        return phrasesFakeSteps().getBannerPhrasesParams(adGroupID);
    }

    @Deprecated
    public User createServicedClient(String login) {
        Object response = clientSteps().createNewServicedSubClient(login, Logins.MANAGER_GEO);
        User user = getUserFrom(response);
        clientFakeSteps().disableGeo(user.getLogin());
        createDraftCampaign(user.getLogin());
        return user;
    }

    @Deprecated
    public User createAgencySubClient(String agencyLogin, String login) {
        clientFakeSteps().enableToCreateSubClients(agencyLogin);
        Object response = clientSteps().createNewAgencySubClient(login, agencyLogin);
        User user = getUserFrom(response);
        createDraftCampaign(user.getLogin());
        return user;
    }

    /** Deprecated in favor of addAgencySubClient */
    @Deprecated
    public User createAgencySubClient(String agencyLogin, String login, Currency currency) {
        clientFakeSteps().enableToCreateSubClients(agencyLogin);
        Object response = clientSteps().createNewAgencySubClient(login, agencyLogin, currency);
        User user = getUserFrom(response);
        createDraftCampaign(user.getLogin());
        return user;
    }

    public User addAgencySubClient(String agencyLogin, String login, Currency currency) {
        clientFakeSteps().enableToCreateSubClients(agencyLogin);
        Object response = clientSteps().createNewAgencySubClient(login, agencyLogin, currency);
        User user = getUserFrom(response);
        addDraftCampaign(user.getLogin());
        return user;
    }

    public <CreateNewSubclientResponse> User getUserFrom(CreateNewSubclientResponse createNewSubclientResponse) {
        String login = (String) new BeanMap(createNewSubclientResponse).get(CreateNewSubclientRequestMap.LOGIN);
        String pass = (String) new BeanMap(createNewSubclientResponse).get("password");

        User user = new User();
        user.setLogin(login);
        user.setPassword(pass);
        return user;
    }
    //endregion

    /*
        Создание баннер с заданным типом
     */
    public Long addDefaultAdWithType(Long adGroupId, AdGroupType adGroupType, BannerType adType) {
        Long adId;
        if (adType.equals(BannerType.IMAGE_AD)) {
            String imageHash = imagesStepsV5().addDefaultImageAdAdImage();
            adId = adsSteps().addAdWithAdImageHash(adGroupId, adGroupType, BannerType.IMAGE_AD, imageHash);
        } else {
            adId = adsSteps().addDefaultAd(adGroupId, adType);
        }
        return adId;
    }

    /*
        Полезняки для перехода на степы 5ой версии апи с 4ой

        addCompletedAdGroupWithTwoAds - группа с условием показа и двумя объявлениями
    */
    public Long[] addCompletedAdGroupWithTwoAds(Long campaignId) {
        final Long adgroupId = adGroupsSteps().addDefaultGroup(campaignId);
        final List<ActionResult> adsAddResults = adsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAds(
                        new AdAddItemMap().withDefaultAd(BannerType.TEXT).withAdGroupId(adgroupId),
                        new AdAddItemMap().withDefaultAd(BannerType.TEXT).withAdGroupId(adgroupId)),
                ExpectedResult.success(), ExpectedResult.success()
        ).getAddResults();
        keywordsSteps().addDefaultKeyword(adgroupId);
        return adsAddResults.stream().map(i -> i.getId()).toArray(Long[]::new);
    }

    public Long addCompletedAdGroup(Long campaignId) {
        return addCompletedAdGroupAndReturnCreationResult(campaignId).getAdGroupId();
    }

    public Long addCompletedAdGroupAndReturnAdId(Long campaignId) {
        return addCompletedAdGroupAndReturnCreationResult(campaignId).getAdIds()[0];
    }

    public AdGroupCreationResult addCompletedAdGroupAndReturnCreationResult(Long campaignId) {
        final Long adGroupId = adGroupsSteps().addDefaultGroup(campaignId);
        final Long adId = adsSteps().addDefaultTextAd(adGroupId);
        final long keywordId = keywordsSteps().addDefaultKeyword(adGroupId);
        return new AdGroupCreationResult().withAdGroupId(adGroupId).withAdIds().withAdIds(adId)
                .withKeywordIds(keywordId);
    }

    /*  Костыльный конвертер, нужный для старых тестов, где использвовался BannerPhraseInfoMap в качестве объекта
        для передачи Id объектов
     */
    public BannerPhraseInfoMap creationResultToBannerPhraseInfo(Long campaignId, AdGroupCreationResult creationResult) {
        BannerPhraseInfoMap phraseInfo = new BannerPhraseInfoMap(this.connectionConfig.getPackage())
                .withBannerId(creationResult.getAdIds()[0].toString())
                .withPhraseId(creationResult.getKeywordIds()[0].toString())
                .withCampaignId(campaignId.toString());
        return phraseInfo;
    }

    public final static class AdGroupCreationResult {
        private Long adGroupId;
        private Long[] adIds;
        private Long[] keywordIds;

        public Long getAdGroupId() {
            return adGroupId;
        }

        public AdGroupCreationResult withAdGroupId(Long adGroupId) {
            this.adGroupId = adGroupId;
            return this;
        }

        public Long[] getAdIds() {
            return adIds;
        }

        public AdGroupCreationResult withAdIds(Long... adIds) {
            this.adIds = adIds;
            return this;
        }

        public Long[] getKeywordIds() {
            return keywordIds;
        }

        public AdGroupCreationResult withKeywordIds(Long... keywordIds) {
            this.keywordIds = keywordIds;
            return this;
        }
    }
}
