package ru.yandex.autotests.directapi.steps.agencyclients;

import java.math.BigDecimal;

import com.yandex.direct.api.v5.agencyclients.AddResponse;
import com.yandex.direct.api.v5.agencyclients.GetResponse;
import com.yandex.direct.api.v5.agencyclients.UpdateResponse;

import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.AgencyOptionsRecord;
import ru.yandex.autotests.directapi.apiclient.RequestHeader;
import ru.yandex.autotests.directapi.apiclient.config.ConnectionConfig;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.version5.ServiceNames;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.agencyclients.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.agencyclients.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.agencyclients.UpdateRequestMap;
import ru.yandex.autotests.directapi.steps.BaseApiSteps;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Step;


public class AgencyClientsStepsV5 extends BaseApiSteps {
    private static AgencyClientsStepsV5 _instance;
    private static final BigDecimal DEFAULT_PREFERRED_DEAL_FEE_PERCENT = BigDecimal.TEN;
    private LogSteps log = LogSteps.getLogger(this.getClass());

    private AgencyClientsStepsV5(ConnectionConfig connectionConfig, RequestHeader requestHeader) {
        super(connectionConfig, requestHeader);
    }

    public static AgencyClientsStepsV5 getInstance(ConnectionConfig connectionConfig, RequestHeader requestHeader) {
        if (_instance == null) {
            _instance = new AgencyClientsStepsV5(connectionConfig, requestHeader);
        } else {
            _instance.setConnectionConfig(connectionConfig);
            _instance.setRequestHeader(requestHeader);
        }
        return _instance;
    }

    //region Get
    @Step("[AgencyClients]: Get")
    public GetResponse agencyClientsGet(GetRequestMap parameters, String login) {
        return defaultClientV5().invokeMethod(ServiceNames.AGENCY_CLIENTS, login, Action.GET, parameters.getBean());
    }

    public GetResponse agencyClientsGet(GetRequestMap parameters) {
        return agencyClientsGet(parameters, null);
    }

    public void expectErrorOnAgencyClientsGet(GetRequestMap parameters, Api5Error api5Error) {
        shouldGetErrorOn(ServiceNames.AGENCY_CLIENTS, null, Action.GET, parameters, api5Error);
    }

    public void expectErrorOnAgencyClientsGet(GetRequestMap parameters, String login, Api5Error api5Error) {
        shouldGetErrorOn(ServiceNames.AGENCY_CLIENTS, login, Action.GET, parameters, api5Error);
    }
    //endregion

    //region Add
    @Step("[AgencyClients]: Add")
    public AddResponse agencyClientsAdd(AddRequestMap parameters, String login) {
        return defaultClientV5().invokeMethod(ServiceNames.AGENCY_CLIENTS, login, Action.ADD, parameters.getBean());
    }

    public AddResponse agencyClientsAdd(AddRequestMap parameters) {
        return agencyClientsAdd(parameters, null);
    }

    public void expectErrorOnAgencyClientsAdd(AddRequestMap parameters, String login, Api5Error api5Error) {
        shouldGetErrorOn(ServiceNames.AGENCY_CLIENTS, login, Action.ADD, parameters, api5Error);
    }

    public void expectErrorOnAgencyClientsAdd(AddRequestMap parameters, Api5Error api5Error) {
        expectErrorOnAgencyClientsAdd(parameters, null, api5Error);
    }
    //endregion

    //region Update
    @Step("[AgencyClients]: Update")
    public UpdateResponse agencyClientsUpdate(UpdateRequestMap parameters, String login) {
        return defaultClientV5().invokeMethod(ServiceNames.AGENCY_CLIENTS, login, Action.UPDATE, parameters.getBean());
    }

    public UpdateResponse agencyClientsUpdate(UpdateRequestMap parameters) {
        return agencyClientsUpdate(parameters, null);
    }

    public void expectErrorOnAgencyClientsUpdate(UpdateRequestMap parameters, String login, Api5Error api5Error) {
        shouldGetErrorOn(ServiceNames.AGENCY_CLIENTS, login, Action.UPDATE, parameters, api5Error);
    }

    public void expectErrorOnAgencyClientsUpdate(UpdateRequestMap parameters, Api5Error api5Error) {
        expectErrorOnAgencyClientsUpdate(parameters, null, api5Error);
    }

    public void setAgencyOptions(String agencyLogin, boolean allowClientsWithoutWallet,
            boolean defaultClientsWithWallet, BigDecimal preferredDealFeePercent)
    {
        Long agencyClientId = getDirectJooqDbSteps().useShardForLogin(agencyLogin)
                .usersSteps().getUser(agencyLogin).getClientid();
        AgencyOptionsRecord agencyOpt = new AgencyOptionsRecord();
        agencyOpt.setClientid(agencyClientId);
        agencyOpt.setDefaultClientsWithWallet(defaultClientsWithWallet ? 1 : 0);
        agencyOpt.setAllowClientsWithoutWallet(allowClientsWithoutWallet ? 1 : 0);
        agencyOpt.setPreferredDealFeePercent(preferredDealFeePercent);
        getDirectJooqDbSteps().useShardForLogin(agencyLogin).agencyOptionsSteps().add(agencyOpt);
    }

    public void setAgencyOptions(String agencyLogin, boolean allowClientsWithoutWallet,
            boolean defaultClientsWithWallet)
    {
        setAgencyOptions(agencyLogin, allowClientsWithoutWallet, defaultClientsWithWallet,
                DEFAULT_PREFERRED_DEAL_FEE_PERCENT);
    }
    //endregion
}
