package ru.yandex.autotests.directapi.steps.banners;

import java.util.List;

import com.yandex.direct.api.v5.adgroups.AdGroupFieldEnum;
import com.yandex.direct.api.v5.adgroups.AdGroupGetItem;
import com.yandex.direct.api.v5.adgroups.AddRequest;
import com.yandex.direct.api.v5.adgroups.AddResponse;
import com.yandex.direct.api.v5.adgroups.DeleteRequest;
import com.yandex.direct.api.v5.adgroups.DeleteResponse;
import com.yandex.direct.api.v5.adgroups.GetRequest;
import com.yandex.direct.api.v5.adgroups.GetResponse;
import com.yandex.direct.api.v5.adgroups.UpdateRequest;
import com.yandex.direct.api.v5.adgroups.UpdateResponse;
import com.yandex.direct.api.v5.general.StatusEnum;

import ru.yandex.autotests.directapi.apiclient.RequestHeader;
import ru.yandex.autotests.directapi.apiclient.config.ConnectionConfig;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.version5.ServiceNames;
import ru.yandex.autotests.directapi.enums.AdGroupType;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.DeleteRequestMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.DynamicTextAdGroupMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.MobileAppAdGroupAddMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExceptionNotificationMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlApi5Error;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.steps.BaseApiSteps;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;


/**
 * Created by mariabye on 18.04.14.
 */
public class AdGroupsSteps extends BaseApiSteps {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    private static AdGroupsSteps _instance;

    private AdGroupsSteps(ConnectionConfig connectionConfig, RequestHeader requestHeader) {
        super(connectionConfig, requestHeader);
    }

    public static AdGroupsSteps getInstance(ConnectionConfig connectionConfig, RequestHeader requestHeader) {
        if (_instance == null) {
            _instance = new AdGroupsSteps(connectionConfig, requestHeader);
        } else {
            _instance.setConnectionConfig(connectionConfig);
            _instance.setRequestHeader(requestHeader);
        }
        return _instance;

    }

    //region Get
    @Step("[AdGroups]: Get")
    public GetResponse adGroupsGet(GetRequestMap parameters, String login) {
        return defaultClientV5()
                .invokeMethod(ServiceNames.AD_GROUPS, login, Action.GET, (GetRequest) parameters.getBean());
    }

    public GetResponse adGroupsGet(GetRequestMap parameters) {
        return adGroupsGet(parameters, null);
    }

    public List<AdGroupGetItem> adGroupsGetById(Long adGroupId) {
        return adGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(new AdGroupsSelectionCriteriaMap().withIds(adGroupId))
                        .withFieldNames(AdGroupFieldEnum.class.getEnumConstants()),
                null).getAdGroups();
    }

    public void expectErrorOnAdGroupsGet(GetRequestMap parameters, String login, Api5Error api5Error) {
        shouldGetErrorOn(ServiceNames.AD_GROUPS, login, Action.GET, parameters, api5Error);
    }

    public void expectErrorOnAdGroupsGet(GetRequestMap parameters, String login, JavaOrPerlApi5Error api5Error) {
        shouldGetErrorOn(ServiceNames.AD_GROUPS, login, Action.GET, parameters, api5Error);
    }

    public void expectErrorOnAdGroupsGet(GetRequestMap parameters, Api5Error api5Error) {
        expectErrorOnAdGroupsGet(parameters, null, api5Error);
    }

    public void expectErrorOnAdGroupsGet(GetRequestMap parameters, JavaOrPerlApi5Error api5Error) {
        expectErrorOnAdGroupsGet(parameters, null, api5Error);
    }

    public void expectErrorOnAdGroupsGet(Object parameters, String login, Api5Error api5Error) {
        shouldGetJSONErrorOn(ServiceNames.AD_GROUPS, login, Action.GET, parameters, api5Error);
    }

    public void expectErrorOnAdGroupsGet(Object parameters, String login, JavaOrPerlApi5Error api5Error) {
        shouldGetJSONErrorOn(ServiceNames.AD_GROUPS, login, Action.GET, parameters, api5Error);
    }

    public void expectErrorOnAdGroupsGet(Object parameters, Api5Error api5Error) {
        expectErrorOnAdGroupsGet(parameters, null, api5Error);
    }

    public void expectErrorOnAdGroupsGet(Object parameters, JavaOrPerlApi5Error api5Error) {
        expectErrorOnAdGroupsGet(parameters, null, api5Error);
    }

    public AdGroupGetItem getAdGroup(Long id, AdGroupFieldEnum... fieldNames) {
        if (fieldNames.length == 0) {
            fieldNames = AdGroupFieldEnum.values();
        }

        GetResponse response = adGroupsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap()
                                        .withIds(id)
                        )
                        .withFieldNames(fieldNames)
        );
        assumeThat("AdGroups.get вернул одну группу", response.getAdGroups(), hasSize(1));
        return response.getAdGroups().get(0);
    }

    public StatusEnum getGroupStatus(Long id) {
        return getAdGroup(id, AdGroupFieldEnum.STATUS).getStatus();
    }
    //endregion

    //region Add
    @Step("[AdGroups]: Add")
    public AddResponse adGroupsAdd(AddRequestMap parameters, String login) {
        return defaultClientV5()
                .invokeMethod(ServiceNames.AD_GROUPS, login, Action.ADD, (AddRequest) parameters.getBean());
    }

    public AddResponse adGroupsAdd(AddRequestMap parameters) {
        return adGroupsAdd(parameters, null);
    }

    public void expectErrorOnAdGroupsAdd(AddRequestMap parameters, String login, Api5Error api5Error) {
        shouldGetErrorOn(ServiceNames.AD_GROUPS, login, Action.ADD, parameters, api5Error);
    }

    public void expectErrorOnAdGroupsAdd(AddRequestMap parameters, String login, JavaOrPerlApi5Error api5Error) {
        shouldGetErrorOn(ServiceNames.AD_GROUPS, login, Action.ADD, parameters, api5Error);
    }

    public void expectErrorOnAdGroupsAdd(AddRequestMap parameters, Api5Error api5Error) {
        expectErrorOnAdGroupsAdd(parameters, null, api5Error);
    }

    public void expectErrorOnAdGroupsAdd(AddRequestMap parameters, JavaOrPerlApi5Error api5Error) {
        expectErrorOnAdGroupsAdd(parameters, null, api5Error);
    }

    public void expectErrorOnAdGroupsAdd(Object parameters, String login, Api5Error api5Error) {
        shouldGetJSONErrorOn(ServiceNames.AD_GROUPS, login, Action.ADD, parameters, api5Error);
    }

    public void expectErrorOnAdGroupsAdd(Object parameters, String login, JavaOrPerlApi5Error api5Error) {
        shouldGetJSONErrorOn(ServiceNames.AD_GROUPS, login, Action.ADD, parameters, api5Error);
    }

    public void expectErrorOnAdGroupsAdd(Object parameters, Api5Error api5Error) {
        expectErrorOnAdGroupsAdd(parameters, null, api5Error);
    }

    public void expectErrorOnAdGroupsAdd(Object parameters, JavaOrPerlApi5Error api5Error) {
        expectErrorOnAdGroupsAdd(parameters, null, api5Error);
    }

    public AddResponse shouldGetResultOnAdd(AddRequestMap parameters, String login, ExpectedResult... expectedResults) {
        return (AddResponse) shouldGetResultOn(ServiceNames.AD_GROUPS, login, Action.ADD, parameters, expectedResults);
    }

    public AddResponse shouldGetResultOnAdd(AddRequestMap parameters, String login,
                                            JavaOrPerlExpectedResult... expectedResults) {
        return (AddResponse) shouldGetResultOn(ServiceNames.AD_GROUPS, login, Action.ADD, parameters, expectedResults);
    }

    public AddResponse shouldGetResultOnAdd(AddRequestMap parameters, ExpectedResult... expectedResults) {
        return shouldGetResultOnAdd(parameters, null, expectedResults);
    }

    public AddResponse shouldGetResultOnAdd(AddRequestMap parameters, JavaOrPerlExpectedResult... expectedResults) {
        return shouldGetResultOnAdd(parameters, null, expectedResults);
    }

    public Long addGroup(AdGroupAddItemMap parameters, String login) {
        if (parameters.get("textAdGroupFeedParams") != null) {
            return shouldGetResultOnAdd(
                    new AddRequestMap().withAdGroups(parameters), login,
                    ExpectedResult.warningsIgnoringDetailsAndMessage(
                            new ExceptionNotificationMap().withCode(10165))
            ).getAddResults().get(0).getId();
        }

        return shouldGetResultOnAdd(new AddRequestMap().withAdGroups(parameters), login,
                ExpectedResult.success()).getAddResults().get(0).getId();
    }

    public Long addGroup(AdGroupAddItemMap parameters) {
        return addGroup(parameters, null);
    }

    public Long addDefaultMobileGroup(Integer campaignId) {
        return addDefaultMobileGroup(campaignId, null);
    }

    public Long addDefaultMobileGroup(Integer campaignId, String login) {
        return addGroup(new AdGroupAddItemMap().defaultAdGroupAddItem(campaignId.longValue())
                .withMobileAppAdGroup(new MobileAppAdGroupAddMap().defaultGroup()), login);
    }

    public Long addDefaultMobileGroup(Long campaignId) {
        return addDefaultMobileGroup(campaignId, null);
    }

    public Long addDefaultMobileGroup(Long campaignId, String login) {
        return addGroup(new AdGroupAddItemMap().defaultAdGroupAddItem(campaignId)
                .withMobileAppAdGroup(new MobileAppAdGroupAddMap().defaultGroup()), login);
    }

    public Long addDefaultGroupDynamic(Integer campaignId) {
        return addDefaultGroupDynamic(campaignId, null);
    }

    public Long addDefaultGroupDynamic(Integer campaignId, String login) {
        return addGroup(new AdGroupAddItemMap().defaultAdGroupAddItem(campaignId.longValue())
                .withDynamicTextAdGroup(new DynamicTextAdGroupMap().defaultGroup()), login);
    }

    public Long addDefaultGroupDynamic(Long campaignId) {
        return addDefaultGroupDynamic(campaignId, null);
    }

    public Long addDefaultGroupDynamic(Long campaignId, String login) {
        return addDefaultGroupDynamic(campaignId.intValue(), login);
    }

    public Long addDefaultGroupSmart(Long campaignId) {
        return addDefaultGroupSmart(campaignId, null);
    }

    public Long addDefaultGroupSmart(Long campaignId, String login) {
        return addDefaultGroupSmart(campaignId, login);
    }

    public Long addDefaultCpmBannerUserProfileAdGroup(Long campaignId) {
        return addDefaultCpmBannerUserProfileAdGroup(campaignId, null);
    }

    public Long addDefaultCpmBannerUserProfileAdGroup(Long campaignId, String login) {
        return addGroup(new AdGroupAddItemMap().defaultAdGroupAddItem(campaignId)
                .withCpmBannerUserProfileAdGroup(), login);
    }

    public Long addDefaultCpmBannerKeywordsAdGroup(Long campaignId) {
        return addDefaultCpmBannerKeywordsAdGroup(campaignId, null);
    }

    public Long addDefaultCpmBannerKeywordsAdGroup(Long campaignId, String login) {
        return addGroup(new AdGroupAddItemMap().defaultAdGroupAddItem(campaignId)
                .withCpmBannerKeywordsAdGroup(), login);
    }

    public Long addDefaultCpmVideoGroup(Long campaignId) {
        return addGroup(new AdGroupAddItemMap().defaultAdGroupAddItem(campaignId)
                .withCpmVdeoAdGroup());
    }

    public Long addDefaultCpmVideoAdGroup(Long campaignId, String login) {
        return addGroup(new AdGroupAddItemMap().defaultAdGroupAddItem(campaignId)
                .withCpmVdeoAdGroup(), login);
    }

    public Long addDefaultTextAdGroupWithFeedParams(Long campaignId, String login, Long feedId,
                                                    List<Long> categoryIds) {
        return addGroup(new AdGroupAddItemMap()
                .defaultAdGroupAddItem(campaignId)
                .withTextAdGroupFeedParams(feedId, categoryIds), login);
    }

    public Long addDefaultGroup(Integer campaignId, String login) {
        return addGroup(new AdGroupAddItemMap().defaultAdGroupAddItem(campaignId.longValue()), login);
    }

    public Long addDefaultGroup(Integer campaignId) {
        return addDefaultGroup(campaignId, null);
    }

    public Long addDefaultGroup(Long campaignId, String login) {
        return addGroup(new AdGroupAddItemMap().defaultAdGroupAddItem(campaignId), login);
    }

    public Long addDefaultGroup(Long campaignId) {
        return addDefaultGroup(campaignId, (String) null);
    }

    public Long addDefaultGroup(Long campaignId, String login, AdGroupType type) {
        return addGroup(new AdGroupAddItemMap().defaultAdGroupAddItem(campaignId).withDefaultGroup(type), login);
    }

    public Long addDefaultGroup(Long campaignId, AdGroupType type) {
        return addDefaultGroup(campaignId, null, type);
    }
//endregion

    //region Update
    @Step("[AdGroups]: Update")
    public UpdateResponse adGroupsUpdate(UpdateRequestMap parameters, String login) {
        return defaultClientV5()
                .invokeMethod(ServiceNames.AD_GROUPS, login, Action.UPDATE, (UpdateRequest) parameters.getBean());
    }

    public UpdateResponse adGroupsUpdate(UpdateRequestMap parameters) {
        return adGroupsUpdate(parameters, null);
    }

    public void expectErrorOnAdGroupsUpdate(UpdateRequestMap parameters, String login, Api5Error api5Error) {
        shouldGetErrorOn(ServiceNames.AD_GROUPS, login, Action.UPDATE, parameters, api5Error);
    }

    public void expectErrorOnAdGroupsUpdate(UpdateRequestMap parameters, String login, JavaOrPerlApi5Error api5Error) {
        shouldGetErrorOn(ServiceNames.AD_GROUPS, login, Action.UPDATE, parameters, api5Error);
    }

    public void expectErrorOnAdGroupsUpdate(UpdateRequestMap parameters, Api5Error api5Error) {
        expectErrorOnAdGroupsUpdate(parameters, null, api5Error);
    }

    public void expectErrorOnAdGroupsUpdate(UpdateRequestMap parameters, JavaOrPerlApi5Error api5Error) {
        expectErrorOnAdGroupsUpdate(parameters, null, api5Error);
    }

    public void expectErrorOnAdGroupsUpdate(Object parameters, String login, Api5Error api5Error) {
        shouldGetJSONErrorOn(ServiceNames.AD_GROUPS, login, Action.UPDATE, parameters, api5Error);
    }

    public void expectErrorOnAdGroupsUpdate(Object parameters, String login, JavaOrPerlApi5Error api5Error) {
        shouldGetJSONErrorOn(ServiceNames.AD_GROUPS, login, Action.UPDATE, parameters, api5Error);
    }

    public void expectErrorOnAdGroupsUpdate(Object parameters, Api5Error api5Error) {
        expectErrorOnAdGroupsUpdate(parameters, null, api5Error);
    }

    public void expectErrorOnAdGroupsUpdate(Object parameters, JavaOrPerlApi5Error api5Error) {
        expectErrorOnAdGroupsUpdate(parameters, null, api5Error);
    }

    public UpdateResponse shouldGetResultOnUpdate(
            UpdateRequestMap parameters, String login, ExpectedResult... expectedResults) {
        return (UpdateResponse) shouldGetResultOn(ServiceNames.AD_GROUPS, login, Action.UPDATE, parameters,
                expectedResults);
    }

    public UpdateResponse shouldGetResultOnUpdate(
            UpdateRequestMap parameters, String login, JavaOrPerlExpectedResult... expectedResults) {
        return (UpdateResponse) shouldGetResultOn(ServiceNames.AD_GROUPS, login, Action.UPDATE, parameters,
                expectedResults);
    }

    public UpdateResponse shouldGetResultOnUpdate(UpdateRequestMap parameters, ExpectedResult... expectedResults) {
        return shouldGetResultOnUpdate(parameters, null, expectedResults);
    }

    public UpdateResponse shouldGetResultOnUpdate(UpdateRequestMap parameters,
                                                  JavaOrPerlExpectedResult... expectedResults) {
        return shouldGetResultOnUpdate(parameters, null, expectedResults);
    }
    //endregion

    //region Delete
    @Step("[AdGroups]: Delete")
    public DeleteResponse adGroupsDelete(DeleteRequestMap parameters, String login) {
        return defaultClientV5()
                .invokeMethod(ServiceNames.AD_GROUPS, login, Action.DELETE, (DeleteRequest) parameters.getBean());
    }

    public DeleteResponse adGroupsDelete(DeleteRequestMap parameters) {
        return adGroupsDelete(parameters, null);
    }

    public void deleteGroup(Long id) {
        deleteGroup(null, id);
    }

    public void deleteGroup(String login, Long id) {
        shouldGetResultOnDelete(
                new DeleteRequestMap()
                        .withSelectionCriteria(new IdsCriteriaMap().withIds(id)),
                login,
                ExpectedResult.success());
    }

    public void expectErrorOnAdGroupsDelete(
            DeleteRequestMap parameters, String login, Api5Error api5Error) {
        shouldGetErrorOn(ServiceNames.AD_GROUPS, login, Action.DELETE, parameters, api5Error);
    }

    public void expectErrorOnAdGroupsDelete(
            DeleteRequestMap parameters, String login, JavaOrPerlApi5Error api5Error) {
        shouldGetErrorOn(ServiceNames.AD_GROUPS, login, Action.DELETE, parameters, api5Error);
    }

    public void expectErrorOnAdGroupsDelete(DeleteRequestMap parameters, Api5Error api5Error) {
        expectErrorOnAdGroupsDelete(parameters, null, api5Error);
    }

    public void expectErrorOnAdGroupsDelete(DeleteRequestMap parameters, JavaOrPerlApi5Error api5Error) {
        expectErrorOnAdGroupsDelete(parameters, null, api5Error);
    }

    public void expectErrorOnAdGroupsDelete(Object parameters, String login, Api5Error api5Error) {
        shouldGetJSONErrorOn(ServiceNames.AD_GROUPS, login, Action.DELETE, parameters, api5Error);
    }

    public void expectErrorOnAdGroupsDelete(Object parameters, String login, JavaOrPerlApi5Error api5Error) {
        shouldGetJSONErrorOn(ServiceNames.AD_GROUPS, login, Action.DELETE, parameters, api5Error);
    }

    public void expectErrorOnAdGroupsDelete(Object parameters, Api5Error api5Error) {
        expectErrorOnAdGroupsDelete(parameters, null, api5Error);
    }

    public void expectErrorOnAdGroupsDelete(Object parameters, JavaOrPerlApi5Error api5Error) {
        expectErrorOnAdGroupsDelete(parameters, null, api5Error);
    }

    public DeleteResponse shouldGetResultOnDelete(
            DeleteRequestMap parameters, String login, ExpectedResult... expectedResults) {
        return (DeleteResponse) shouldGetResultOn(ServiceNames.AD_GROUPS, login, Action.DELETE, parameters,
                expectedResults);
    }

    public DeleteResponse shouldGetResultOnDelete(DeleteRequestMap parameters, ExpectedResult... expectedResults) {
        return shouldGetResultOnDelete(parameters, null, expectedResults);
    }
    //endregion
}
