package ru.yandex.autotests.directapi.steps.banners;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AddRequest;
import com.yandex.direct.api.v5.ads.AddResponse;
import com.yandex.direct.api.v5.ads.ArchiveRequest;
import com.yandex.direct.api.v5.ads.ArchiveResponse;
import com.yandex.direct.api.v5.ads.DeleteRequest;
import com.yandex.direct.api.v5.ads.DeleteResponse;
import com.yandex.direct.api.v5.ads.GetRequest;
import com.yandex.direct.api.v5.ads.GetResponse;
import com.yandex.direct.api.v5.ads.ModerateRequest;
import com.yandex.direct.api.v5.ads.ModerateResponse;
import com.yandex.direct.api.v5.ads.ResumeRequest;
import com.yandex.direct.api.v5.ads.ResumeResponse;
import com.yandex.direct.api.v5.ads.SuspendRequest;
import com.yandex.direct.api.v5.ads.SuspendResponse;
import com.yandex.direct.api.v5.ads.TextAdFieldEnum;
import com.yandex.direct.api.v5.ads.UnarchiveRequest;
import com.yandex.direct.api.v5.ads.UnarchiveResponse;
import com.yandex.direct.api.v5.ads.UpdateRequest;
import com.yandex.direct.api.v5.ads.UpdateResponse;
import com.yandex.direct.api.v5.general.ActionResult;
import com.yandex.direct.api.v5.general.StateEnum;
import com.yandex.direct.api.v5.general.StatusEnum;

import ru.yandex.autotests.directapi.apiclient.RequestHeader;
import ru.yandex.autotests.directapi.apiclient.config.ConnectionConfig;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.version5.ServiceNames;
import ru.yandex.autotests.directapi.enums.AdGroupType;
import ru.yandex.autotests.directapi.enums.BannerType;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.ArchiveRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.CpcVideoAdBuilderAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.CpmBannerAdBuilderAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.DeleteRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.DynamicTextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdBuilderAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppCpcVideoAdBuilderAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppImageAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.ModerateRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.ResumeRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.SuspendRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdBuilderAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextImageAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.UnarchiveRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlApi5Error;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.steps.BaseApiSteps;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ch.lambdaj.Lambda.extract;
import static ch.lambdaj.Lambda.filter;
import static ch.lambdaj.Lambda.on;
import static org.apache.commons.lang3.RandomStringUtils.random;
import static org.apache.commons.lang3.RandomStringUtils.randomAlphabetic;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pavryabov on 19.03.15.
 */
public class AdsSteps extends BaseApiSteps {

    public static final String NARROW_CHARACTERS = ".,!:;\"";
    public static final int MAX_NUMBER_OF_NARROW_CHARACTERS = 15;

    private LogSteps log = LogSteps.getLogger(this.getClass());

    private static AdsSteps _instance;

    private AdsSteps(ConnectionConfig connectionConfig, RequestHeader requestHeader) {
        super(connectionConfig, requestHeader);
    }

    public static AdsSteps getInstance(ConnectionConfig connectionConfig, RequestHeader requestHeader) {
        if (_instance == null) {
            _instance = new AdsSteps(connectionConfig, requestHeader);
        } else {
            _instance.setConnectionConfig(connectionConfig);
            _instance.setRequestHeader(requestHeader);
        }
        return _instance;
    }


    public Callable<Boolean> statusChanged(final Long adId, final StatusEnum value) {
        return () -> adsGet(
                new GetRequestMap()
                        .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                        .withFieldNames(AdFieldEnum.STATUS)
        ).getAds().get(0).getStatus().equals(value);
    }

    public Callable<Boolean> stateChanged(final Long adId, final StateEnum value) {
        return () -> adsGet(
                new GetRequestMap()
                        .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                        .withFieldNames(AdFieldEnum.STATE)
        ).getAds().get(0).getState().equals(value);
    }

    //region Get
    @Step("[Ads]: Get")
    public GetResponse adsGet(GetRequestMap parameters, String login) {
        return defaultClientV5().invokeMethod(ServiceNames.ADS, login, Action.GET, (GetRequest) parameters.getBean());
    }

    public GetResponse adsGet(GetRequestMap parameters) {
        return adsGet(parameters, null);
    }

    public void expectErrorOnAdsGet(GetRequestMap parameters, String login, Api5Error api5Error) {
        shouldGetErrorOn(ServiceNames.ADS, login, Action.GET, parameters, api5Error);
    }

    public void expectErrorOnAdsGet(GetRequestMap parameters, Api5Error api5Error) {
        expectErrorOnAdsGet(parameters, null, api5Error);
    }

    public void expectErrorOnAdsGet(GetRequestMap parameters, JavaOrPerlApi5Error api5Error) {
        shouldGetErrorOn(ServiceNames.ADS, null, Action.GET, parameters, api5Error);
    }

    public void expectErrorOnAdsGet(Object parameters, String login, Api5Error api5Error) {
        shouldGetJSONErrorOn(ServiceNames.ADS, login, Action.GET, parameters, api5Error);
    }

    public void expectErrorOnAdsGet(Object parameters, Api5Error api5Error) {
        expectErrorOnAdsGet(parameters, null, api5Error);
    }

    public void expectErrorOnAdsGet(Object parameters, JavaOrPerlApi5Error api5Error) {
        shouldGetJSONErrorOn(ServiceNames.ADS, null, Action.GET, parameters, api5Error);
    }
    //endregion

    //region Suspend
    @Step("[Ads]: Suspend")
    public SuspendResponse adsSuspend(SuspendRequestMap parameters, String login) {
        return defaultClientV5()
                .invokeMethod(ServiceNames.ADS, login, Action.SUSPEND, (SuspendRequest) parameters.getBean());
    }

    public SuspendResponse adsSuspend(SuspendRequestMap parameters) {
        return adsSuspend(parameters, null);
    }

    /**
     * Останавливает показы объявлений
     * <p>
     * При вызове метода выполняется проверка на успешность операции. Если нужно вызвать метод без проверки
     * стоит обращаться к более низкоуровневым {@link AdsSteps#adsSuspend(SuspendRequestMap)}
     * или {@link AdsSteps#adsSuspend(SuspendRequestMap, String)}
     */
    public SuspendResponse adsSuspend(String login, Long... ids) {
        SuspendResponse response = adsSuspend(
                new SuspendRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds(ids)), login);
        checkResponseErrors(response.getSuspendResults());
        return response;
    }

    /**
     * Останавливает показы объявлений
     * <p>
     * При вызове метода выполняется проверка на успешность операции. Если нужно вызвать метод без проверки
     * стоит обращаться к более низкоуровневым {@link AdsSteps#adsSuspend(SuspendRequestMap)}
     * или {@link AdsSteps#adsSuspend(SuspendRequestMap, String)}
     */
    public SuspendResponse adsSuspend(Long... ids) {
        return adsSuspend(null, ids);
    }

    public SuspendResponse shouldGetResultOnSuspend(
            SuspendRequestMap parameters, String login, ExpectedResult... expectedResults)
    {
        return (SuspendResponse) shouldGetResultOn(ServiceNames.ADS, login, Action.SUSPEND, parameters,
                expectedResults);
    }

    public SuspendResponse shouldGetResultOnSuspend(SuspendRequestMap parameters, ExpectedResult... expectedResults) {
        return shouldGetResultOnSuspend(parameters, null, expectedResults);
    }

    public SuspendResponse shouldGetResultOnSuspend(
            IdsCriteriaMap parameters, String login, ExpectedResult... expectedResults)
    {
        return (SuspendResponse) shouldGetResultOn(ServiceNames.ADS, login, Action.SUSPEND,
                new SuspendRequestMap().withSelectionCriteria(parameters), expectedResults);
    }

    public SuspendResponse shouldGetResultOnSuspend(
            IdsCriteriaMap parameters, String login, JavaOrPerlExpectedResult... expectedResults)
    {
        return (SuspendResponse) shouldGetResultOn(ServiceNames.ADS, login, Action.SUSPEND,
                new SuspendRequestMap().withSelectionCriteria(parameters), expectedResults);
    }

    public SuspendResponse shouldGetResultOnSuspend(IdsCriteriaMap parameters, ExpectedResult... expectedResults) {
        return shouldGetResultOnSuspend(parameters, null, expectedResults);
    }

    public SuspendResponse shouldGetResultOnSuspend(IdsCriteriaMap parameters,
            JavaOrPerlExpectedResult... expectedResults)
    {
        return shouldGetResultOnSuspend(parameters, null, expectedResults);
    }

    public void expectErrorOnAdsSuspend(SuspendRequestMap parameters, String login, Api5Error api5Error) {
        shouldGetErrorOn(ServiceNames.ADS, login, Action.SUSPEND, parameters, api5Error);
    }

    public void expectErrorOnAdsSuspend(SuspendRequestMap parameters, Api5Error api5Error) {
        expectErrorOnAdsSuspend(parameters, null, api5Error);
    }

    public void expectErrorOnAdsSuspend(Object parameters, String login, Api5Error api5Error) {
        shouldGetJSONErrorOn(ServiceNames.ADS, login, Action.SUSPEND, parameters, api5Error);
    }

    public void expectErrorOnAdsSuspend(Object parameters, Api5Error api5Error) {
        expectErrorOnAdsSuspend(parameters, null, api5Error);
    }
    //endregion

    //region Resume
    @Step("[Ads]: Resume")
    public ResumeResponse adsResume(ResumeRequestMap parameters, String login) {
        return defaultClientV5()
                .invokeMethod(ServiceNames.ADS, login, Action.RESUME, (ResumeRequest) parameters.getBean());
    }

    public ResumeResponse adsResume(ResumeRequestMap parameters) {
        return adsResume(parameters, null);
    }

    /**
     * Возобновляет показы объявлений
     * <p>
     * При вызове метода выполняется проверка на успешность операции. Если нужно вызвать метод без проверки
     * стоит обращаться к более низкоуровневым {@link AdsSteps#adsResume(ResumeRequestMap)}
     * или {@link AdsSteps#adsResume(ResumeRequestMap, String)}
     */
    public ResumeResponse adsResume(String login, Long... ids) {
        ResumeResponse response = adsResume(
                new ResumeRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds(ids)), login);
        checkResponseErrors(response.getResumeResults());
        return response;
    }

    /**
     * Возобновляет показы объявлений
     * <p>
     * При вызове метода выполняется проверка на успешность операции. Если нужно вызвать метод без проверки
     * стоит обращаться к более низкоуровневым {@link AdsSteps#adsResume(ResumeRequestMap)}
     * или {@link AdsSteps#adsResume(ResumeRequestMap, String)}
     */
    public ResumeResponse adsResume(Long... ids) {
        return adsResume(null, ids);
    }

    public ResumeResponse shouldGetResultOnResume(
            ResumeRequestMap parameters, String login, ExpectedResult... expectedResults)
    {
        return (ResumeResponse) shouldGetResultOn(ServiceNames.ADS, login, Action.RESUME, parameters, expectedResults);
    }

    public ResumeResponse shouldGetResultOnResume(ResumeRequestMap parameters, ExpectedResult... expectedResults) {
        return shouldGetResultOnResume(parameters, null, expectedResults);
    }

    public ResumeResponse shouldGetResultOnResume(
            IdsCriteriaMap parameters, String login, ExpectedResult... expectedResults)
    {
        return (ResumeResponse) shouldGetResultOn(ServiceNames.ADS, login, Action.RESUME,
                new ResumeRequestMap().withSelectionCriteria(parameters), expectedResults);
    }

    public ResumeResponse shouldGetResultOnResume(
            IdsCriteriaMap parameters, String login, JavaOrPerlExpectedResult... expectedResults)
    {
        return (ResumeResponse) shouldGetResultOn(ServiceNames.ADS, login, Action.RESUME,
                new ResumeRequestMap().withSelectionCriteria(parameters), expectedResults);
    }

    public ResumeResponse shouldGetResultOnResume(IdsCriteriaMap parameters, ExpectedResult... expectedResults) {
        return shouldGetResultOnResume(parameters, null, expectedResults);
    }

    public ResumeResponse shouldGetResultOnResume(IdsCriteriaMap parameters,
            JavaOrPerlExpectedResult... expectedResults)
    {
        return shouldGetResultOnResume(parameters, null, expectedResults);
    }

    public void expectErrorOnAdsResume(ResumeRequestMap parameters, String login, Api5Error api5Error) {
        shouldGetErrorOn(ServiceNames.ADS, login, Action.RESUME, parameters, api5Error);
    }

    public void expectErrorOnAdsResume(ResumeRequestMap parameters, Api5Error api5Error) {
        expectErrorOnAdsResume(parameters, null, api5Error);
    }

    public void expectErrorOnAdsResume(Object parameters, String login, Api5Error api5Error) {
        shouldGetJSONErrorOn(ServiceNames.ADS, login, Action.RESUME, parameters, api5Error);
    }

    public void expectErrorOnAdsResume(Object parameters, Api5Error api5Error) {
        expectErrorOnAdsResume(parameters, null, api5Error);
    }
    //endregion

    //region Archive
    @Step("[Ads]: Archive")
    public ArchiveResponse adsArchive(ArchiveRequestMap parameters, String login) {
        return defaultClientV5()
                .invokeMethod(ServiceNames.ADS, login, Action.ARCHIVE, (ArchiveRequest) parameters.getBean());
    }

    public ArchiveResponse adsArchive(ArchiveRequestMap parameters) {
        return adsArchive(parameters, null);
    }

    /**
     * Архивирует объявления
     * <p>
     * При вызове метода выполняется проверка на успешность операции. Если нужно вызвать метод без проверки
     * стоит обращаться к более низкоуровневым {@link AdsSteps#adsArchive(ArchiveRequestMap)}
     * или {@link AdsSteps#adsArchive(ArchiveRequestMap, String)}
     */
    public ArchiveResponse adsArchive(String login, Long... ids) {
        ArchiveResponse response = adsArchive(
                new ArchiveRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds(ids)), login);
        checkResponseErrors(response.getArchiveResults());
        return response;
    }

    /**
     * Архивирует объявления
     * <p>
     * При вызове метода выполняется проверка на успешность операции. Если нужно вызвать метод без проверки
     * стоит обращаться к более низкоуровневым {@link AdsSteps#adsArchive(ArchiveRequestMap)}
     * или {@link AdsSteps#adsArchive(ArchiveRequestMap, String)}
     */
    public ArchiveResponse adsArchive(Long... ids) {
        return adsArchive(null, ids);
    }

    public ArchiveResponse shouldGetResultOnArchive(
            ArchiveRequestMap parameters, String login, ExpectedResult... expectedResults)
    {
        return (ArchiveResponse) shouldGetResultOn(ServiceNames.ADS, login, Action.ARCHIVE, parameters,
                expectedResults);
    }

    public ArchiveResponse shouldGetResultOnArchive(
            ArchiveRequestMap parameters, String login, JavaOrPerlExpectedResult... expectedResults)
    {
        return (ArchiveResponse) shouldGetResultOn(ServiceNames.ADS, login, Action.ARCHIVE, parameters,
                expectedResults);
    }

    public ArchiveResponse shouldGetResultOnArchive(ArchiveRequestMap parameters, ExpectedResult... expectedResults) {
        return shouldGetResultOnArchive(parameters, null, expectedResults);
    }

    public ArchiveResponse shouldGetResultOnArchive(ArchiveRequestMap parameters,
            JavaOrPerlExpectedResult... expectedResults)
    {
        return shouldGetResultOnArchive(parameters, null, expectedResults);
    }

    public ArchiveResponse shouldGetResultOnArchive(
            IdsCriteriaMap parameters, String login, ExpectedResult... expectedResults)
    {
        return (ArchiveResponse) shouldGetResultOn(ServiceNames.ADS, login, Action.ARCHIVE,
                new ArchiveRequestMap().withSelectionCriteria(parameters), expectedResults);
    }

    public ArchiveResponse shouldGetResultOnArchive(IdsCriteriaMap parameters, String login,
            JavaOrPerlExpectedResult... expectedResults)
    {
        return (ArchiveResponse) shouldGetResultOn(ServiceNames.ADS, login, Action.ARCHIVE,
                new ArchiveRequestMap().withSelectionCriteria(parameters), expectedResults);
    }

    public ArchiveResponse shouldGetResultOnArchive(IdsCriteriaMap parameters, ExpectedResult... expectedResults) {
        return shouldGetResultOnArchive(parameters, null, expectedResults);
    }

    public void expectErrorOnAdsArchive(ArchiveRequestMap parameters, String login, Api5Error api5Error) {
        shouldGetErrorOn(ServiceNames.ADS, login, Action.ARCHIVE, parameters, api5Error);
    }

    public void expectErrorOnAdsArchive(ArchiveRequestMap parameters, Api5Error api5Error) {
        expectErrorOnAdsArchive(parameters, null, api5Error);
    }

    public void expectErrorOnAdsArchive(Object parameters, String login, Api5Error api5Error) {
        shouldGetJSONErrorOn(ServiceNames.ADS, login, Action.ARCHIVE, parameters, api5Error);
    }

    public void expectErrorOnAdsArchive(Object parameters, Api5Error api5Error) {
        expectErrorOnAdsArchive(parameters, null, api5Error);
    }
    //endregion

    //region Unarchive
    @Step("[Ads]: Unarchive")
    public UnarchiveResponse adsUnarchive(UnarchiveRequestMap parameters, String login) {
        return defaultClientV5()
                .invokeMethod(ServiceNames.ADS, login, Action.UNARCHIVE, (UnarchiveRequest) parameters.getBean());
    }

    public UnarchiveResponse adsUnarchive(String login, Long... ids) {
        return adsUnarchive(new UnarchiveRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds(ids)), login);
    }

    public UnarchiveResponse adsUnarchive(Long... ids) {
        return adsUnarchive(null, ids);
    }

    public UnarchiveResponse adsUnarchive(UnarchiveRequestMap parameters) {
        return adsUnarchive(parameters, null);
    }

    public UnarchiveResponse shouldGetResultOnUnarchive(
            UnarchiveRequestMap parameters, String login, ExpectedResult... expectedResults)
    {
        return (UnarchiveResponse) shouldGetResultOn(ServiceNames.ADS, login, Action.UNARCHIVE, parameters,
                expectedResults);
    }

    public UnarchiveResponse shouldGetResultOnUnarchive(UnarchiveRequestMap parameters,
            ExpectedResult... expectedResults)
    {
        return shouldGetResultOnUnarchive(parameters, null, expectedResults);
    }

    public UnarchiveResponse shouldGetResultOnUnarchive(
            IdsCriteriaMap parameters, String login, ExpectedResult... expectedResults)
    {
        return (UnarchiveResponse) shouldGetResultOn(ServiceNames.ADS, login, Action.UNARCHIVE,
                new UnarchiveRequestMap().withSelectionCriteria(parameters), expectedResults);
    }

    public UnarchiveResponse shouldGetResultOnUnarchive(IdsCriteriaMap parameters, String login,
            JavaOrPerlExpectedResult... expectedResults)
    {
        return (UnarchiveResponse) shouldGetResultOn(ServiceNames.ADS, login, Action.UNARCHIVE,
                new UnarchiveRequestMap().withSelectionCriteria(parameters), expectedResults);
    }

    public UnarchiveResponse shouldGetResultOnUnarchive(IdsCriteriaMap parameters, ExpectedResult... expectedResults) {
        return shouldGetResultOnUnarchive(parameters, null, expectedResults);
    }

    public void expectErrorOnAdsUnarchive(UnarchiveRequestMap parameters, String login, Api5Error api5Error) {
        shouldGetErrorOn(ServiceNames.ADS, login, Action.UNARCHIVE, parameters, api5Error);
    }

    public void expectErrorOnAdsUnarchive(UnarchiveRequestMap parameters, Api5Error api5Error) {
        expectErrorOnAdsUnarchive(parameters, null, api5Error);
    }

    public void expectErrorOnAdsUnarchive(Object parameters, String login, Api5Error api5Error) {
        shouldGetJSONErrorOn(ServiceNames.ADS, login, Action.UNARCHIVE, parameters, api5Error);
    }

    public void expectErrorOnAdsUnarchive(Object parameters, Api5Error api5Error) {
        expectErrorOnAdsUnarchive(parameters, null, api5Error);
    }
    //endregion

    //region Moderate
    @Step("[Ads]: Moderate")
    public ModerateResponse adsModerate(ModerateRequestMap parameters, String login) {
        return defaultClientV5()
                .invokeMethod(ServiceNames.ADS, login, Action.MODERATE, (ModerateRequest) parameters.getBean());
    }

    public ModerateResponse adsModerate(ModerateRequestMap parameters) {
        return adsModerate(parameters, null);
    }

    public ModerateResponse adsModerate(String login, Long... ids) {
        return adsModerate(new ModerateRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds(ids)), login);
    }

    public ModerateResponse adsModerate(Long... ids) {
        return adsModerate(null, ids);
    }


    public ModerateResponse shouldGetResultOnModerate(
            ModerateRequestMap parameters, String login, ExpectedResult... expectedResults)
    {
        return (ModerateResponse) shouldGetResultOn(ServiceNames.ADS, login, Action.MODERATE, parameters,
                expectedResults);
    }

    public ModerateResponse shouldGetResultOnModerate(ModerateRequestMap parameters,
            ExpectedResult... expectedResults)
    {
        return shouldGetResultOnModerate(parameters, null, expectedResults);
    }

    public ModerateResponse shouldGetResultOnModerate(
            IdsCriteriaMap parameters, String login, ExpectedResult... expectedResults)
    {
        return (ModerateResponse) shouldGetResultOn(ServiceNames.ADS, login, Action.MODERATE,
                new ModerateRequestMap().withSelectionCriteria(parameters), expectedResults);
    }

    public ModerateResponse shouldGetResultOnModerate(
            IdsCriteriaMap parameters, String login, JavaOrPerlExpectedResult... expectedResults)
    {
        return (ModerateResponse) shouldGetResultOn(ServiceNames.ADS, login, Action.MODERATE,
                new ModerateRequestMap().withSelectionCriteria(parameters), expectedResults);
    }

    public ModerateResponse shouldGetResultOnModerate(IdsCriteriaMap parameters, ExpectedResult... expectedResults) {
        return shouldGetResultOnModerate(parameters, null, expectedResults);
    }

    public ModerateResponse shouldGetResultOnModerate(IdsCriteriaMap parameters,
            JavaOrPerlExpectedResult... expectedResults) {
        return shouldGetResultOnModerate(parameters, null, expectedResults);
    }

    public void expectErrorOnAdsModerate(ModerateRequestMap parameters, String login, Api5Error api5Error) {
        shouldGetErrorOn(ServiceNames.ADS, login, Action.MODERATE, parameters, api5Error);
    }

    public void expectErrorOnAdsModerate(ModerateRequestMap parameters, String login, JavaOrPerlApi5Error api5Error) {
        shouldGetErrorOn(ServiceNames.ADS, login, Action.MODERATE, parameters, api5Error);
    }

    public void expectErrorOnAdsModerate(ModerateRequestMap parameters, Api5Error api5Error) {
        expectErrorOnAdsModerate(parameters, null, api5Error);
    }

    public void expectErrorOnAdsModerate(ModerateRequestMap parameters, JavaOrPerlApi5Error api5Error) {
        expectErrorOnAdsModerate(parameters, null, api5Error);
    }

    public void expectErrorOnAdsModerate(Object parameters, String login, Api5Error api5Error) {
        shouldGetJSONErrorOn(ServiceNames.ADS, login, Action.MODERATE, parameters, api5Error);
    }

    public void expectErrorOnAdsModerate(Object parameters, String login, JavaOrPerlApi5Error api5Error) {
        shouldGetJSONErrorOn(ServiceNames.ADS, login, Action.MODERATE, parameters, api5Error);
    }

    public void expectErrorOnAdsModerate(Object parameters, Api5Error api5Error) {
        expectErrorOnAdsModerate(parameters, null, api5Error);
    }

    public void expectErrorOnAdsModerate(Object parameters, JavaOrPerlApi5Error api5Error) {
        expectErrorOnAdsModerate(parameters, null, api5Error);
    }
    //endregion

    //region Delete
    @Step("[Ads]: Delete")
    public DeleteResponse adsDelete(DeleteRequestMap parameters, String login) {
        return defaultClientV5()
                .invokeMethod(ServiceNames.ADS, login, Action.DELETE, (DeleteRequest) parameters.getBean());
    }

    public DeleteResponse adsDelete(DeleteRequestMap parameters) {
        return adsDelete(parameters, null);
    }

    public DeleteResponse adsDelete(String login, Long... ids) {
        return adsDelete(new DeleteRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds(ids)), login);
    }

    public DeleteResponse adsDelete(Long... ids) {
        return adsDelete(null, ids);
    }

    public DeleteResponse shouldGetResultOnDelete(
            DeleteRequestMap parameters, String login, ExpectedResult... expectedResults)
    {
        return (DeleteResponse) shouldGetResultOn(ServiceNames.ADS, login, Action.DELETE, parameters, expectedResults);
    }

    public DeleteResponse shouldGetResultOnDelete(DeleteRequestMap parameters, ExpectedResult... expectedResults) {
        return shouldGetResultOnDelete(parameters, null, expectedResults);
    }

    public DeleteResponse shouldGetResultOnDelete(
            IdsCriteriaMap parameters, String login, ExpectedResult... expectedResults)
    {
        return (DeleteResponse) shouldGetResultOn(ServiceNames.ADS, login, Action.DELETE,
                new DeleteRequestMap().withSelectionCriteria(parameters), expectedResults);
    }

    public DeleteResponse shouldGetResultOnDelete(
            IdsCriteriaMap parameters, String login, JavaOrPerlExpectedResult... expectedResults)
    {
        return (DeleteResponse) shouldGetResultOn(ServiceNames.ADS, login, Action.DELETE,
                new DeleteRequestMap().withSelectionCriteria(parameters), expectedResults);
    }

    public DeleteResponse shouldGetResultOnDelete(IdsCriteriaMap parameters, ExpectedResult... expectedResults) {
        return shouldGetResultOnDelete(parameters, null, expectedResults);
    }

    public DeleteResponse shouldGetResultOnDelete(IdsCriteriaMap parameters,
            JavaOrPerlExpectedResult... expectedResults)
    {
        return shouldGetResultOnDelete(parameters, null, expectedResults);
    }

    public void expectErrorOnAdsDelete(DeleteRequestMap parameters, String login, Api5Error api5Error) {
        shouldGetErrorOn(ServiceNames.ADS, login, Action.DELETE, parameters, api5Error);
    }

    public void expectErrorOnAdsDelete(DeleteRequestMap parameters, String login, JavaOrPerlApi5Error api5Error) {
        shouldGetErrorOn(ServiceNames.ADS, login, Action.DELETE, parameters, api5Error);
    }

    public void expectErrorOnAdsDelete(DeleteRequestMap parameters, Api5Error api5Error) {
        expectErrorOnAdsDelete(parameters, null, api5Error);
    }

    public void expectErrorOnAdsDelete(DeleteRequestMap parameters, JavaOrPerlApi5Error api5Error) {
        expectErrorOnAdsDelete(parameters, null, api5Error);
    }

    public void expectErrorOnAdsDelete(Object parameters, String login, Api5Error api5Error) {
        shouldGetJSONErrorOn(ServiceNames.ADS, login, Action.DELETE, parameters, api5Error);
    }

    public void expectErrorOnAdsDelete(Object parameters, String login, JavaOrPerlApi5Error api5Error) {
        shouldGetJSONErrorOn(ServiceNames.ADS, login, Action.DELETE, parameters, api5Error);
    }

    public void expectErrorOnAdsDelete(Object parameters, Api5Error api5Error) {
        expectErrorOnAdsDelete(parameters, null, api5Error);
    }

    public void expectErrorOnAdsDelete(Object parameters, JavaOrPerlApi5Error api5Error) {
        expectErrorOnAdsDelete(parameters, null, api5Error);
    }
    //endregion

    //region Add
    @Step("[Ads]: Add")
    public AddResponse adsAdd(AddRequestMap parameters, String login) {
        return defaultClientV5().invokeMethod(ServiceNames.ADS, login, Action.ADD, (AddRequest) parameters.getBean());
    }

    public AddResponse adsAdd(AddRequestMap parameters) {
        return adsAdd(parameters, null);
    }

    public AddResponse shouldGetResultOnAdd(
            AddRequestMap parameters, String login, ExpectedResult... expectedResults)
    {
        return (AddResponse) shouldGetResultOn(ServiceNames.ADS, login, Action.ADD, parameters, expectedResults);
    }

    public AddResponse shouldGetResultOnAdd(AddRequestMap parameters, JavaOrPerlExpectedResult... expectedResults) {
        return (AddResponse) shouldGetResultOn(ServiceNames.ADS, null, Action.ADD, parameters, expectedResults);
    }

    public AddResponse shouldGetResultOnAdd(AddRequestMap parameters, ExpectedResult... expectedResults) {
        return shouldGetResultOnAdd(parameters, null, expectedResults);
    }

    public void expectErrorOnAdsAdd(AddRequestMap parameters, String login, Api5Error api5Error) {
        shouldGetErrorOn(ServiceNames.ADS, login, Action.ADD, parameters, api5Error);
    }

    public void expectErrorOnAdsAdd(AddRequestMap parameters, String login, JavaOrPerlApi5Error api5Error) {
        shouldGetErrorOn(ServiceNames.ADS, login, Action.ADD, parameters, api5Error);
    }

    public void expectErrorOnAdsAdd(Object parameters, JavaOrPerlApi5Error api5Error) {
        shouldGetJSONErrorOn(ServiceNames.ADS, null, Action.ADD, parameters, api5Error);
    }

    public void expectErrorOnAdsAdd(AddRequestMap parameters, Api5Error api5Error) {
        expectErrorOnAdsAdd(parameters, null, api5Error);
    }

    public void expectErrorOnAdsAdd(Object parameters, String login, Api5Error api5Error) {
        shouldGetJSONErrorOn(ServiceNames.ADS, login, Action.ADD, parameters, api5Error);
    }


    public void expectErrorOnAdsAdd(AddRequestMap parameters, JavaOrPerlApi5Error api5Error) {
        expectErrorOnAdsAdd(parameters, null, api5Error);
    }

    public void expectErrorOnAdsAdd(Object parameters, Api5Error api5Error) {
        expectErrorOnAdsAdd(parameters, null, api5Error);
    }

    public Long addAd(AdAddItemMap adAddItemMap, String login) {
        AddResponse response = adsAdd(new AddRequestMap().withAds(adAddItemMap), login);
        List<Long> ids = extractIdsFromAddResponse(response);
        assumeThat("создан один баннер", ids, hasSize(1));
        return ids.get(0);
    }

    public Long addAd(AdAddItemMap adAddItemMap) {
        return addAd(adAddItemMap, null);
    }

    public Long addDefaultTextAd(Long adGroupId, String login) {
        return addAd(new AdAddItemMap().withTextAd(new TextAdAddMap().defaultTextAd()).withAdGroupId(adGroupId), login);
    }

    public Long addDefaultTextAd(Long adGroupId) {
        return addDefaultTextAd(adGroupId, null);
    }

    public List<Long> addDefaultTextAds(Long adGroupId, String login, int amount) {
        AdAddItemMap[] adAddItemMaps = new AdAddItemMap[amount];
        Arrays.fill(adAddItemMaps, new AdAddItemMap()
                .withAdGroupId(adGroupId)
                .withTextAd(new TextAdAddMap()
                        .defaultTextAd()));
        AddResponse response = adsAdd(new AddRequestMap().withAds(adAddItemMaps), login);
        List<Long> ids = extractIdsFromAddResponse(response);
        assumeThat(String.format("создано %d текстовых объявлений", amount), ids, hasSize(amount));
        return ids;
    }

    public List<Long> addDefaultTextAds(Long adGroupId, int amount) {
        return addDefaultTextAds(adGroupId, null, amount);
    }

    public Long addDefaultTextImageAd(Long adGroupId, String adImageHash) {
        return addDefaultTextImageAd(adGroupId, adImageHash, null);
    }

    public Long addDefaultTextImageAd(Long adGroupId, String adImageHash, String login) {
        return addAd(new AdAddItemMap().withTextImageAd(new TextImageAdAddMap().defaultTextImageAd(adImageHash))
                .withAdGroupId(adGroupId), login);
    }

    public Long addDefaultTextAdBuilderAd(Long adGroupId, Long creativeId) {
        return addDefaultTextAdBuilderAd(adGroupId, creativeId, null);
    }

    public Long addDefaultTextAdBuilderAd(Long adGroupId, Long creativeId, String login) {
        return addAd(
                new AdAddItemMap().withTextAdBuilderAd(new TextAdBuilderAdAddMap().defaultTextAdBuilderAd(creativeId))
                        .withAdGroupId(adGroupId), login);
    }

    public Long addDefaultMobileAd(Long adGroupId, String login) {
        return addAd(new AdAddItemMap().withTextAd(new TextAdAddMap().defaultMobileAd()).withAdGroupId(adGroupId),
                login);
    }

    public Long addDefaultMobileAd(Long adGroupId) {
        return addDefaultMobileAd(adGroupId, null);
    }

    public List<Long> addDefaultMobileAppAds(Long adGroupId, String login, int amount) {
        AdAddItemMap[] adAddItemMaps = new AdAddItemMap[amount];
        Arrays.fill(adAddItemMaps, new AdAddItemMap()
                .withAdGroupId(adGroupId)
                .withMobileAppAd(new MobileAppAdAddMap()
                        .defaultMobileAppAd()));
        AddResponse response = adsAdd(new AddRequestMap().withAds(adAddItemMaps), login);
        List<Long> ids = extractIdsFromAddResponse(response);
        assumeThat(String.format("создано %d объявлений с рекламой мобильных приложений", amount),
                ids, hasSize(amount));
        return ids;
    }

    public List<Long> addDefaultMobileAppAds(Long adGroupId, int amount) {
        return addDefaultMobileAppAds(adGroupId, null, amount);
    }

    public Long addDefaultMobileAppAd(Long adGroupId, String login) {
        return addAd(new AdAddItemMap()
                .withAdGroupId(adGroupId)
                .withMobileAppAd(new MobileAppAdAddMap()
                        .defaultMobileAppAd()), login);
    }

    public Long addDefaultMobileAppAd(Long adGroupId) {
        return addDefaultMobileAppAd(adGroupId, null);
    }

    public Long addDefaultMobileAppImageAd(Long adGroupId, String adImageHash) {
        return addDefaultMobileAppImageAd(adGroupId, adImageHash, null);
    }

    public Long addDefaultMobileAppImageAd(Long adGroupId, String adImageHash, String login) {
        return addAd(new AdAddItemMap()
                .withMobileAppImageAd(new MobileAppImageAdAddMap().defaultMobileAppImageAd(adImageHash))
                .withAdGroupId(adGroupId), login);
    }

    public Long addDefaultMobileAppAdBuilderAd(Long adGroupId, Long creativeId) {
        return addDefaultMobileAppAdBuilderAd(adGroupId, creativeId, null);
    }

    public Long addDefaultMobileAppAdBuilderAd(Long adGroupId, Long creativeId, String login) {
        return addAd(new AdAddItemMap()
                .withMobileAppAdBuilderAd(new MobileAppAdBuilderAdAddMap().defaultMobileAppAdBuilderAd(creativeId))
                .withAdGroupId(adGroupId), login);
    }

    public Long addDefaultDynamicTextAd(Long adGroupId, String login) {
        return addAd(new AdAddItemMap().withDynamicTextAd(new DynamicTextAdAddMap().defaultDynamicTextAd())
                .withAdGroupId(adGroupId), login);
    }

    public Long addDefaultDynamicTextAd(Long adGroupId) {
        return addDefaultDynamicTextAd(adGroupId, null);
    }

    public Long addDefaultDynamicTextAdWithVCardId(Long adGroupId, Long vCardId, String login) {
        return addAd(new AdAddItemMap()
                .withDynamicTextAd(new DynamicTextAdAddMap().defaultDynamicTextAd().withVCardId(vCardId))
                .withAdGroupId(adGroupId), login);
    }

    public Long addDefaultDynamicTextAdWithVCardId(Long adGroupId, Long vCardId) {
        return addDefaultDynamicTextAdWithVCardId(adGroupId, vCardId, null);
    }

    public List<Long> addDefaultDynamicTextAds(Long adGroupId, String login, int amount) {
        AdAddItemMap[] adAddItemMaps = new AdAddItemMap[amount];
        Arrays.fill(adAddItemMaps, new AdAddItemMap()
                .withAdGroupId(adGroupId)
                .withDynamicTextAd(new DynamicTextAdAddMap()
                        .defaultDynamicTextAd()));
        AddResponse response = adsAdd(new AddRequestMap().withAds(adAddItemMaps), login);
        List<Long> ids = extractIdsFromAddResponse(response);
        assumeThat(String.format("создано %d текстовых объявлений", amount), ids, hasSize(amount));
        return ids;
    }

    public List<Long> addDefaultDynamicTextAds(Long adGroupId, int amount) {
        return addDefaultDynamicTextAds(adGroupId, null, amount);
    }

    public Long addDefaultAd(Long adGroupId, String login, BannerType type) {
        return addAd(new AdAddItemMap().withDefaultAd(type).withAdGroupId(adGroupId), login);
    }

    public Long addDefaultAd(Long adGroupId, BannerType type) {
        return addDefaultAd(adGroupId, null, type);
    }

    public Long addAdWithAdImageHash(Long adGroupId, AdGroupType adGroupType, BannerType type, String adImageHash,
            String login)
    {
        return addAd(new AdAddItemMap().withAdWithAdImageHash(adGroupType, type, adImageHash).withAdGroupId(adGroupId),
                login);
    }

    public Long addAdWithAdImageHash(Long adGroupId, AdGroupType adGroupType, BannerType type, String adImageHash) {
        return addAdWithAdImageHash(adGroupId, adGroupType, type, adImageHash, null);
    }

    public Long addAdWithSitelinkSetId(Long adGroupId, BannerType type, Long sitelinkSetId, String login) {
        return addAd(new AdAddItemMap().withAdWithSitelinkSetId(type, sitelinkSetId).withAdGroupId(adGroupId), login);
    }

    public Long addAdWithSitelinkSetId(Long adGroupId, BannerType type, Long sitelinkSetId) {
        return addAdWithSitelinkSetId(adGroupId, type, sitelinkSetId, null);
    }

    public List<Long> addDefaultAds(Long adGroupId, String login, int amount, BannerType type) {
        AdAddItemMap[] adAddItemMaps = new AdAddItemMap[amount];
        Arrays.fill(adAddItemMaps, new AdAddItemMap()
                .withAdGroupId(adGroupId)
                .withDefaultAd(type));
        AddResponse response = adsAdd(new AddRequestMap().withAds(adAddItemMaps), login);
        List<Long> ids = extractIdsFromAddResponse(response);
        assumeThat(String.format("создано %d текстовых объявлений", amount), ids, hasSize(amount));
        return ids;
    }

    public List<Long> addDefaultAds(Long adGroupId, int amount, BannerType type) {
        return addDefaultAds(adGroupId, null, amount, type);
    }

    public Long addDefaultCpmBannerAdBuilderAd(Long adGroupId, Long creativeId) {
        return addDefaultCpmBannerAdBuilderAd(adGroupId, creativeId, null);
    }

    public Long addDefaultCpmBannerAdBuilderAd(Long adGroupId, Long creativeId, String login) {
        return addAd(new AdAddItemMap()
                .withCpmBannerAdBuilderAd(new CpmBannerAdBuilderAdAddMap().defaultCpmBannerAdBuilderAd(creativeId))
                .withAdGroupId(adGroupId), login);
    }

    public Long addCpmBannerWithPixels(Long adGroupId, Long creativeId, String login, List<String> pixelUrls) {
        return addAd(new AdAddItemMap()
                .withCpmBannerAdBuilderAd(new CpmBannerAdBuilderAdAddMap()
                        .defaultCpmBannerAdBuilderAd(creativeId)
                        .withTrackingPixels(pixelUrls))
                .withAdGroupId(adGroupId), login);
    }

    //endregion

    //region Update
    @Step("[Ads]: Update")
    public UpdateResponse adsUpdate(UpdateRequestMap parameters, String login) {
        return defaultClientV5()
                .invokeMethod(ServiceNames.ADS, login, Action.UPDATE, (UpdateRequest) parameters.getBean());
    }

    public UpdateResponse adsUpdate(UpdateRequestMap parameters) {
        return adsUpdate(parameters, null);
    }

    public UpdateResponse shouldGetResultOnUpdate(
            UpdateRequestMap parameters, String login, ExpectedResult... expectedResults)
    {
        return (UpdateResponse) shouldGetResultOn(ServiceNames.ADS, login, Action.UPDATE, parameters, expectedResults);
    }

    public UpdateResponse shouldGetResultOnUpdate(UpdateRequestMap parameters, ExpectedResult... expectedResults) {
        return shouldGetResultOnUpdate(parameters, null, expectedResults);
    }

    public UpdateResponse shouldGetResultOnUpdate(UpdateRequestMap parameters,
            JavaOrPerlExpectedResult... expectedResults)
    {
        return (UpdateResponse) shouldGetResultOn(ServiceNames.ADS, null, Action.UPDATE, parameters, expectedResults);
    }

    public void expectErrorOnAdsUpdate(UpdateRequestMap parameters, String login, Api5Error api5Error) {
        shouldGetErrorOn(ServiceNames.ADS, login, Action.UPDATE, parameters, api5Error);
    }

    public void expectErrorOnAdsUpdate(UpdateRequestMap parameters, String login, JavaOrPerlApi5Error api5Error) {
        shouldGetErrorOn(ServiceNames.ADS, login, Action.UPDATE, parameters, api5Error);
    }

    public void expectErrorOnAdsUpdate(UpdateRequestMap parameters, Api5Error api5Error) {
        expectErrorOnAdsUpdate(parameters, null, api5Error);
    }

    public void expectErrorOnAdsUpdate(UpdateRequestMap parameters, JavaOrPerlApi5Error api5Error) {
        expectErrorOnAdsUpdate(parameters, null, api5Error);
    }

    public void expectErrorOnAdsUpdate(Object parameters, JavaOrPerlApi5Error api5Error) {
        shouldGetJSONErrorOn(ServiceNames.ADS, null, Action.UPDATE, parameters, api5Error);
    }

    public void expectErrorOnAdsUpdate(Object parameters, String login, Api5Error api5Error) {
        shouldGetJSONErrorOn(ServiceNames.ADS, login, Action.UPDATE, parameters, api5Error);
    }

    public void expectErrorOnAdsUpdate(Object parameters, Api5Error api5Error) {
        expectErrorOnAdsUpdate(parameters, null, api5Error);
    }

    //endregion

    public String getAdImageHash(Long adId, String login) {
        GetResponse response = adsGet(
                new GetRequestMap().withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                        .withFieldNames(AdFieldEnum.ID)
                        .withTextAdFieldNames(TextAdFieldEnum.AD_IMAGE_HASH),
                login);
        return response.getAds().get(0).getTextAd().getAdImageHash().getValue();
    }

    private List<Long> extractIdsFromAddResponse(AddResponse addResponse) {
        return filter(notNullValue(), extract(addResponse.getAddResults(), on(ActionResult.class).getId()));
    }

    public static String generateTextOfLength(int length, int wordLength, int numberOfNarrowCharacters) {
        StringBuilder stringBuilder = new StringBuilder(randomAlphabetic(length));
        for (int i = wordLength; i < length; i += wordLength) {
            stringBuilder.setCharAt(i, ' ');
        }
        stringBuilder.setCharAt(0, ' ');
        stringBuilder.insert(0, random(numberOfNarrowCharacters, NARROW_CHARACTERS));
        return stringBuilder.toString();
    }

    public Long addDefaultCpcVideoAdBuilderAd(Long adGroupId, Long creativeId) {
        return addDefaultCpcVideoAdBuilderAd(adGroupId, creativeId, null);
    }

    public Long addDefaultCpcVideoAdBuilderAd(Long adGroupId, Long creativeId, String login) {
        return addAd(new AdAddItemMap().withCpcVideoAdBuilderAd(new CpcVideoAdBuilderAdAddMap()
                .defaultCpcVideoAdBuilderAd(creativeId))
                .withAdGroupId(adGroupId), login);
    }

    public Long addDefaultCpcVideoAdWithoutHrefBuilderAd(Long adGroupId, Long creativeId, String login) {
        return addAd(new AdAddItemMap().withCpcVideoAdBuilderAd(new CpcVideoAdBuilderAdAddMap()
                .defaultCpcVideoAdBuilderAd(creativeId)
                .withHref(null))
                .withAdGroupId(adGroupId), login);
    }

    public Long addDefaultMobileAppCpcVideoAdBuilderAd(Long adGroupId, Long creativeId) {
        return addDefaultMobileAppCpcVideoAdBuilderAd(adGroupId, creativeId, null);
    }

    public Long addDefaultMobileAppCpcVideoAdBuilderAd(Long adGroupId, Long creativeId, String login) {
        return addAd(new AdAddItemMap().withMobileAppCpcVideoAdBuilderAd(new MobileAppCpcVideoAdBuilderAdAddMap()
                .defaultMobileAppCpcVideoAdBuilderAd(creativeId))
                .withAdGroupId(adGroupId), login);
    }

    public Long addDefaultMobileAppCpcVideoAdWithoutTrackingUrlBuilderAd(Long adGroupId, Long creativeId,
                                                                         String login) {
        return addAd(new AdAddItemMap().withMobileAppCpcVideoAdBuilderAd(new MobileAppCpcVideoAdBuilderAdAddMap()
                .defaultMobileAppCpcVideoAdBuilderAd(creativeId)
                .withTrackingUrl(null))
                .withAdGroupId(adGroupId), login);
    }
}
