package ru.yandex.autotests.directapi.steps.banners;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

import com.google.common.collect.Lists;
import com.yandex.direct.api.v5.audiencetargets.AddResponse;
import com.yandex.direct.api.v5.audiencetargets.AudienceTargetFieldEnum;
import com.yandex.direct.api.v5.audiencetargets.AudienceTargetGetItem;
import com.yandex.direct.api.v5.audiencetargets.DeleteResponse;
import com.yandex.direct.api.v5.audiencetargets.GetResponse;
import com.yandex.direct.api.v5.audiencetargets.ResumeRequest;
import com.yandex.direct.api.v5.audiencetargets.ResumeResponse;
import com.yandex.direct.api.v5.audiencetargets.SetBidsRequest;
import com.yandex.direct.api.v5.audiencetargets.SetBidsResponse;
import com.yandex.direct.api.v5.audiencetargets.SuspendRequest;
import com.yandex.direct.api.v5.audiencetargets.SuspendResponse;
import com.yandex.direct.api.v5.general.ActionResult;
import com.yandex.direct.api.v5.general.StateEnum;

import ru.yandex.autotests.directapi.apiclient.RequestHeader;
import ru.yandex.autotests.directapi.apiclient.config.ConnectionConfig;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.version5.ServiceNames;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetAddItemMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.DeleteRequestMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.ResumeRequestMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.SetBidsRequestMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.SuspendRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.SetBidsExpectedResult;
import ru.yandex.autotests.directapi.steps.BaseApiSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by buhter on 18.02.16.
 */
public class AudienceTargetsSteps extends BaseApiSteps {
    private static final int MAX_ONETIME_GET_AND_DELETE_SIZE = 10_000;

    private static AudienceTargetsSteps _instance;

    private AudienceTargetsSteps(ConnectionConfig connectionConfig, RequestHeader requestHeader) {
        super(connectionConfig, requestHeader);
    }

    public static AudienceTargetsSteps getInstance(ConnectionConfig connectionConfig, RequestHeader requestHeader) {
        if (_instance == null) {
            _instance = new AudienceTargetsSteps(connectionConfig, requestHeader);
        } else {
            _instance.setConnectionConfig(connectionConfig);
            _instance.setRequestHeader(requestHeader);
        }
        return _instance;
    }

    //region Get
    @Step("[AudienceTargets]: Get")
    public GetResponse audienceTargetsGet(String login, GetRequestMap parameters) {
        GetResponse response = defaultClientV5().invokeMethod(ServiceNames.AUDIENCE_TARGETS, login, Action.GET, parameters.getBean());
        return response;
    }

    public GetResponse audienceTargetsGet(GetRequestMap parameters) {
        return audienceTargetsGet(null, parameters);
    }

    public List<AudienceTargetGetItem> get(String login, GetRequestMap parameters) {
        GetResponse response = audienceTargetsGet(login, parameters);
        return response.getAudienceTargets();
    }

    public List<AudienceTargetGetItem> get(GetRequestMap parameters) {
        return get(null, parameters);
    }

    public List<AudienceTargetGetItem> get(AudienceTargetSelectionCriteriaMap selectionCriteria,
            AudienceTargetFieldEnum... fieldNames)
    {
        return get(null, new GetRequestMap().withSelectionCriteria(selectionCriteria).withFieldNames(fieldNames));
    }

    public List<AudienceTargetGetItem> getByStates(String login, StateEnum... states) {
        return get(login, new GetRequestMap()
                .withFieldNames(AudienceTargetFieldEnum.values())
                .withSelectionCriteria(new AudienceTargetSelectionCriteriaMap()
                        .withStates(states))
        );
    }

    public List<AudienceTargetGetItem> getByStates(StateEnum... states) {
        return getByStates(null, states);
    }

    public List<AudienceTargetGetItem> getByStates(String login, List<StateEnum> states) {
        return getByStates(login, states.toArray(new StateEnum[0]));
    }

    public List<AudienceTargetGetItem> getByStates(List<StateEnum> states) {
        return getByStates(null, states);
    }

    public void expectErrorOnGet(String login, GetRequestMap parameters, Api5Error api5Error) {
        shouldGetErrorOn(ServiceNames.AUDIENCE_TARGETS, login, Action.GET, parameters, api5Error);
    }

    public void expectErrorOnGet(GetRequestMap parameters, Api5Error api5Error) {
        expectErrorOnGet(null, parameters, api5Error);
    }

    public void expectErrorOnGet(String login, Object parameters, Api5Error api5Error) {
        shouldGetJSONErrorOn(ServiceNames.AUDIENCE_TARGETS, login, Action.GET, parameters, api5Error);
    }

    public void expectErrorOnGet(Object parameters, Api5Error api5Error) {
        expectErrorOnGet(null, parameters, api5Error);
    }
    //endregion

    //region Add
    @Step("[AudienceTargets]: Add")
    public List<Long> add(String login, AddRequestMap parameters) {
        AddResponse response = defaultClientV5().invokeMethod(
                ServiceNames.AUDIENCE_TARGETS, login, Action.ADD, parameters.getBean());
        List<ActionResult> results = response.getAddResults();
        lookForResponseExceptions(results);
        return getIDsFromActionResults(results);
    }

    public List<Long> add(AddRequestMap parameters) {
        return add(null, parameters);
    }

    public List<Long> add(AudienceTargetAddItemMap... audienceTargetAddItemMap) {
        return add(new AddRequestMap()
                .withAudienceTargets(audienceTargetAddItemMap));
    }

    @Deprecated
    public Long add(Long pid, Long retargetingListsId) {
        return addWithRetargetingList(pid, retargetingListsId);
    }

    public Long addWithRetargetingList(Long pid, Long retargetingListsId) {
        return add(new AddRequestMap()
                .withAudienceTargets(new AudienceTargetAddItemMap()
                        .withAdGroupId(pid)
                        .withRetargetingListId(retargetingListsId))).get(0);
    }

    public Long addWithRetargetingList(String login, Long pid, Long retargetingListsId) {
        return add(
                login,
                new AddRequestMap()
                        .withAudienceTargets(new AudienceTargetAddItemMap()
                                .withAdGroupId(pid)
                                .withRetargetingListId(retargetingListsId))).get(0);
    }

    public Long addWithInterest(Long pid, Long interestId) {
        return add(new AddRequestMap()
                .withAudienceTargets(new AudienceTargetAddItemMap()
                        .withAdGroupId(pid)
                        .withInterestId(interestId))).get(0);
    }

    public void expectErrorOnAdd(String login, AddRequestMap parameters, Api5Error api5Error) {
        shouldGetErrorOn(ServiceNames.AUDIENCE_TARGETS, login, Action.ADD, parameters, api5Error);
    }

    public void expectErrorOnAdd(AddRequestMap parameters, Api5Error api5Error) {
        expectErrorOnAdd(null, parameters, api5Error);
    }

    public void expectErrorOnAdd(String login, Object parameters, Api5Error api5Error) {
        shouldGetJSONErrorOn(ServiceNames.AUDIENCE_TARGETS, login, Action.ADD, parameters, api5Error);
    }

    public void expectErrorOnAdd(Object parameters, Api5Error api5Error) {
        expectErrorOnAdd(null, parameters, api5Error);
    }

    public AddResponse shouldGetResultOnAdd(String login, AddRequestMap parameters, ExpectedResult... expectedResults) {
        AddResponse response = (AddResponse) shouldGetResultOn(
                ServiceNames.AUDIENCE_TARGETS, login, Action.ADD, parameters, expectedResults);
        return response;
    }

    public AddResponse shouldGetResultOnAdd(AddRequestMap parameters, ExpectedResult... expectedResults) {
        return shouldGetResultOnAdd(null, parameters, expectedResults);
    }
    //endregion

    //region Delete
    @Step("[AudienceTargets]: Delete")
    public DeleteResponse delete(String login, DeleteRequestMap parameters) {
        DeleteResponse response = defaultClientV5().invokeMethod(
                ServiceNames.AUDIENCE_TARGETS, login, Action.DELETE, parameters.getBean());
        return response;
    }

    public DeleteResponse delete(DeleteRequestMap parameters) {
        return delete(null, parameters);
    }

    public DeleteResponse delete(Long... ids) {
        return delete(null, new DeleteRequestMap()
                .withSelectionCriteria(new IdsCriteriaMap().withIds(ids)));
    }

    public DeleteResponse delete(String login, Long... ids) {
        return delete(login, new DeleteRequestMap()
                .withSelectionCriteria(new IdsCriteriaMap().withIds(ids)));
    }

    public DeleteResponse delete(String login, List<Long> ids) {
        return delete(login, new DeleteRequestMap()
                .withSelectionCriteria(
                        new IdsCriteriaMap()
                                .withIds(ids.toArray(new Long[ids.size()]))
                )
        );
    }

    public void expectErrorOnDelete(String login, DeleteRequestMap parameters, Api5Error api5Error) {
        shouldGetErrorOn(ServiceNames.AUDIENCE_TARGETS, login, Action.DELETE, parameters, api5Error);
    }

    public void expectErrorOnDelete(DeleteRequestMap parameters, Api5Error api5Error) {
        expectErrorOnDelete(null, parameters, api5Error);
    }

    public void expectErrorOnDelete(String login, Object parameters, Api5Error api5Error) {
        shouldGetJSONErrorOn(ServiceNames.AUDIENCE_TARGETS, login, Action.DELETE, parameters, api5Error);
    }

    public void expectErrorOnDelete(Object parameters, Api5Error api5Error) {
        expectErrorOnDelete(null, parameters, api5Error);
    }

    public DeleteResponse shouldGetResultOnDelete(
            String login, DeleteRequestMap parameters, ExpectedResult... expectedResults)
    {
        DeleteResponse response = (DeleteResponse) shouldGetResultOn(
                ServiceNames.AUDIENCE_TARGETS, login, Action.DELETE, parameters, expectedResults);
        return response;
    }

    public DeleteResponse shouldGetResultOnDelete(DeleteRequestMap parameters, ExpectedResult... expectedResults) {
        return shouldGetResultOnDelete(null, parameters, expectedResults);
    }

    public DeleteResponse shouldGetResultOnDelete(IdsCriteriaMap selectionCriteria, ExpectedResult... expectedResults) {
        return shouldGetResultOnDelete(null, new DeleteRequestMap().withSelectionCriteria(selectionCriteria),
                expectedResults);
    }
    //endregion

    //region Resume
    @Step("[AudienceTargets]: Resume")
    public ResumeResponse resume(ResumeRequestMap parameters, String login) {
        return defaultClientV5().invokeMethod(ServiceNames.AUDIENCE_TARGETS, login, Action.RESUME, (ResumeRequest) parameters.getBean());
    }

    public ResumeResponse resume(ResumeRequestMap parameters) {
        return resume(parameters, null);
    }

    public ResumeResponse resume(Long id, String login) {
        return resume(
                new ResumeRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds(id)),
                login);
    }

    public ResumeResponse resume(Long... ids) {
        return resume(
                new ResumeRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds(ids)),
                null);
    }

    public void expectErrorOnAudienceTargetsResume(ResumeRequestMap parameters, String login, Api5Error api5Error) {
        shouldGetErrorOn(ServiceNames.AUDIENCE_TARGETS, login, Action.RESUME, parameters, api5Error);
    }

    public void expectErrorOnAudienceTargetsResume(ResumeRequestMap parameters, Api5Error api5Error) {
        expectErrorOnAudienceTargetsResume(parameters, null, api5Error);
    }

    public void expectErrorOnAudienceTargetsResume(Object parameters, String login, Api5Error api5Error) {
        shouldGetJSONErrorOn(ServiceNames.AUDIENCE_TARGETS, login, Action.RESUME, parameters, api5Error);
    }

    public void expectErrorOnAudienceTargetsResume(Object parameters, Api5Error api5Error) {
        expectErrorOnAudienceTargetsResume(parameters, null, api5Error);
    }

    public ResumeResponse shouldGetResultOnResume(String login, ResumeRequestMap parameters,
            ExpectedResult... expectedResults)
    {
        return (ResumeResponse) shouldGetResultOn(ServiceNames.AUDIENCE_TARGETS, login, Action.RESUME, parameters, expectedResults);

    }

    public ResumeResponse shouldGetResultOnResume(ResumeRequestMap parameters, ExpectedResult... expectedResults) {
        return shouldGetResultOnResume(null, parameters, expectedResults);
    }

    //endregion

    //region Suspend
    @Step("[AudienceTargets]: Suspend")
    public SuspendResponse suspend(SuspendRequestMap parameters, String login) {
        return defaultClientV5().invokeMethod(ServiceNames.AUDIENCE_TARGETS, login, Action.SUSPEND, (SuspendRequest) parameters.getBean());
    }

    public SuspendResponse suspend(SuspendRequestMap parameters) {
        return suspend(parameters, null);
    }

    public SuspendResponse suspend(Long id, String login) {
        return suspend(
                new SuspendRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds(id)),
                login);
    }

    public SuspendResponse suspend(Long... ids) {
        return suspend(
                new SuspendRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds(ids)),
                null);
    }

    public void expectErrorOnAudienceTargetsSuspend(SuspendRequestMap parameters, String login, Api5Error api5Error) {
        shouldGetErrorOn(ServiceNames.AUDIENCE_TARGETS, login, Action.SUSPEND, parameters, api5Error);
    }

    public void expectErrorOnAudienceTargetsSuspend(SuspendRequestMap parameters, Api5Error api5Error) {
        expectErrorOnAudienceTargetsSuspend(parameters, null, api5Error);
    }

    public void expectErrorOnAudienceTargetsSuspend(Object parameters, String login, Api5Error api5Error) {
        shouldGetJSONErrorOn(ServiceNames.AUDIENCE_TARGETS, login, Action.SUSPEND, parameters, api5Error);
    }

    public void expectErrorOnAudienceTargetsSuspend(Object parameters, Api5Error api5Error) {
        expectErrorOnAudienceTargetsSuspend(parameters, null, api5Error);
    }

    public SuspendResponse shouldGetResultOnSuspend(IdsCriteriaMap selectionCriteria,
            ExpectedResult... expectedResults)
    {
        return shouldGetResultOnSuspend(new SuspendRequestMap().withSelectionCriteria(selectionCriteria), null,
                expectedResults);
    }

    public SuspendResponse shouldGetResultOnSuspend(SuspendRequestMap parameters, ExpectedResult... expectedResults) {
        return shouldGetResultOnSuspend(parameters, null, expectedResults);
    }

    public SuspendResponse shouldGetResultOnSuspend(SuspendRequestMap parameters, String login,
            ExpectedResult... expectedResults)
    {
        return (SuspendResponse) shouldGetResultOn(ServiceNames.AUDIENCE_TARGETS, login, Action.SUSPEND, parameters, expectedResults);

    }
    //endregion

    //region SetBids
    @Step("[AudienceTargets]: SetBids")
    public SetBidsResponse setBids(SetBidsRequestMap parameters, String login) {
        return defaultClientV5().invokeMethod(
                ServiceNames.AUDIENCE_TARGETS, login, Action.SET_BIDS, (SetBidsRequest) parameters.getBean());
    }

    public SetBidsResponse setBids(SetBidsRequestMap parameters) {
        return setBids(parameters, null);
    }

    public void expectErrorOnSetBids(SetBidsRequestMap parameters, String login, Api5Error error) {
        shouldGetErrorOn(ServiceNames.AUDIENCE_TARGETS, login, Action.SET_BIDS, parameters, error);
    }

    public void expectErrorOnSetBids(SetBidsRequestMap parameters, Api5Error error) {
        expectErrorOnSetBids(parameters, null, error);
    }

    public void expectErrorOnSetBids(Object parameters, String login, Api5Error error) {
        shouldGetJSONErrorOn(ServiceNames.AUDIENCE_TARGETS, login, Action.SET_BIDS, parameters, error);
    }

    public void expectErrorOnSetBids(Object parameters, Api5Error error) {
        expectErrorOnSetBids(parameters, null, error);
    }

    public void shouldGetResultOnSetBids(SetBidsRequestMap parameters, SetBidsExpectedResult... expectedResults) {
        shouldGetResultOnSetBids(null, parameters, expectedResults);
    }

    public void shouldGetResultOnSetBids(String login,
            SetBidsRequestMap parameters, SetBidsExpectedResult... expectedResults)
    {
        shouldGetSetBidsResultOn(login, ServiceNames.AUDIENCE_TARGETS, Action.SET_BIDS, parameters, expectedResults);
    }
    //endregion

    private void lookForResponseExceptions(List<ActionResult> results) {
        Optional<ActionResult> notSuccessfullResult =
                results.stream()
                        .filter(result -> (result.getErrors().size() != 0) || (result.getWarnings().size() != 0))
                        .findFirst();
        assertThat("отсутствуют ошибки и ворнинги при вызове метода", notSuccessfullResult.isPresent(), equalTo(false));
    }

    private List<Long> getIDsFromActionResults(List<ActionResult> results) {
        return results.stream().map(ActionResult::getId).collect(Collectors.toList());
    }

    public void deleteByRetargetingListIds(String login, List<Long> allRetargetingListIds) {
        // Разбиваем с учетом макс. кол-ва которые может выбрать и удалить
        for (List<Long> retargetingListIds : Lists.partition(allRetargetingListIds, MAX_ONETIME_GET_AND_DELETE_SIZE)) {
            Long[] toDeletedIds = get(
                    login,
                    new GetRequestMap()
                            .withSelectionCriteria(
                                    new AudienceTargetSelectionCriteriaMap()
                                            .withRetargetingListsIds(
                                                    retargetingListIds
                                                            .toArray(new Long[allRetargetingListIds.size()])))
                            .withFieldNames(AudienceTargetFieldEnum.ID))
                    .stream()
                    .map(AudienceTargetGetItem::getId)
                    .toArray(Long[]::new);
            if (toDeletedIds.length == 0) {
                continue;
            }
            delete(login, toDeletedIds);
        }
    }
}
