package ru.yandex.autotests.directapi.steps.banners;

import ru.yandex.autotests.directapi.apiclient.RequestHeader;
import ru.yandex.autotests.directapi.apiclient.config.ConnectionConfig;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.apiclient.version4.JsonClient;
import ru.yandex.autotests.directapi.steps.BaseApiSteps;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;
import ru.yandex.qatools.allure.annotations.Step;

/**
 * Created with IntelliJ IDEA.
 * User: mariabye
 * Date: 09.10.12
 * Time: 14:09
 * To change this template use File | Settings | File Templates.
 */
public class BannerPhrasesSteps extends BaseApiSteps {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    private static BannerPhrasesSteps _instance;

    private BannerPhrasesSteps(ConnectionConfig connectionConfig, RequestHeader requestHeader) {
        super(connectionConfig, requestHeader);
    }

    public static BannerPhrasesSteps getInstance(ConnectionConfig connectionConfig, RequestHeader requestHeader) {
        if (_instance == null) {
            _instance = new BannerPhrasesSteps(connectionConfig, requestHeader);
        } else {
            _instance.setConnectionConfig(connectionConfig);
            _instance.setRequestHeader(requestHeader);
        }
        return _instance;

    }

    private JsonClient service() {
        return new JsonClient(connectionConfig, requestHeader);
    }

    @Step("[GetBannerPhrases]: bannerID = {0}")
    public <T> T[] getBannerPhrases(Long bannerID) {
        //log.info("Запрос фраз для bannerID = " + bannerID);
        Object[] phrases = (Object[])
                service().invokeMethod(Method.GET_BANNER_PHRASES, new Long[]{bannerID});
        //log.info("Получено фраз: " + phrases.length);
        return (T[]) phrases;
    }

    @Step("[GetBannerPhrases]")
    public <T> T[] getBannerPhrases(Long[] bannerIDs) {
        log.info("Запрос фраз для bannerIDs = " + JsonUtils.toString(bannerIDs));
        Object[] phrases = (Object[])
                service().invokeMethod(Method.GET_BANNER_PHRASES, bannerIDs);
        //log.info("Получено фраз: " + phrases.length);
        return (T[]) phrases;
    }

}
