package ru.yandex.autotests.directapi.steps.banners;

import com.yandex.direct.api.v5.keywordsresearch.DeduplicateResponse;
import com.yandex.direct.api.v5.keywordsresearch.HasSearchVolumeResponse;
import org.apache.commons.beanutils.BeanMap;

import ru.yandex.autotests.directapi.apiclient.RequestHeader;
import ru.yandex.autotests.directapi.apiclient.config.ConnectionConfig;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.version5.ServiceNames;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.keywordsresearch.DeduplicateRequestMap;
import ru.yandex.autotests.directapi.model.api5.keywordsresearch.HasSearchVolumeRequestMap;
import ru.yandex.autotests.directapi.steps.BaseApiSteps;
import ru.yandex.qatools.allure.annotations.Step;

public class KeywordsResearchSteps extends BaseApiSteps {
    private static KeywordsResearchSteps instance;

    private KeywordsResearchSteps(ConnectionConfig config, RequestHeader header) {
        super(config, header);
    }

    public static KeywordsResearchSteps getInstance(ConnectionConfig config, RequestHeader header) {
        if (instance == null) {
            instance = new KeywordsResearchSteps(config, header);
        } else {
            instance.setConnectionConfig(config);
            instance.setRequestHeader(header);
        }
        return instance;
    }

    @Step("[KeywordsResearch]: HasSearchVolume")
    public HasSearchVolumeResponse keywordsResearchHasSearchVolumeRawResponse(
            String login, HasSearchVolumeRequestMap request)
    {
        return defaultClientV5().invokeMethod(
                ServiceNames.KEYWORDS_RESEARCH, login, Action.HAS_SEARCH_VOLUME, request.getBean());
    }

    @Step("[KeywordsResearch]: Deduplicate")
    public DeduplicateResponse keywordsResearchDeduplicateRawResponse(
            String login, DeduplicateRequestMap request)
    {
        return defaultClientV5().invokeMethod(
                ServiceNames.KEYWORDS_RESEARCH, login, Action.DEDUPLICATE, request.getBean());
    }

    public void shouldGetErrorOnKeywordsResearchHasSearchVolume(HasSearchVolumeRequestMap request, String login,
            Api5Error api5Error)
    {
        shouldGetErrorOn(login, Action.HAS_SEARCH_VOLUME, request, api5Error);
    }

    public <T extends BeanMap> void shouldGetErrorOn(String login,
            Action action, T args, Api5Error expectedError)
    {
        shouldGetErrorOn(ServiceNames.KEYWORDS_RESEARCH, login, action, args, expectedError);
    }
}
