package ru.yandex.autotests.directapi.steps.banners;

import java.util.List;
import java.util.Objects;

import com.yandex.direct.api.v5.general.ActionResult;
import com.yandex.direct.api.v5.negativekeywordsharedsets.AddResponse;
import com.yandex.direct.api.v5.negativekeywordsharedsets.DeleteResponse;
import com.yandex.direct.api.v5.negativekeywordsharedsets.GetResponse;
import com.yandex.direct.api.v5.negativekeywordsharedsets.UpdateResponse;

import ru.yandex.autotests.directapi.apiclient.RequestHeader;
import ru.yandex.autotests.directapi.apiclient.config.ConnectionConfig;
import ru.yandex.autotests.directapi.apiclient.version5.ServiceNames;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.negativekeywordsharedsets.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.negativekeywordsharedsets.DeleteRequestMap;
import ru.yandex.autotests.directapi.model.api5.negativekeywordsharedsets.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.negativekeywordsharedsets.NegativeKeywordSharedSetAddItemMap;
import ru.yandex.autotests.directapi.model.api5.negativekeywordsharedsets.UpdateRequestMap;
import ru.yandex.autotests.directapi.steps.BaseApiSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static java.util.Arrays.asList;
import static java.util.stream.Collectors.toList;
import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

public class NegativeKeywordsSharedSetsSteps extends BaseApiSteps {

    private static NegativeKeywordsSharedSetsSteps _instance;

    private NegativeKeywordsSharedSetsSteps(ConnectionConfig connectionConfig, RequestHeader requestHeader) {
        super(connectionConfig, requestHeader);
    }

    public static NegativeKeywordsSharedSetsSteps getInstance(ConnectionConfig connectionConfig,
            RequestHeader requestHeader)
    {
        if (_instance == null) {
            _instance = new NegativeKeywordsSharedSetsSteps(connectionConfig, requestHeader);
        } else {
            _instance.setConnectionConfig(connectionConfig);
            _instance.setRequestHeader(requestHeader);
        }
        return _instance;
    }

    @Step("[NegativeKeywordsSharedSets]: Get")
    public GetResponse negativeKeywordsSharedSetsGet(GetRequestMap parameters, String login) {
        return defaultClientV5()
                .invokeMethod(ServiceNames.NEGATIVE_KEYWORD_SHARED_SETS, login, Action.GET, parameters.getBean());
    }

    @Step("[NegativeKeywordsSharedSets]: Add")
    public AddResponse negativeKeywordsSharedSetsAdd(AddRequestMap parameters, String login) {
        return defaultClientV5()
                .invokeMethod(ServiceNames.NEGATIVE_KEYWORD_SHARED_SETS, login, Action.ADD, parameters.getBean());
    }

    public AddResponse shouldGetResultOnAdd(AddRequestMap parameters, String login, ExpectedResult... expectedResults) {
        return (AddResponse) shouldGetResultOn(ServiceNames.NEGATIVE_KEYWORD_SHARED_SETS, login, Action.ADD, parameters,
                expectedResults);
    }

    public Long addNegativeKeywordsSharedSet(AddRequestMap addRequestMap) {
        AddResponse addResponse = negativeKeywordsSharedSetsAdd(addRequestMap, null);
        List<Long> ids = addResponse.getAddResults().stream()
                .filter(Objects::nonNull)
                .map(ActionResult::getId)
                .collect(toList());
        assumeThat("создан один набор", ids, hasSize(1));
        return ids.get(0);
    }

    public Long addDefaultNegativeKeywordsSharedSet() {
        return addNegativeKeywordsSharedSet(getDefaultAddRequest());
    }

    public AddRequestMap getDefaultAddRequest() {
        return new AddRequestMap()
                .withNegativeKeywordSharedSets(new NegativeKeywordSharedSetAddItemMap()
                        .withName("First pack")
                        .withNegativeKeywords(asList("продать авто", "продать автозапчасти")));
    }

    @Step("[NegativeKeywordsSharedSets]: Update")
    public UpdateResponse negativeKeywordsSharedSetsUpdate(UpdateRequestMap parameters, String login) {
        return defaultClientV5()
                .invokeMethod(ServiceNames.NEGATIVE_KEYWORD_SHARED_SETS, login, Action.UPDATE, parameters.getBean());
    }

    public UpdateResponse shouldGetResultOnUpdate(
            UpdateRequestMap parameters, String login, ExpectedResult... expectedResults)
    {
        return (UpdateResponse) shouldGetResultOn(ServiceNames.NEGATIVE_KEYWORD_SHARED_SETS, login, Action.UPDATE,
                parameters, expectedResults);
    }

    @Step("[NegativeKeywordsSharedSets]: Delete")
    public DeleteResponse negativeKeywordsSharedSetsDelete(DeleteRequestMap parameters, String login) {
        return defaultClientV5()
                .invokeMethod(ServiceNames.NEGATIVE_KEYWORD_SHARED_SETS, login, Action.DELETE, parameters.getBean());
    }

    public DeleteResponse shouldGetResultOnDelete(DeleteRequestMap parameters, String login,
            ExpectedResult... expectedResults)
    {
        return (DeleteResponse) shouldGetResultOn(ServiceNames.NEGATIVE_KEYWORD_SHARED_SETS, login, Action.DELETE,
                parameters, expectedResults);
    }
}
