package ru.yandex.autotests.directapi.steps.banners;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;

import com.google.common.collect.Lists;
import com.yandex.direct.api.v5.general.ActionResult;
import com.yandex.direct.api.v5.retargetinglists.AddResponse;
import com.yandex.direct.api.v5.retargetinglists.DeleteResponse;
import com.yandex.direct.api.v5.retargetinglists.GetResponse;
import com.yandex.direct.api.v5.retargetinglists.RetargetingListBase;
import com.yandex.direct.api.v5.retargetinglists.RetargetingListFieldEnum;
import com.yandex.direct.api.v5.retargetinglists.RetargetingListGetItem;
import com.yandex.direct.api.v5.retargetinglists.RetargetingListRuleArgumentItem;
import com.yandex.direct.api.v5.retargetinglists.RetargetingListRuleItem;
import com.yandex.direct.api.v5.retargetinglists.RetargetingListRuleOperatorEnum;
import com.yandex.direct.api.v5.retargetinglists.RetargetingListTypeEnum;
import com.yandex.direct.api.v5.retargetinglists.UpdateRequest;
import com.yandex.direct.api.v5.retargetinglists.UpdateResponse;
import one.util.streamex.StreamEx;

import ru.yandex.autotests.directapi.apiclient.RequestHeader;
import ru.yandex.autotests.directapi.apiclient.config.ConnectionConfig;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.version5.ServiceNames;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.DeleteRequestMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListAddItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListRuleArgumentItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListRuleItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.rules.Api5Bin;
import ru.yandex.autotests.directapi.rules.Api5Binable;
import ru.yandex.autotests.directapi.steps.BaseApiSteps;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static java.util.stream.Collectors.toList;
import static org.apache.commons.lang.math.RandomUtils.nextInt;
import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by buhter on 18.02.16.
 */
public class RetargetingListsSteps extends BaseApiSteps implements Api5Binable<Long> {
    static final int MAX_ONETIME_DELETE_SIZE = 1_000;

    private final LogSteps log = LogSteps.getLogger(this.getClass());

    private static RetargetingListsSteps _instance;

    private RetargetingListsSteps(ConnectionConfig connectionConfig, RequestHeader requestHeader) {
        super(connectionConfig, requestHeader);
    }

    public static RetargetingListsSteps getInstance(ConnectionConfig connectionConfig, RequestHeader requestHeader) {
        if (_instance == null) {
            _instance = new RetargetingListsSteps(connectionConfig, requestHeader);
        } else {
            _instance.setConnectionConfig(connectionConfig);
            _instance.setRequestHeader(requestHeader);
        }
        return _instance;
    }

    public Api5Bin<Long> bin = new Api5Bin<>(this);

    //region Get

    @Step("[RetargetingLists]: Get")
    public GetResponse retargetingListsGet(String login, GetRequestMap parameters) {
        GetResponse response =
                defaultClientV5().invokeMethod(ServiceNames.RETARGETING_LISTS, login, Action.GET, parameters.getBean());
        return response;
    }

    public GetResponse retargetingListsGet(GetRequestMap parameters) {
        return retargetingListsGet(null, parameters);
    }

    public List<RetargetingListGetItem> get(String login, GetRequestMap parameters) {
        GetResponse response = retargetingListsGet(login, parameters);
        return response.getRetargetingLists();
    }

    public List<RetargetingListGetItem> get(GetRequestMap parameters) {
        return get(null, parameters);
    }

    public List<RetargetingListGetItem> get(String login, Long... ids) {
        return get(login, new GetRequestMap()
                .withFieldNames(RetargetingListFieldEnum.values())
                .withSelectionCriteria(new RetargetingListSelectionCriteriaMap()
                        .withIds(ids))
        );
    }

    public List<RetargetingListGetItem> getByLogin(String login) {
        return get(login, new GetRequestMap()
                .withFieldNames(RetargetingListFieldEnum.values())
        );
    }

    public List<RetargetingListGetItem> getRetargetingByLogin(String login) {
        return get(login, new GetRequestMap()
                .withSelectionCriteria(new RetargetingListSelectionCriteriaMap()
                        .withTypes(RetargetingListTypeEnum.RETARGETING))
                .withFieldNames(RetargetingListFieldEnum.values())
        );
    }

    public List<RetargetingListGetItem> get(Long... ids) {
        return get(null, ids);
    }

    public List<RetargetingListGetItem> get(String login, List<Long> ids) {
        return get(login, ids.toArray(new Long[0]));
    }

    /**
     * Найти идентификаторы всех условий подбора заданного пользователя
     *
     * @param login Логин пользователя
     */
    public List<Long> getIdsByLogin(String login) {
        Objects.requireNonNull(login, "login");

        // Всего у пользователя может быть не более 2000 условий подбора аудитории
        // в то время как метод get за раз может вернуть до 10_000
        return get(
                login, new GetRequestMap().withSelectionCriteria(new RetargetingListSelectionCriteriaMap().withTypes(
                        RetargetingListTypeEnum.RETARGETING)).withFieldNames(RetargetingListFieldEnum.ID))
                .stream()
                .map(RetargetingListGetItem::getId)
                .collect(toList());
    }

    public List<RetargetingListGetItem> get(List<Long> ids) {
        return get(null, ids);
    }

    public void expectErrorOnGet(String login, GetRequestMap parameters, Api5Error api5Error) {
        shouldGetErrorOn(ServiceNames.RETARGETING_LISTS, login, Action.GET, parameters, api5Error);
    }

    public void expectErrorOnGet(GetRequestMap parameters, Api5Error api5Error) {
        expectErrorOnGet(null, parameters, api5Error);
    }

    public void expectErrorOnGet(String login, Object parameters, Api5Error api5Error) {
        shouldGetJSONErrorOn(ServiceNames.RETARGETING_LISTS, login, Action.GET, parameters, api5Error);
    }

    public void expectErrorOnGet(Object parameters, Api5Error api5Error) {
        expectErrorOnGet(null, parameters, api5Error);
    }
    //endregion

    //region Add
    @Step("[RetargetingUserLists]: Add")
    public List<Long> add(String login, AddRequestMap parameters) {
        AddResponse response = defaultClientV5().invokeMethod(
                ServiceNames.RETARGETING_LISTS, login, Action.ADD, parameters.getBean());
        throwToBin(login, response);
        List<ActionResult> results = response.getAddResults();
        lookForResponseExceptions(results);
        return getIDsFromActionResults(results);
    }

    public List<Long> add(AddRequestMap parameters) {
        return add(null, parameters);
    }


    public Long addDefaultRetargetingLists(Long externalId, String login) {
        // внутри add прибита гвоздями проверка ошибок в ответе
        // часто эта ошибка - что такое условие уже есть
        // чтобы не ломаться на этом (потому что непонятно зачем)
        // попробуем поискать такое же условие
        // NB! может наоборот сильно шуметь, если никаких условий у клиента нет.
        Optional<Long> existingRetargetingListId = StreamEx.of(getRetargetingByLogin(login))
                .mapToEntry(RetargetingListGetItem::getId, RetargetingListBase::getRules)
                .filterValues(l -> l.size() == 1)
                .mapValues(l -> l.get(0))
                .mapValues(RetargetingListRuleItem::getArguments)
                .filterValues(l -> l.size() == 1)
                .mapValues(l -> l.get(0))
                .mapValues(RetargetingListRuleArgumentItem::getExternalId)
                .filterValues(externalId::equals)
                .keys()
                .findFirst();

        return existingRetargetingListId.orElseGet(() -> addDefaultRetargetingListWithoutSearch(externalId, login));
    }

    public Long addDefaultRetargetingListWithoutSearch(Long externalId) {
        return addDefaultRetargetingListWithoutSearch(externalId, null);
    }

    public Long addDefaultRetargetingListWithoutSearch(Long externalId, String login) {
        return add(
                login,
                new AddRequestMap()
                        .withRetargetingLists(
                                new RetargetingListAddItemMap()
                                        .defaultRetargetingListAddItemMap(externalId))
        ).get(0);
    }

    public Long addDefaultRetargetingLists(Long externalId) {
        return addDefaultRetargetingLists(externalId, null);
    }

    public Long addDefaultRetargetingLists(String login) {
        Long goalId = RetargetingSteps.getInstance(connectionConfig, requestHeader)
                .getRetargetingGoalIDsByType(login, RetargetingGoalType.GOAL).get(0);
        return addDefaultRetargetingLists(goalId, login);
    }

    @Step("addRandomRetargetingList for login {0} with a numer of conditions and rules made out of externalIds {1}")
    public Long addRandomRetargetingList(String login, long... externalIds) {
        if (externalIds == null || externalIds.length < 1) {
            return null;
        }
        RetargetingListAddItemMap addItemMap = new RetargetingListAddItemMap().withRandomName();
        int conditionsCount = 1 + nextInt(10);
        RetargetingListRuleItemMap[] ruleItemMaps = new RetargetingListRuleItemMap[conditionsCount];
        for (int i = 0; i < conditionsCount; i++) {
            RetargetingListRuleItemMap ruleItemMap = new RetargetingListRuleItemMap();
            if (i == 0) {
                ruleItemMap.withOperator(RetargetingListRuleOperatorEnum.ANY);
            } else {
                ruleItemMap.withRandomOperator();
            }
            int rulesCount = 1 + nextInt(Math.min(5, externalIds.length));
            RetargetingListRuleArgumentItemMap[] ruleArgumentItemMaps = new RetargetingListRuleArgumentItemMap[rulesCount];

            List<Long> externalIdsShuffled = shuffleArray(externalIds);

            for (int j= 0; j < rulesCount; j++) {
                RetargetingListRuleArgumentItemMap ruleArgumentItemMap = new RetargetingListRuleArgumentItemMap()
                        .withRandomMembershipLifeSpan()
                        .withExternalId(externalIdsShuffled.get(j));
                ruleArgumentItemMaps[j] = ruleArgumentItemMap;
            }
            ruleItemMap.withArgumentItems(ruleArgumentItemMaps);
            ruleItemMaps[i] = ruleItemMap;
        }
        addItemMap.withRules(ruleItemMaps);
        return add(login, new AddRequestMap().withRetargetingLists(addItemMap)).get(0);
    }

    private static List<Long> shuffleArray(long[] array) {
        List<Long> arrayCopy = new ArrayList<>();
        for (long externalId : array) {
            arrayCopy.add(externalId);
        }
        Collections.shuffle(arrayCopy);
        return arrayCopy;
    }

    public void expectErrorOnAdd(String login, AddRequestMap parameters, Api5Error api5Error) {
        shouldGetErrorOn(ServiceNames.RETARGETING_LISTS, login, Action.ADD, parameters, api5Error);
    }

    public void expectErrorOnAdd(AddRequestMap parameters, Api5Error api5Error) {
        expectErrorOnAdd(null, parameters, api5Error);
    }

    public void expectErrorOnAdd(String login, Object parameters, Api5Error api5Error) {
        shouldGetJSONErrorOn(ServiceNames.RETARGETING_LISTS, login, Action.ADD, parameters, api5Error);
    }

    public void expectErrorOnAdd(Object parameters, Api5Error api5Error) {
        expectErrorOnAdd(null, parameters, api5Error);
    }

    public AddResponse shouldGetResultOnAdd(String login, AddRequestMap parameters, ExpectedResult... expectedResults) {
        AddResponse response = (AddResponse) shouldGetResultOn(
                ServiceNames.RETARGETING_LISTS, login, Action.ADD, parameters, expectedResults);
        throwToBin(login, response);
        return response;
    }

    public AddResponse shouldGetResultOnAdd(AddRequestMap parameters, ExpectedResult... expectedResults) {
        return shouldGetResultOnAdd(null, parameters, expectedResults);
    }
    //endregion

    //region Delete
    @Step("[RetargetingUserLists]: Delete")
    public DeleteResponse delete(String login, DeleteRequestMap parameters) {
        DeleteResponse response = defaultClientV5().invokeMethod(
                ServiceNames.RETARGETING_LISTS, login, Action.DELETE, parameters.getBean());
        removeFromBin(response);
        return response;
    }

    public DeleteResponse delete(String login, Long... ids) {
        return delete(login, new DeleteRequestMap()
                .withSelectionCriteria(new IdsCriteriaMap().withIds(ids)));
    }

    public DeleteResponse delete(DeleteRequestMap parameters) {
        return delete(null, parameters);
    }

    public DeleteResponse delete(Long... ids) {
        return delete(null, ids);
    }

    public DeleteResponse delete(String login, List<Long> ids) {
        return delete(login, ids.toArray(new Long[0]));
    }

    public void deleteByIds(String login, List<Long> allIds) {
        for (List<Long> ids : Lists.partition(allIds, MAX_ONETIME_DELETE_SIZE)) {
            try {
                delete(login, ids.toArray(new Long[ids.size()]));
            } catch (RuntimeException e) {
                log.info("Error while removing RetargetingLists", e);
            }
        }
    }

    public DeleteResponse delete(List<Long> ids) {
        return delete(null, ids);
    }

    public void expectErrorOnDelete(String login, DeleteRequestMap parameters, Api5Error api5Error) {
        shouldGetErrorOn(ServiceNames.RETARGETING_LISTS, login, Action.DELETE, parameters, api5Error);
    }

    public void expectErrorOnDelete(DeleteRequestMap parameters, Api5Error api5Error) {
        expectErrorOnDelete(null, parameters, api5Error);
    }

    public void expectErrorOnDelete(String login, Object parameters, Api5Error api5Error) {
        shouldGetJSONErrorOn(ServiceNames.RETARGETING_LISTS, login, Action.DELETE, parameters, api5Error);
    }

    public void expectErrorOnDelete(Object parameters, Api5Error api5Error) {
        expectErrorOnDelete(null, parameters, api5Error);
    }

    public DeleteResponse shouldGetResultOnDelete(
            String login, DeleteRequestMap parameters, ExpectedResult... expectedResults)
    {
        DeleteResponse response = (DeleteResponse) shouldGetResultOn(
                ServiceNames.RETARGETING_LISTS, login, Action.DELETE, parameters, expectedResults);
        removeFromBin(response);
        return response;
    }

    public DeleteResponse shouldGetResultOnDelete(DeleteRequestMap parameters, ExpectedResult... expectedResults) {
        return shouldGetResultOnDelete(null, parameters, expectedResults);
    }

    //endregion

    //region Update
    @Step("[RetargetingUserLists]: Update")
    public UpdateResponse update(UpdateRequestMap parameters, String login) {
        return defaultClientV5().invokeMethod(ServiceNames.RETARGETING_LISTS, login, Action.UPDATE,
                (UpdateRequest) parameters.getBean());
    }

    public UpdateResponse update(UpdateRequestMap parameters) {
        return update(parameters, null);
    }

    public UpdateResponse shouldGetResultOnUpdate(
            UpdateRequestMap parameters, String login, ExpectedResult... expectedResults)
    {
        return (UpdateResponse) shouldGetResultOn(ServiceNames.RETARGETING_LISTS, login, Action.UPDATE, parameters,
                expectedResults);
    }

    public UpdateResponse shouldGetResultOnUpdate(UpdateRequestMap parameters, ExpectedResult... expectedResults) {
        return shouldGetResultOnUpdate(parameters, null, expectedResults);
    }

    public void expectErrorOnUpdate(UpdateRequestMap parameters, String login, Api5Error api5Error) {
        shouldGetErrorOn(ServiceNames.RETARGETING_LISTS, login, Action.UPDATE, parameters, api5Error);
    }

    public void expectErrorOnUpdate(UpdateRequestMap parameters, Api5Error api5Error) {
        expectErrorOnUpdate(parameters, null, api5Error);
    }

    public void expectErrorOnUpdate(Object parameters, String login, Api5Error api5Error) {
        shouldGetJSONErrorOn(ServiceNames.RETARGETING_LISTS, login, Action.UPDATE, parameters, api5Error);
    }

    public void expectErrorOnUpdate(Object parameters, Api5Error api5Error) {
        expectErrorOnUpdate(parameters, null, api5Error);
    }

    //endregion

    private void lookForResponseExceptions(List<ActionResult> results) {
        Optional<ActionResult> notSuccessfullResult =
                results.stream()
                        .filter(result -> (result.getErrors().size() != 0) || (result.getWarnings().size() != 0))
                        .findFirst();
        assertThat("отсутствуют ошибки и ворнинги при вызове метода", notSuccessfullResult.isPresent(), equalTo(false));
    }

    private List<Long> getIDsFromActionResults(List<ActionResult> results) {
        return results.stream().map(ActionResult::getId).collect(toList());
    }

    private void throwToBin(String login, AddResponse addResponse) {
        List<Long> ids = getIDsFromActionResults(addResponse.getAddResults());
        for (Long id : ids) {
            if (id != null) {
                bin.throwToBin(id, login != null ? login :
                        (requestHeader.getFakeLogin() != null ? requestHeader.getFakeLogin()
                                : requestHeader.getLogin()));
            }
        }
    }

    private void removeFromBin(DeleteResponse deleteResponse) {
        List<Long> ids = getIDsFromActionResults(deleteResponse.getDeleteResults());
        for (Long id : ids) {
            bin.removeFromBin(id);
        }
    }

    @Override
    public Callable clearBin(final Map<Long, String> binData) {
        return () -> {
            Map<String, List<Long>> loginToIds = new HashMap<>();
            for (Map.Entry<Long, String> entry : binData.entrySet()) {
                Long id = entry.getKey();
                String login = entry.getValue();
                if (!loginToIds.containsKey(login)) {
                    loginToIds.put(login, new ArrayList<>());
                }
                loginToIds.get(login).add(id);
            }
            for (Map.Entry<String, List<Long>> entry : loginToIds.entrySet()) {
                String login = entry.getKey();
                List<Long> ids = entry.getValue();
                delete(login, ids);
            }
            return null;
        };
    }
}
