package ru.yandex.autotests.directapi.steps.banners;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import org.apache.commons.beanutils.BeanMap;
import org.apache.commons.collections.keyvalue.DefaultKeyValue;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.hamcrest.Matchers;

import ru.yandex.autotests.direct.utils.converter.BeanToBeanMapConverter;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.RequestHeader;
import ru.yandex.autotests.directapi.apiclient.config.ConnectionConfig;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Action;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.common.api45.RetargetingCondition;
import ru.yandex.autotests.directapi.common.api45.RetargetingGoal;
import ru.yandex.autotests.directapi.exceptions.DirectAPIException;
import ru.yandex.autotests.directapi.matchers.axiserror.ApiResponse;
import ru.yandex.autotests.directapi.model.retargeting.GetRetargetingGoalsRequestMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingConditionGoalItemMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingConditionItemMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingConditionMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingConditionRequestMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingConditionSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingRequestMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingRequestOptionsMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingType;
import ru.yandex.autotests.directapi.rules.Bin;
import ru.yandex.autotests.directapi.rules.Binable;
import ru.yandex.autotests.directapi.steps.BaseApiSteps;
import ru.yandex.autotests.irt.testutils.RandomUtils;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;
import ru.yandex.qatools.allure.annotations.Step;

import static ch.lambdaj.Lambda.convert;
import static ch.lambdaj.Lambda.extractProperty;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.greaterThan;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.lessThan;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created with IntelliJ IDEA.
 * User: mariabye
 * Date: 10.04.13
 * Time: 10:03
 * To change this template use File | Settings | File Templates.
 */
public class RetargetingSteps extends BaseApiSteps implements Binable<DefaultKeyValue> {
    private LogSteps log = LogSteps.getLogger(this.getClass());
    protected Logger log4j = LogManager.getLogger(this.getClass());

    private static RetargetingSteps _instance;

    private RetargetingSteps(ConnectionConfig connectionConfig, RequestHeader requestHeader) {
        super(connectionConfig, requestHeader);
    }

    public static RetargetingSteps getInstance(ConnectionConfig connectionConfig, RequestHeader requestHeader) {
        if (_instance == null) {
            _instance = new RetargetingSteps(connectionConfig, requestHeader);
        } else {
            _instance.setConnectionConfig(connectionConfig);
            _instance.setRequestHeader(requestHeader);
        }
        return _instance;
    }

    public Bin<DefaultKeyValue> bin = new Bin<>(this);

    public <RetargetingConditionResponse> void putToQueue(RetargetingConditionResponse conditionResponse) {
        try {
            Object[] actionResult = (Object[]) new BeanMap(conditionResponse).get("actionsResult");
            for (Object result : actionResult) {
                BeanMap bean = new BeanMap(result);
                if (bean.get(RetargetingConditionMap.RETARGETING_CONDITION_ID) != null) {
                    bin.throwToBin(
                            new DefaultKeyValue(
                                    bean.get(RetargetingConditionMap.LOGIN),
                                    bean.get(RetargetingConditionMap.RETARGETING_CONDITION_ID)));
                }
            }
        } catch (Exception e) {
            log4j.error(e.getMessage());
        }
    }

    public Callable clearBin(final Set<DefaultKeyValue> binData) {
        return new Callable() {
            public Object call() throws Exception {
                for (DefaultKeyValue item : binData.toArray(new DefaultKeyValue[0])) {
                    Integer id = (Integer) item.getValue();
                    try {
                        retargetingConditionDelete(id);
                    } catch (Exception e) {
                        log4j.debug("Ошибка удаления условия ретаргетинга", e);
                    }
                }
                return null;
            }
        };
    }

    @Deprecated
    @Step("[RetargetingCondition]")
    public <RetargetingConditionResponse> RetargetingConditionResponse retargetingCondition(
            RetargetingConditionRequestMap retargetingConditionRequestMap)
    {
        return jsonClient().invokeMethod(Method.RETARGETING_CONDITION, retargetingConditionRequestMap.getBean());
    }

    @Deprecated
    @Step("[Retargeting]")
    public <RetargetingResponse> RetargetingResponse retargeting(RetargetingRequestMap retargetingRequestMap) {
        Object response = defaultClient().invokeMethod(Method.RETARGETING, retargetingRequestMap.getBean());
        try {
            assumeThat("", JsonUtils.toString(response),
                    ApiResponse.hasErrors(new AxisError(47, AxisErrorDetails.RETARGETING_CONDITION_NOT_FOUND)));
            return defaultClient().invokeMethod(Method.RETARGETING, retargetingRequestMap.getBean());
        } catch (Throwable e) {
            return (RetargetingResponse) response;
        }
    }

    //region Retargeting
    //region GET
    @Deprecated
    @Step("[Retargeting.Get]")
    public <RetargetingResponse> RetargetingResponse retargetingGet(
            String login,
            RetargetingSelectionCriteriaMap retargetingSelectionCriteriaMap,
            RetargetingRequestOptionsMap retargetingRequestOptionsMap)
    {
        return retargeting(
                new RetargetingRequestMap<>(defaultClient().getPackageName())
                        .withAction(Action.GET)
                        .withLogin(login)
                        .withSelectionCriteria(retargetingSelectionCriteriaMap)
                        .withOptions(retargetingRequestOptionsMap)

        );
    }

    @Deprecated
    public <Retargeting> Retargeting[] getAdsRetargeting(String login, Currency currency, Long... adIDs) {
        Object retargetingResponse = retargetingGet(
                login,
                new RetargetingSelectionCriteriaMap(defaultClient().getPackageName())
                        .withAdIDs(adIDs),
                new RetargetingRequestOptionsMap(defaultClient().getPackageName())
                        .withCurrency(currency));
        return (Retargeting[]) new BeanMap(retargetingResponse).get("retargetings");
    }

    //endregion
    //region DELETE
    @Deprecated
    @Step("[Retargeting.Delete]")
    public <RetargetingResponse> RetargetingResponse retargetingDelete(
            String login,
            RetargetingSelectionCriteriaMap retargetingSelectionCriteriaMap)
    {
        return retargeting(
                new RetargetingRequestMap(defaultClient().getPackageName())
                        .withAction(Action.DELETE)
                        .withLogin(login)
                        .withSelectionCriteria(retargetingSelectionCriteriaMap)
        );
    }

    @Deprecated
    public <RetargetingResponse> RetargetingResponse retargetingDelete(String login, int... retargetingIDs) {
        return retargetingDelete(
                login,
                new RetargetingSelectionCriteriaMap(defaultClient().getPackageName())
                        .withRetargetingIDS(retargetingIDs));
    }

    //endregion

    //region ADD/UPDATE
    @Deprecated
    @Step("[Retargeting.Add]")
    public <RetargetingResponse> RetargetingResponse retargetingAdd(String login, RetargetingMap... retargetingMaps) {
        return retargeting(
                new RetargetingRequestMap(defaultClient().getPackageName())
                        .withAction(Action.ADD)
                        .withLogin(login)
                        .withRetargetings(retargetingMaps)
        );
    }

    @Deprecated
    public int[] addRetargetings(String login, RetargetingMap... retargetingMaps) {
        Object response = retargetingAdd(login, retargetingMaps);
        assumeThat("ответ не содержит ошибок", JsonUtils.toString(response), ApiResponse.hasNoError());
        return getRetargetingIDs((Object[]) new BeanMap(response).get("actionsResult"));
    }

    @Deprecated
    public Integer addRetargetingToBanner(String login, Long bannerID) {
        return addRetargetingToBanner(login, bannerID, Currency.RUB);
    }

    @Deprecated
    public Integer addRetargetingToBanner(String login, Long bannerID, Currency currency) {
        return addRetargetingToBanner(login, bannerID, currency, MoneyCurrency.get(currency).getMinPrice().floatValue());
    }

    @Deprecated
    public Integer addRetargetingToBanner(String login, Long bannerID, Currency currency, float price) {
        int[] retargetingConditions = getRetargetingConditions(login);
        assumeThat("выполнены условия для теста, иначе надо запустить конфиг",
                retargetingConditions.length, greaterThan(0));
        int retargetingConditionID = retargetingConditions[0];
        return addRetargetingToBanner(login, bannerID, retargetingConditionID, currency, price);
    }

    @Deprecated
    public int addRetargetingToBanner(String login, Long bannerID, int retargetingConditionID) {
        return addRetargetingToBanner(login, bannerID, retargetingConditionID, Currency.RUB);
    }

    @Deprecated
    public int addRetargetingToBanner(String login, Long bannerID, int retargetingConditionID, Currency currency) {
        return addRetargetingToBanner(login, bannerID, retargetingConditionID, currency,
                MoneyCurrency.get(currency).getMinPrice().floatValue());
    }

    @Deprecated
    public int addRetargetingToBanner(String login, Long bannerID, int retargetingConditionID, Currency currency,
            float price)
    {
        int[] retargetingIDs = addRetargetings(
                login,
                new RetargetingMap(defaultClient().getPackageName())
                        .withAdID(bannerID)
                        .withRetargetingConditionID(retargetingConditionID)
                        .withCurrency(currency)
                        .withContextPrice(price));
        return retargetingIDs[0];
    }

    @Deprecated
    public <RetargetingResponse> RetargetingResponse retargetingUpdate(String login,
            RetargetingMap... retargetingMaps)
    {
        return retargeting(
                new RetargetingRequestMap(defaultClient().getPackageName())
                        .withAction(Action.UPDATE)
                        .withLogin(login)
                        .withRetargetings(retargetingMaps)
        );
    }

    //endregion

    //region GetRetargetingGoals
    @Step("[GetRetargetingGoals]")
    public <RetargetingGoal> RetargetingGoal[] getRetargetingGoals(
            GetRetargetingGoalsRequestMap getRetargetingGoalsRequestMap)
    {
        return defaultClient().invokeMethod(Method.GET_RETARGETING_GOALS, getRetargetingGoalsRequestMap.getBean());
    }

    public <RetargetingGoal> RetargetingGoal[] getRetargetingGoals(String... logins) {
        return getRetargetingGoals(
                new GetRetargetingGoalsRequestMap(defaultClient().getPackageName())
                        .withLogins(logins)
        );
    }

    public List<RetargetingGoal> getRetargetingGoals(RetargetingGoalType type, String... logins) {

        RetargetingGoal[] goals = getRetargetingGoals(
                new GetRetargetingGoalsRequestMap(defaultClient().getPackageName())
                        .withLogins(logins)
        );

        List<RetargetingGoal> retGoals = Stream.of(goals).filter(goal -> goal
                .getType().equals(type.toString())).collect(Collectors.toList());

        return retGoals;
    }


    public List<Long> getRetargetingGoalIDs(String login) {
        Object[] goals = getRetargetingGoals(login);
        List<Long> goalIDs = extractProperty(goals, RetargetingGoalMap.GOAL_ID);
        assumeThat("у пользователя есть цели в метрике", goalIDs.size(), greaterThan(0));
        return goalIDs;
    }


    public List<Long> getRetargetingGoalIDsByType(String login, RetargetingGoalType type) {
        RetargetingGoal[] goals = getRetargetingGoals(
                new GetRetargetingGoalsRequestMap(defaultClient().getPackageName())
                        .withLogins(login)
        );
        List<RetargetingGoal> retGoals = Stream.of(goals).filter(goal -> goal
                .getType().equals(type.toString())).collect(Collectors.toList());

        List<Long> goalIDs = retGoals.stream().map(goal -> goal.getGoalID()).collect(Collectors.toList());
        assumeThat("у пользователя есть цели в метрике", goalIDs.size(), greaterThan(0));
        return goalIDs;
    }
    //endregion

    //region  RetargetingCondition: Get/Delete
    //region Get
    @Deprecated
    @Step("[RetargetingCondition.Get]")
    public <RetargetingConditionResponse> RetargetingConditionResponse retargetingConditionGet(
            RetargetingConditionSelectionCriteriaMap retargetingConditionSelectionCriteriaMap)
    {
        return retargetingCondition(
                new RetargetingConditionRequestMap(defaultClient().getPackageName())
                        .withAction(Action.GET)
                        .withSelectionCriteria(retargetingConditionSelectionCriteriaMap)
        );
    }

    @Deprecated
    public <RetargetingCondition> RetargetingCondition[] getRetargetingCondition(
            RetargetingConditionSelectionCriteriaMap retargetingConditionSelectionCriteriaMap)
    {
        Object response = retargetingConditionGet(retargetingConditionSelectionCriteriaMap);
        return (RetargetingCondition[]) new BeanMap(response).get("retargetingConditions");
    }

    @Deprecated
    public int[] getRetargetingConditions(String login) {
        Object[] retargetingConditions = getRetargetingCondition(
                new RetargetingConditionSelectionCriteriaMap(defaultClient().getPackageName()).withLogins(login)
        );
        return getRetargetingConditionIDs(retargetingConditions);
    }

    @Deprecated
    public RetargetingCondition getRetargetingCondition(int retargetingConditionID) {
        return getRetargetingCondition(null, retargetingConditionID);
    }

    @Deprecated
    public RetargetingCondition getRetargetingCondition(String login, int retargetingConditionID) {
        RetargetingCondition[] retargetingConditions = getRetargetingCondition(
                new RetargetingConditionSelectionCriteriaMap(defaultClient().getPackageName())
                        .withRetargetingConditionIDS(retargetingConditionID)
                        .withLogins(login)
        );
        assumeThat("в ответе получено одно условие ретаргетинга", retargetingConditions.length, lessThan(2));
        if (retargetingConditions.length == 1) {
            return retargetingConditions[0];
        } else {
            return null;
        }
    }
    //endregion

    //region Delete
    @Deprecated
    @Step("[RetargetingCondition.Delete]")
    public <RetargetingConditionResponse> RetargetingConditionResponse retargetingConditionDelete(
            RetargetingConditionSelectionCriteriaMap retargetingConditionSelectionCriteriaMap)
    {
        return retargetingCondition(
                new RetargetingConditionRequestMap(defaultClient().getPackageName())
                        .withAction(Action.DELETE)
                        .withSelectionCriteria(retargetingConditionSelectionCriteriaMap)
        );
    }

    @Deprecated
    public void retargetingConditionDelete(String login) {
        retargetingConditionDelete(
                new RetargetingConditionSelectionCriteriaMap(defaultClient().getPackageName()).withLogins(login)
        );
    }

    @Deprecated
    public void retargetingConditionDelete(int... retargetingConditionID) {
        retargetingConditionDelete(
                new RetargetingConditionSelectionCriteriaMap(defaultClient().getPackageName())
                        .withRetargetingConditionIDS(retargetingConditionID)
        );
    }

    //endregion

    //region Add/Update
    @Deprecated
    @Step("[RetargetingCondition.Add]")
    public <RetargetingConditionResponse> RetargetingConditionResponse retargetingConditionAdd(
            RetargetingConditionMap... retargetingConditionMaps)
    {
        RetargetingConditionResponse response = retargetingCondition(
                new RetargetingConditionRequestMap(defaultClient().getPackageName())
                        .withAction(Action.ADD)
                        .withRetargetingConditions(retargetingConditionMaps));
        putToQueue(response);
        return response;
    }

    @Deprecated
    @Step("[RetargetingCondition.Update]")
    public <RetargetingConditionResponse> RetargetingConditionResponse retargetingConditionUpdate(
            RetargetingConditionMap... retargetingConditionMaps)
    {
        return retargetingCondition(
                new RetargetingConditionRequestMap(defaultClient().getPackageName())
                        .withAction(Action.UPDATE)
                        .withRetargetingConditions(retargetingConditionMaps));
    }


    @Deprecated
    public int[] addRetargetingConditions(RetargetingConditionMap... retargetingConditionMaps) {
        Object response = retargetingConditionAdd(retargetingConditionMaps);
        assumeThat("ответ не содержит ошибок", JsonUtils.toString(response), ApiResponse.hasNoError());
        return getRetargetingConditionIDs((Object[]) new BeanMap(response).get("actionsResult"));
    }

    @Deprecated
    public Integer addRandomRetargetingCondition(String clientLogin) {
        RetargetingConditionMap conditionMap = generateRandomRetargetingCondition(clientLogin);
        int[] conditionId = addRetargetingConditions(conditionMap);
        assumeThat("получили id условия ретаргетинга", conditionId.length, equalTo(1));
        return conditionId[0];
    }
    //endregion
    //endregion


    /**
     * Генерирует рандомное условие ретаргетинга для юзера
     * Для этого используются случайные цели, доступные для этого юзера, запрашиваются в самом начале
     * Если целей нет выдается ошибка
     * Количество условий варьируется от 1 до 10
     * Тип цели выбирается случайным, за исключением 1го условия, для него всегда ALL, чтобы гарантированно была хотя
     * бы одна положительная цель
     * Количество целей в каждом условии от 1 до 5
     * Время для целей рандомное от 1 до 30
     *
     * @param login Логин юзера
     * @return полный бин RetargetingCondition
     */
    @Deprecated
    @Step("generateRandomRetargetingCondition for {0}")
    public RetargetingConditionMap generateRandomRetargetingCondition(String login) {
        Object[] goals;
        try {
            goals = getRetargetingGoals(login);
        } catch (AxisError e) {
            throw new DirectAPIException("Failed to get retargeting goals for login " + login + "." +
                    " Please, set up goals from metrica first", e);
        }

        RetargetingConditionMap retargetingConditionMap = new RetargetingConditionMap(defaultClient().getPackageName())
                .defaultRetargeting(login);

        int conditionsCount = RandomUtils.getRandomInteger(1, 10);
        List<RetargetingConditionItemMap> conditionItems = new ArrayList<RetargetingConditionItemMap>();
        for (int i = 0; i < conditionsCount; i++) {
            RetargetingConditionItemMap retargetingConditionItemMap =
                    new RetargetingConditionItemMap(defaultClient().getPackageName())
                            .withRandomType()
                            .withGoals(generateRandomRetargetingConditionGoalItems(
                                    convert(goals,
                                            new BeanToBeanMapConverter<RetargetingGoalMap>(RetargetingGoalMap.class))));
            //в условии должна быть хотя бы одна положительная цель, к примеру, первая
            if (i == 0) {
                retargetingConditionItemMap.withType(RetargetingType.ALL);
            }
            conditionItems.add(retargetingConditionItemMap);
        }
        RetargetingConditionItemMap[] groupItems =
                conditionItems.toArray(new RetargetingConditionItemMap[conditionItems.size()]);
        return retargetingConditionMap.withRetargetingConditionItems(groupItems).withLogin(login);
    }

    @Deprecated
    @Step("generateRandomRetargetingCondition for {0} with goals")
    public RetargetingConditionMap generateRandomRetargetingCondition(String login, Object... goals) {
        RetargetingConditionMap retargetingConditionMap = new RetargetingConditionMap(defaultClient().getPackageName())
                .defaultRetargeting(login);

        int conditionsCount = RandomUtils.getRandomInteger(1, 10);
        List<RetargetingConditionItemMap> conditionItems = new ArrayList<RetargetingConditionItemMap>();
        for (int i = 0; i < conditionsCount; i++) {
            RetargetingConditionItemMap retargetingConditionItemMap =
                    new RetargetingConditionItemMap(defaultClient().getPackageName())
                            .withRandomType()
                            .withGoals(generateRandomRetargetingConditionGoalItems(
                                    convert(goals,
                                            new BeanToBeanMapConverter<RetargetingGoalMap>(RetargetingGoalMap.class))));
            //в условии должна быть хотя бы одна положительная цель, к примеру, первая
            if (i == 0) {
                retargetingConditionItemMap.withType(RetargetingType.ALL);
            }
            conditionItems.add(retargetingConditionItemMap);
        }
        RetargetingConditionItemMap[] groupItems =
                conditionItems.toArray(new RetargetingConditionItemMap[conditionItems.size()]);
        return retargetingConditionMap.withRetargetingConditionItems(groupItems).withLogin(login);
    }

    /**
     * Вспомогательный метод для генерации generateRandomRetargetingCondition
     * Генерирует рандомные цели
     *
     * @param goals
     * @return
     */
    @Deprecated
    protected RetargetingConditionGoalItemMap[] generateRandomRetargetingConditionGoalItems(
            List<RetargetingGoalMap> goals)
    {
        assumeThat("у пользователя есть цели", goals.size(), greaterThan(0));
        int goalsCount = RandomUtils.getRandomInteger(1, 5);


        List<RetargetingConditionGoalItemMap> conditionGoalItems = new ArrayList<RetargetingConditionGoalItemMap>();
        for (int goalIndex = 0; goalIndex < goalsCount; goalIndex++) {
            BeanMap goal = goals.get(
                    org.apache.commons.lang.math.RandomUtils.nextInt(goals.size()));
            long goalID = (long) goal.get(RetargetingGoalMap.GOAL_ID);
            conditionGoalItems.add(new RetargetingConditionGoalItemMap(defaultClient().getPackageName())
                    .withTime(RandomUtils.getRandomInteger(1, 30))
                    .withGoalID(goalID));
        }
        return (RetargetingConditionGoalItemMap[]) conditionGoalItems.toArray(
                new RetargetingConditionGoalItemMap(defaultClient().getPackageName()).emptyArray());
    }

    /**
     * Добавляет заданное количество рандомных условий юзеру
     *
     * @param login логин юзера
     * @param count количество генерируемых условий
     * @return список сгенерированных условий
     */
    @Deprecated
    public <RetargetingCondition> List<RetargetingCondition> addConditionsForUser(String login, int count) {
        List<RetargetingCondition> result = new ArrayList();
        Object[] goals;
        try {
            goals = getRetargetingGoals(login);
        } catch (AxisError e) {
            throw new DirectAPIException("Failed to get retargeting goals for login " + login + "." +
                    " Please, set up goals from metrica first", e);
        }

        assumeThat("у пользователя есть цели в метрике", goals.length, greaterThan(0));
        for (int i = 0; i < count; i++) {
            RetargetingConditionMap condition = generateRandomRetargetingCondition(login, goals);
            try {
                int conditionID = addRetargetingConditions(condition)[0];
                condition.withRetargetingConditionID(conditionID);
            } catch (AxisError e) {
                throw new DirectAPIException("Failed to add retargeting condition", e);
            }
            result.add((RetargetingCondition) condition.getBean());
        }
        assumeThat("добавилось " + count + " условий ретаргетинга", result, hasSize(count));
        return result;
    }

    /**
     * Добавляет заданное количество рандомных условий юзеру а так же добавляет их в баннер
     *
     * @param login    логин юзера
     * @param bannerID id баннера(созданного заранее)
     * @param count    количество генерируемых условий
     * @return список сгенерированных условий
     */
    @Deprecated
    public <RetargetingCondition> List<RetargetingCondition> addRandomConditionsForUserBanner(
            String login, Long bannerID, int count)
    {
        return addRandomConditionsForUserBanner(login, bannerID, count, Currency.RUB);
    }

    /**
     * Добавляет заданное количество рандомных условий юзеру а так же добавляет их в баннер
     *
     * @param login    логин юзера
     * @param bannerID id баннера(созданного заранее)
     * @param count    количество генерируемых условий
     * @param currency валюта
     * @return список сгенерированных условий
     */
    @Deprecated
    public <RetargetingCondition> List<RetargetingCondition> addRandomConditionsForUserBanner(
            String login, Long bannerID, int count, Currency currency)
    {
        List<RetargetingCondition> conditions = addConditionsForUser(login, count);
        for (RetargetingCondition condition : conditions) {
            int conditionID = (int) new RetargetingConditionMap(condition)
                    .get(RetargetingConditionMap.RETARGETING_CONDITION_ID);
            addRetargetingToBanner(login, bannerID, conditionID, currency);
        }
        return conditions;
    }

    @Deprecated
    public static int[] getRetargetingConditionIDs(Object[] container) {
        List<Integer> ids = extractProperty(container, RetargetingMap.RETARGETING_CONDITION_ID);
        if (!ids.isEmpty()) {
            Integer firstElement = ids.get(0);
            assumeThat("список условий ретаргетинга не пуст", firstElement, notNullValue());
        }
        return ArrayUtils.toPrimitive(ids.toArray(new Integer[0]));
    }

    public static int[] getRetargetingIDs(Object[] container) {
        List<Integer> ids = extractProperty(container, RetargetingMap.RETARGETING_ID);
        if (!ids.isEmpty()) {
            Integer firstElement = ids.get(0);
            assumeThat("список ретаргетингов не пуст", firstElement, notNullValue());
        }
        return ArrayUtils.toPrimitive(ids.toArray(new Integer[0]));
    }

}
