package ru.yandex.autotests.directapi.steps.banners;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

import com.yandex.direct.api.v5.general.ActionResult;
import com.yandex.direct.api.v5.sitelinks.AddResponse;
import com.yandex.direct.api.v5.sitelinks.DeleteResponse;
import com.yandex.direct.api.v5.sitelinks.GetResponse;
import com.yandex.direct.api.v5.sitelinks.SitelinkFieldEnum;
import com.yandex.direct.api.v5.sitelinks.SitelinksSetFieldEnum;
import com.yandex.direct.api.v5.sitelinks.SitelinksSetGetItem;

import ru.yandex.autotests.directapi.apiclient.RequestHeader;
import ru.yandex.autotests.directapi.apiclient.config.ConnectionConfig;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.version5.ServiceNames;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.sitelinks.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.sitelinks.DeleteRequestMap;
import ru.yandex.autotests.directapi.model.api5.sitelinks.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.sitelinks.SitelinksSetAddItemMap;
import ru.yandex.autotests.directapi.rules.Api5Bin;
import ru.yandex.autotests.directapi.rules.Api5Binable;
import ru.yandex.autotests.directapi.steps.BaseApiSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ch.lambdaj.Lambda.extract;
import static ch.lambdaj.Lambda.filter;
import static ch.lambdaj.Lambda.on;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by semkagtn on 10/7/14.
 */
public class SitelinksSteps extends BaseApiSteps implements Api5Binable<Long> {

    private static SitelinksSteps _instance;

    private SitelinksSteps(ConnectionConfig connectionConfig, RequestHeader requestHeader) {
        super(connectionConfig, requestHeader);
    }

    public static SitelinksSteps getInstance(ConnectionConfig connectionConfig, RequestHeader requestHeader) {
        if (_instance == null) {
            _instance = new SitelinksSteps(connectionConfig, requestHeader);
        } else {
            _instance.setConnectionConfig(connectionConfig);
            _instance.setRequestHeader(requestHeader);
        }
        return _instance;

    }

    public Api5Bin<Long> bin = new Api5Bin<>(this);

    //region Get

    @Step("[Sitelinks]: Get")
    public GetResponse sitelinksGet(String login, GetRequestMap parameters) {
        GetResponse response =
                defaultClientV5().invokeMethod(ServiceNames.SITELINKS, login, Action.GET, parameters.getBean());
        return response;
    }

    public GetResponse sitelinksGet(GetRequestMap parameters) {
        return sitelinksGet(null, parameters);
    }

    public List<SitelinksSetGetItem> get(String login, GetRequestMap parameters) {
        GetResponse response = sitelinksGet(login, parameters);
        return response.getSitelinksSets();
    }

    public List<SitelinksSetGetItem> get(GetRequestMap parameters) {
        return get(null, parameters);
    }

    public List<SitelinksSetGetItem> get(String login, Long... ids) {
        return get(login, new GetRequestMap()
                .withFieldNames(SitelinksSetFieldEnum.ID, SitelinksSetFieldEnum.SITELINKS)
                .withSelectionCriteria(new IdsCriteriaMap()
                        .withIds(ids)));
    }

    public List<SitelinksSetGetItem> getWithTurboPageId(String login, Long... ids) {
        return get(login, new GetRequestMap()
                .withFieldNames(SitelinksSetFieldEnum.ID)
                .withSitelinkFieldNames(
                        SitelinkFieldEnum.DESCRIPTION,
                        SitelinkFieldEnum.TITLE,
                        SitelinkFieldEnum.HREF,
                        SitelinkFieldEnum.TURBO_PAGE_ID)
                .withSelectionCriteria(new IdsCriteriaMap()
                        .withIds(ids)));
    }

    public List<SitelinksSetGetItem> get(Long... ids) {
        return get(null, ids);
    }

    public List<SitelinksSetGetItem> getWithTurboPageId(Long... ids) {
        return getWithTurboPageId(null, ids);
    }

    public List<SitelinksSetGetItem> get(String login, List<Long> ids) {
        return get(login, ids.toArray(new Long[0]));
    }

    public List<SitelinksSetGetItem> get(List<Long> ids) {
        return get(null, ids);
    }

    public List<SitelinksSetGetItem> getWithTurboPageId(List<Long> ids) {
        return getWithTurboPageId(null, ids.toArray(new Long[0]));
    }

    public void expectErrorOnGet(String login, GetRequestMap parameters, Api5Error api5Error) {
        shouldGetErrorOn(ServiceNames.SITELINKS, login, Action.GET, parameters, api5Error);
    }

    public void expectErrorOnGet(GetRequestMap parameters, Api5Error api5Error) {
        expectErrorOnGet(null, parameters, api5Error);
    }

    public void expectErrorOnGet(String login, Object parameters, Api5Error api5Error) {
        shouldGetJSONErrorOn(ServiceNames.SITELINKS, login, Action.GET, parameters, api5Error);
    }

    public void expectErrorOnGet(Object parameters, Api5Error api5Error) {
        expectErrorOnGet(null, parameters, api5Error);
    }
    //endregion

    //region Add
    @Step("[Sitelinks]: Add")
    public List<Long> add(String login, AddRequestMap parameters) {
        AddResponse response = defaultClientV5().invokeMethod(
                ServiceNames.SITELINKS, login, Action.ADD, parameters.getBean());
        throwToBin(login, response);
        return extractIdsFromAddResponse(response);
    }

    public List<Long> add(AddRequestMap parameters) {
        return add(null, parameters);
    }

    public long addDefaultSet(String login, int sitelinksAmount) {
        List<Long> ids = add(login, new AddRequestMap()
                .withSitelinksSets(new SitelinksSetAddItemMap()
                        .defaultSitelinksSet(sitelinksAmount)));
        assumeThat("был добавлен один набор сайтлинков", ids, hasSize(1));
        return ids.get(0);
    }

    public long addDefaultSet(int sitelinksAmount) {
        return addDefaultSet(null, sitelinksAmount);
    }

    public long addDefaultSetWithDescriptions(String login, int sitelinksAmount) {
        List<Long> ids = add(login, new AddRequestMap()
                .withSitelinksSets(new SitelinksSetAddItemMap()
                        .defaultSitelinksSetWithDescriptions(sitelinksAmount)));
        assumeThat("был добавлен один набор сайтлинков", ids, hasSize(1));
        return ids.get(0);
    }

    public long addDefaultSetWithDescriptions(int sitelinksAmount) {
        return addDefaultSetWithDescriptions(null, sitelinksAmount);
    }

    public void expectErrorOnAdd(String login, AddRequestMap parameters, Api5Error api5Error) {
        shouldGetErrorOn(ServiceNames.SITELINKS, login, Action.ADD, parameters, api5Error);
    }

    public void expectErrorOnAdd(AddRequestMap parameters, Api5Error api5Error) {
        expectErrorOnAdd(null, parameters, api5Error);
    }

    public void expectErrorOnAdd(String login, Object parameters, Api5Error api5Error) {
        shouldGetJSONErrorOn(ServiceNames.SITELINKS, login, Action.ADD, parameters, api5Error);
    }

    public void expectErrorOnAdd(Object parameters, Api5Error api5Error) {
        expectErrorOnAdd(null, parameters, api5Error);
    }

    public AddResponse shouldGetResultOnAdd(String login, AddRequestMap parameters, ExpectedResult... expectedResults) {
        AddResponse response = (AddResponse) shouldGetResultOn(
                ServiceNames.SITELINKS, login, Action.ADD, parameters, expectedResults);
        throwToBin(login, response);
        return response;
    }

    public AddResponse shouldGetResultOnAdd(AddRequestMap parameters, ExpectedResult... expectedResults) {
        return shouldGetResultOnAdd(null, parameters, expectedResults);
    }
    //endregion

    //region Delete
    @Step("[Sitelinks]: Delete")
    public DeleteResponse delete(String login, DeleteRequestMap parameters) {
        DeleteResponse response = defaultClientV5().invokeMethod(
                ServiceNames.SITELINKS, login, Action.DELETE, parameters.getBean());
        return response;
    }

    public DeleteResponse delete(DeleteRequestMap parameters) {
        return delete(null, parameters);
    }

    public DeleteResponse delete(String login, Long... ids) {
        return delete(login, new DeleteRequestMap()
                .withSelectionCriteria(new IdsCriteriaMap()
                        .withIds(ids)));
    }

    public DeleteResponse delete(Long... ids) {
        return delete(null, ids);
    }

    public DeleteResponse delete(String login, List<Long> ids) {
        return delete(login, ids.toArray(new Long[0]));
    }

    public DeleteResponse delete(List<Long> ids) {
        return delete(null, ids);
    }

    public void expectErrorOnDelete(String login, DeleteRequestMap parameters, Api5Error api5Error) {
        shouldGetErrorOn(ServiceNames.SITELINKS, login, Action.DELETE, parameters, api5Error);
    }

    public void expectErrorOnDelete(DeleteRequestMap parameters, Api5Error api5Error) {
        expectErrorOnDelete(null, parameters, api5Error);
    }

    public void expectErrorOnDelete(String login, Object parameters, Api5Error api5Error) {
        shouldGetJSONErrorOn(ServiceNames.SITELINKS, login, Action.DELETE, parameters, api5Error);
    }

    public void expectErrorOnDelete(Object parameters, Api5Error api5Error) {
        expectErrorOnDelete(null, parameters, api5Error);
    }

    public DeleteResponse shouldGetResultOnDelete(
            String login, DeleteRequestMap parameters, ExpectedResult... expectedResults)
    {
        DeleteResponse response = (DeleteResponse) shouldGetResultOn(
                ServiceNames.SITELINKS, login, Action.DELETE, parameters, expectedResults);
        return response;
    }

    public DeleteResponse shouldGetResultOnDelete(DeleteRequestMap parameters, ExpectedResult... expectedResults) {
        return shouldGetResultOnDelete(null, parameters, expectedResults);
    }

    //endregion

    private List<Long> extractIdsFromAddResponse(AddResponse addResponse) {
        return filter(notNullValue(), extract(addResponse.getAddResults(), on(ActionResult.class).getId()));
    }

    private void throwToBin(String login, AddResponse addResponse) {
        List<Long> ids = extractIdsFromAddResponse(addResponse);
        for (Long id : ids) {
            bin.throwToBin(id, login != null ? login :
                    (requestHeader.getFakeLogin() != null ? requestHeader.getFakeLogin() : requestHeader.getLogin()));
        }
    }

    private void removeFromBin(DeleteResponse deleteResponse) {
        List<Long> ids = extract(deleteResponse.getDeleteResults(), on(ActionResult.class).getId());
        for (Long id : ids) {
            bin.removeFromBin(id);
        }
    }

    @Override
    public Callable clearBin(final Map<Long, String> binData) {
        return new Callable() {
            @Override
            public Object call() throws Exception {
                Map<String, List<Long>> loginToIds = new HashMap<>();
                for (Map.Entry<Long, String> entry : binData.entrySet()) {
                    Long id = entry.getKey();
                    String login = entry.getValue();
                    if (!loginToIds.containsKey(login)) {
                        loginToIds.put(login, new ArrayList<Long>());
                    }
                    loginToIds.get(login).add(id);
                }
                for (Map.Entry<String, List<Long>> entry : loginToIds.entrySet()) {
                    String login = entry.getKey();
                    List<Long> ids = entry.getValue();
                    delete(login, ids);
                }
                return null;
            }
        };
    }
}
