package ru.yandex.autotests.directapi.steps.banners;

import java.util.List;

import org.apache.commons.beanutils.BeanMap;
import org.apache.commons.lang.ArrayUtils;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.converter.BeanToBeanMapConverter;
import ru.yandex.autotests.directapi.apiclient.RequestHeader;
import ru.yandex.autotests.directapi.apiclient.config.ConnectionConfig;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.common.api45.APIPort_PortType;
import ru.yandex.autotests.directapi.model.banners.tags.BannerTagsInfoMap;
import ru.yandex.autotests.directapi.model.banners.tags.BannersRequestInfoMap;
import ru.yandex.autotests.directapi.model.banners.tags.CampaignTagsInfoMap;
import ru.yandex.autotests.directapi.model.banners.tags.TagInfoMap;
import ru.yandex.autotests.directapi.model.campaigns.CampaignIDsInfoMap;
import ru.yandex.autotests.directapi.steps.BaseApiSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ch.lambdaj.Lambda.convert;
import static ch.lambdaj.Lambda.extractProperty;
import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created with IntelliJ IDEA.
 * User: mariabye
 * Date: 20.09.13
 * Time: 16:14
 * To change this template use File | Settings | File Templates.
 */
public class TagSteps extends BaseApiSteps {

    private static TagSteps _instance;

    private TagSteps(ConnectionConfig connectionConfig, RequestHeader requestHeader) {
        super(connectionConfig, requestHeader);
    }

    public static TagSteps getInstance(ConnectionConfig connectionConfig, RequestHeader requestHeader) {
        ConnectionConfig modifiedConfig = connectionConfig.clone().version(104).apiPortType(APIPort_PortType.class);
        if (_instance == null) {
            _instance = new TagSteps(modifiedConfig, requestHeader);
        } else {
            _instance.setConnectionConfig(modifiedConfig);
            _instance.setRequestHeader(requestHeader);
        }
        return _instance;
    }


    //region GetBannersTags
    @Step("[GetBannersTags]")
    public <BannerTagsInfo> BannerTagsInfo[] getBannersTags(BannersRequestInfoMap bannersRequestInfoMap) {
        return defaultClient().invokeMethod(Method.GET_BANNERS_TAGS, bannersRequestInfoMap.getBean());
    }

    @Step("Получить список ids меток объявления")
    public int[] getBannerTags(Long bannerID) {
        Object[] bannerTagsInfo = getBannersTags(
                new BannersRequestInfoMap(defaultClient().getPackageName())
                        .withBannerIDS(bannerID));
        assumeThat("получена информация об одном баннере", bannerTagsInfo.length, equalTo(1));
        int[] tagIDs = (int[]) new BeanMap(bannerTagsInfo[0]).get("tagIDS");
        return tagIDs;
    }

    @Step("Получить список ids меток кампании")
    public int[] getCampaignTagIDs(int campaignID) {
        Object[] bannerTagsInfo = getBannersTags(
                new BannersRequestInfoMap(defaultClient().getPackageName())
                        .withCampaignIDS(campaignID));
        int[] tagIDs = (int[]) new BeanMap(bannerTagsInfo[0]).get("tagIDS");
        return tagIDs;
    }
    //endregion

    //region GetCampaignsTags
    @Step("[GetCampaignsTags]")
    public <CampaignTagsInfo> CampaignTagsInfo[] getCampaignsTags(CampaignIDsInfoMap campaignIDsInfoMap) {
        return defaultClient().invokeMethod(Method.GET_CAMPAIGNS_TAGS, campaignIDsInfoMap.getBean());
    }

    @Step("Получить список меток кампаний")
    public <T> T[] getCampaignsTags(int... campaignIDs) {
        return getCampaignsTags(new CampaignIDsInfoMap(defaultClient().getPackageName()).withCampaignIDs(campaignIDs));
    }

    public <T> T[] getCampaignsTags(Long... campaignIds) {
        int[] campaignIdsInt = new int[campaignIds.length];
        for (int i = 0; i < campaignIds.length; i++) {
            campaignIdsInt[i] = campaignIds[i].intValue();
        }
        return getCampaignsTags(campaignIdsInt);
    }
    //endregion

    //region UpdateBannersTags
    @Step("[UpdateBannersTags]")
    public int updateBannersTags(BannerTagsInfoMap... bannerTagsInfoMap) {
        Object[] params = convert(bannerTagsInfoMap, new BeanMapToBeanConverter<BeanMap, Object>()).toArray();
        return defaultClient().invokeMethod(Method.UPDATE_BANNERS_TAGS, params);
    }

    @Step("Добавление меток в объявление")
    public int updateBannerTags(Long bannerID, int... tagIDs) {
        BannerTagsInfoMap bannerTagsInfoMap = new BannerTagsInfoMap(defaultClient().getPackageName())
                .withBannerID(bannerID)
                .withTags(tagIDs);
        return updateBannersTags(bannerTagsInfoMap);
    }
    //endregion

    //region UpdateCampaignsTags
    @Step("[UpdateCampaignsTags]")
    public <CampaignTagsInfo> CampaignTagsInfo[] updateCampaignsTags(CampaignTagsInfoMap... campaignTagsInfoMap) {
        Object[] params = convert(campaignTagsInfoMap, new BeanMapToBeanConverter<BeanMap, Object>()).toArray();
        return defaultClient().invokeMethod(Method.UPDATE_CAMPAIGNS_TAGS, params);
    }

    @Step("Добавление меток в кампанию")
    public int[] addTags(int campaignID, String... tags) {
        Object[] campaignTagsInfos = getCampaignsTags(campaignID);
        CampaignTagsInfoMap campaignTagsInfoMap = new CampaignTagsInfoMap(campaignTagsInfos[0]);
        Object[] tagInfos = (Object[]) campaignTagsInfoMap.get(CampaignTagsInfoMap.TAGS);

        TagInfoMap[] tagMaps = convert(tagInfos, new BeanToBeanMapConverter<TagInfoMap>(TagInfoMap.class))
                .toArray(new TagInfoMap[0]);
        for (String tag : tags) {
            TagInfoMap tagInfoMap = new TagInfoMap(defaultClient().getPackageName())
                    .withTagID(0)
                    .withTag(tag);
            tagMaps = (TagInfoMap[]) ArrayUtils.add(tagMaps, tagInfoMap);
        }

        campaignTagsInfoMap
                .withCampaignID(campaignID).withTags(tagMaps);

        Object[] campaignsTags = updateCampaignsTags(campaignTagsInfoMap);
        Object[] campaignTags = (Object[]) new BeanMap(campaignsTags[0]).get(CampaignTagsInfoMap.TAGS);
        return getTagIDs(campaignTags);
    }

    public int[] addTags(Long campaignId, String... tags) {
        return addTags(campaignId.intValue(), tags);
    }
    //endregion

    public static int[] getTagIDs(Object[] container) {
        List<Integer> ids = extractProperty(container, TagInfoMap.TAG_ID);
        return ArrayUtils.toPrimitive(ids.toArray(new Integer[0]));
    }
}
