package ru.yandex.autotests.directapi.steps.banners;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

import com.yandex.direct.api.v5.turbopages.GetResponse;
import com.yandex.direct.api.v5.turbopages.TurboPageFieldEnum;
import com.yandex.direct.api.v5.turbopages.TurboPageGetItem;

import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.directapi.apiclient.RequestHeader;
import ru.yandex.autotests.directapi.apiclient.config.ConnectionConfig;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.version5.ServiceNames;
import ru.yandex.autotests.directapi.darkside.steps.DarkSideSteps;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.turbopages.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.turbopages.TurboPagesCriteriaMap;
import ru.yandex.autotests.directapi.rules.Api5Bin;
import ru.yandex.autotests.directapi.rules.Api5Binable;
import ru.yandex.autotests.directapi.steps.BaseApiSteps;
import ru.yandex.qatools.allure.annotations.Step;

/**
 * Created by adubinkin on 18/04/19.
 */
public class TurboPagesSteps extends BaseApiSteps implements Api5Binable<Long> {

    private static TurboPagesSteps _instance;
    private static DirectJooqDbSteps _jooqSteps;

    private TurboPagesSteps(ConnectionConfig connectionConfig, RequestHeader requestHeader) {
        super(connectionConfig, requestHeader);
    }

    public static TurboPagesSteps getInstance(ConnectionConfig connectionConfig, RequestHeader requestHeader) {
        if (_instance == null) {
            _instance = new TurboPagesSteps(connectionConfig, requestHeader);
            _jooqSteps = new DarkSideSteps(DirectTestRunProperties.getInstance()).getDirectJooqDbSteps();


        } else {
            _instance.setConnectionConfig(connectionConfig);
            _instance.setRequestHeader(requestHeader);
        }
        return _instance;

    }

    public Api5Bin<Long> bin = new Api5Bin<>(this);

    //region Get

    @Step("[TurboPages]: Get")
    public GetResponse turboPagesGet(String login, GetRequestMap parameters) {
        GetResponse response =
                defaultClientV5().invokeMethod(ServiceNames.TURBO_PAGES, login, Action.GET, parameters.getBean());
        return response;
    }

    public GetResponse turboPagesGet(GetRequestMap parameters) {
        return turboPagesGet(null, parameters);
    }

    public List<TurboPageGetItem> get(String login, GetRequestMap parameters) {
        GetResponse response = turboPagesGet(login, parameters);
        return response.getTurboPages();
    }

    public List<TurboPageGetItem> get(GetRequestMap parameters) {
        return get(null, parameters);
    }

    public List<TurboPageGetItem> get(String login, Long... ids) {
        return get(login, new GetRequestMap()
                .withFieldNames(TurboPageFieldEnum.values())
                .withSelectionCriteria(new TurboPagesCriteriaMap()
                        .withIds(ids)));
    }

    public List<TurboPageGetItem> get(Long... ids) {
        return get(null, ids);
    }

    public List<TurboPageGetItem> get(String login, List<Long> ids) {
        return get(login, ids.toArray(new Long[0]));
    }

    public List<TurboPageGetItem> get(List<Long> ids) {
        return get(null, ids);
    }

    public void expectErrorOnGet(String login, GetRequestMap parameters, Api5Error api5Error) {
        shouldGetErrorOn(ServiceNames.TURBO_PAGES, login, Action.GET, parameters, api5Error);
    }

    public void expectErrorOnGet(GetRequestMap parameters, Api5Error api5Error) {
        expectErrorOnGet(null, parameters, api5Error);
    }

    public void expectErrorOnGet(String login, Object parameters, Api5Error api5Error) {
        shouldGetJSONErrorOn(ServiceNames.TURBO_PAGES, login, Action.GET, parameters, api5Error);
    }

    public void expectErrorOnGet(Object parameters, Api5Error api5Error) {
        expectErrorOnGet(null, parameters, api5Error);
    }
    //endregion


    @Override
    public Callable clearBin(final Map<Long, String> binData) {
        return new Callable() {
            @Override
            public Object call() throws Exception {
                Map<String, List<Long>> loginToIds = new HashMap<>();
                for (Map.Entry<Long, String> entry : binData.entrySet()) {
                    Long id = entry.getKey();
                    String login = entry.getValue();
                    if (!loginToIds.containsKey(login)) {
                        loginToIds.put(login, new ArrayList<Long>());
                    }
                    loginToIds.get(login).add(id);
                }
                for (Map.Entry<String, List<Long>> entry : loginToIds.entrySet()) {
                    String login = entry.getKey();
                    List<Long> ids = entry.getValue();
                    _jooqSteps.useShardForLogin(login).turboLandingsSteps().deleteTurboLandings(ids);
                }
                return null;
            }
        };
    }
}
