package ru.yandex.autotests.directapi.steps.businesses;

import com.yandex.direct.api.v5.businesses.GetResponse;
import ru.yandex.autotests.directapi.apiclient.RequestHeader;
import ru.yandex.autotests.directapi.apiclient.config.ConnectionConfig;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.version5.ServiceNames;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.businesses.GetRequestMap;
import ru.yandex.autotests.directapi.steps.BaseApiSteps;
import ru.yandex.qatools.allure.annotations.Step;

public class BusinessesSteps extends BaseApiSteps {

    private static BusinessesSteps _instance;

    private BusinessesSteps(ConnectionConfig connectionConfig, RequestHeader requestHeader) {
        super(connectionConfig, requestHeader);
    }

    public static BusinessesSteps getInstance(ConnectionConfig connectionConfig, RequestHeader requestHeader) {
        if (_instance == null) {
            _instance = new BusinessesSteps(connectionConfig, requestHeader);
        } else {
            _instance.setConnectionConfig(connectionConfig);
            _instance.setRequestHeader(requestHeader);
        }
        return _instance;
    }

    @Step("[Businesses]: Get")
    public GetResponse businessesGet(String login, GetRequestMap parameters) {
        return defaultClientV5()
                .invokeMethod(ServiceNames.BUSINESSES, login, Action.GET, parameters.getBean());
    }

    public void shouldGetResultOnGet(String login, GetRequestMap parameters, Api5Error api5Error) {
        shouldGetErrorOn(ServiceNames.BUSINESSES, login, Action.GET, parameters, api5Error);
    }
}
