package ru.yandex.autotests.directapi.steps.common;

import ru.yandex.autotests.directapi.apiclient.RequestHeader;
import ru.yandex.autotests.directapi.apiclient.config.ConnectionConfig;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.steps.BaseApiSteps;
import ru.yandex.qatools.allure.annotations.Step;

/**
 * Created by chicos on 27.08.14.
 */
public class GetRegionsSteps extends BaseApiSteps {
    private static GetRegionsSteps _instance;

    private GetRegionsSteps(ConnectionConfig connectionConfig, RequestHeader requestHeader) {
        super(connectionConfig, requestHeader);
    }

    public static GetRegionsSteps getInstance(ConnectionConfig connectionConfig, RequestHeader requestHeader) {
        if (_instance == null) {
            _instance = new GetRegionsSteps(connectionConfig, requestHeader);
        } else {
            _instance.setConnectionConfig(connectionConfig);
            _instance.setRequestHeader(requestHeader);
        }
        return _instance;

    }

    @Step("[GetRegions]")
    public <T> T[] getRegions() {
        return (T[]) defaultClient().invokeMethod(Method.GET_REGIONS, null);
    }
}
