package ru.yandex.autotests.directapi.steps.common;

import ru.yandex.autotests.directapi.apiclient.RequestHeader;
import ru.yandex.autotests.directapi.apiclient.config.ConnectionConfig;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.steps.BaseApiSteps;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;

/**
 * Created by chicos on 11.03.14.
 */
public class GetVersionsSteps extends BaseApiSteps {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    private static GetVersionsSteps _instance;

    private GetVersionsSteps(ConnectionConfig connectionConfig, RequestHeader requestHeader) {
        super(connectionConfig, requestHeader);
    }

    public static GetVersionsSteps getInstance(ConnectionConfig connectionConfig, RequestHeader requestHeader) {
        if (_instance == null) {
            _instance = new GetVersionsSteps(connectionConfig, requestHeader);
        } else {
            _instance.setConnectionConfig(connectionConfig);
            _instance.setRequestHeader(requestHeader);
        }
        return _instance;

    }

    public <T> T[] getAvailableVersions() {
        return (T[]) defaultClient().invokeMethod(Method.GET_AVAILABLE_VERSIONS, null);
    }
}
