package ru.yandex.autotests.directapi.steps.common;

import ru.yandex.autotests.directapi.apiclient.RequestHeader;
import ru.yandex.autotests.directapi.apiclient.config.ConnectionConfig;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.steps.BaseApiSteps;
import ru.yandex.qatools.allure.annotations.Step;

/**
 * Author pavryabov
 * Date 26.09.14
 */
public class PingAPISteps extends BaseApiSteps {
    private static PingAPISteps _instance;

    private PingAPISteps(ConnectionConfig connectionConfig, RequestHeader requestHeader) {
        super(connectionConfig, requestHeader);
    }

    public static PingAPISteps getInstance(ConnectionConfig connectionConfig, RequestHeader requestHeader) {
        if (_instance == null) {
            _instance = new PingAPISteps(connectionConfig, requestHeader);
        } else {
            _instance.setConnectionConfig(connectionConfig);
            _instance.setRequestHeader(requestHeader);
        }
        return _instance;

    }

    @Step("[PingAPISteps]")
    public int pingAPI() {
        return defaultClient().invokeMethod(Method.PING_API, null);
    }
}
