package ru.yandex.autotests.directapi.steps.dynamictextadtargets;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

import com.yandex.direct.api.v5.dynamictextadtargets.AddRequest;
import com.yandex.direct.api.v5.dynamictextadtargets.AddResponse;
import com.yandex.direct.api.v5.dynamictextadtargets.DeleteRequest;
import com.yandex.direct.api.v5.dynamictextadtargets.DeleteResponse;
import com.yandex.direct.api.v5.dynamictextadtargets.GetRequest;
import com.yandex.direct.api.v5.dynamictextadtargets.GetResponse;
import com.yandex.direct.api.v5.dynamictextadtargets.ResumeRequest;
import com.yandex.direct.api.v5.dynamictextadtargets.ResumeResponse;
import com.yandex.direct.api.v5.dynamictextadtargets.SetBidsRequest;
import com.yandex.direct.api.v5.dynamictextadtargets.SetBidsResponse;
import com.yandex.direct.api.v5.dynamictextadtargets.SuspendRequest;
import com.yandex.direct.api.v5.dynamictextadtargets.SuspendResponse;
import com.yandex.direct.api.v5.dynamictextadtargets.WebpageFieldEnum;
import com.yandex.direct.api.v5.dynamictextadtargets.WebpageGetItem;
import com.yandex.direct.api.v5.general.ActionResult;
import com.yandex.direct.api.v5.general.AdTargetStateSelectionEnum;
import org.apache.commons.beanutils.BeanMap;

import ru.yandex.autotests.directapi.apiclient.RequestHeader;
import ru.yandex.autotests.directapi.apiclient.config.ConnectionConfig;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.version5.ServiceNames;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.DeleteRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.ResumeRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.SetBidsRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.SuspendRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageConditionMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpagesSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlApi5Error;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlSetBidsExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.SetBidsExpectedResult;
import ru.yandex.autotests.directapi.steps.BaseApiSteps;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ch.lambdaj.Lambda.extract;
import static ch.lambdaj.Lambda.filter;
import static ch.lambdaj.Lambda.on;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by buhter on 02/09/15.
 */
public class DynamicTextAdTargetsSteps extends BaseApiSteps {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    private static DynamicTextAdTargetsSteps _instance;

    private DynamicTextAdTargetsSteps(ConnectionConfig connectionConfig, RequestHeader requestHeader) {
        super(connectionConfig, requestHeader);
    }

    public static DynamicTextAdTargetsSteps getInstance(ConnectionConfig connectionConfig,
            RequestHeader requestHeader)
    {
        if (_instance == null) {
            _instance = new DynamicTextAdTargetsSteps(connectionConfig, requestHeader);
        } else {
            _instance.setConnectionConfig(connectionConfig);
            _instance.setRequestHeader(requestHeader);
        }
        return _instance;
    }

    public <T extends BeanMap> void shouldGetResultOn(Action action,
            String login,
            T args,
            ExpectedResult... expectedResults)
    {
        shouldGetResultOn(ServiceNames.DYNAMIC_TEXT_AD_TARGETS, login, action, args, expectedResults);
    }

    //region Get
    @Step("[DynamicTextAdTargets]: Get")
    public GetResponse dynamicTextAdTargetsGet(GetRequestMap parameters, String login) {
        return defaultClientV5().invokeMethod(ServiceNames.DYNAMIC_TEXT_AD_TARGETS, login, Action.GET,
                (GetRequest) parameters.getBean());
    }

    public GetResponse dynamicTextAdTargetsGetFieldNamesById(Long id, String login, WebpageFieldEnum... fieldNames) {
        return defaultClientV5().invokeMethod(ServiceNames.DYNAMIC_TEXT_AD_TARGETS, login, Action.GET, (GetRequest)
                new GetRequestMap().withSelectionCriteria(
                        new WebpagesSelectionCriteriaMap()
                                .withIds(id)
                                .withStates(AdTargetStateSelectionEnum.ON,
                                        AdTargetStateSelectionEnum.DELETED,
                                        AdTargetStateSelectionEnum.OFF,
                                        AdTargetStateSelectionEnum.SUSPENDED)
                )
                        .withFieldNames(fieldNames)
                        .getBean());
    }

    public GetResponse dynamicTextAdTargetsGetAllFieldNamesById(Long id, String login) {
        return defaultClientV5().invokeMethod(ServiceNames.DYNAMIC_TEXT_AD_TARGETS, login, Action.GET, (GetRequest)
                new GetRequestMap().withSelectionCriteria(
                        new WebpagesSelectionCriteriaMap()
                                .withIds(id)
                                .withStates(AdTargetStateSelectionEnum.ON,
                                        AdTargetStateSelectionEnum.DELETED,
                                        AdTargetStateSelectionEnum.DELETED,
                                        AdTargetStateSelectionEnum.SUSPENDED)
                )
                        .withFieldNames(WebpageFieldEnum.CAMPAIGN_ID,
                                WebpageFieldEnum.AD_GROUP_ID,
                                WebpageFieldEnum.BID,
                                WebpageFieldEnum.CONDITIONS,
                                WebpageFieldEnum.CONDITION_TYPE,
                                WebpageFieldEnum.CONTEXT_BID,
                                WebpageFieldEnum.ID,
                                WebpageFieldEnum.NAME,
                                WebpageFieldEnum.STATE,
                                WebpageFieldEnum.STATUS_CLARIFICATION,
                                WebpageFieldEnum.STRATEGY_PRIORITY)
                        .getBean());
    }

    public GetResponse dynamicTextAdTargetsGetAllFieldNamesByCampaignId(Long cid, String login) {
        return defaultClientV5().invokeMethod(ServiceNames.DYNAMIC_TEXT_AD_TARGETS, login, Action.GET, (GetRequest)
                new GetRequestMap().withSelectionCriteria(
                        new WebpagesSelectionCriteriaMap()
                                .withCampaignIds(cid)
                                .withStates(AdTargetStateSelectionEnum.ON,
                                        AdTargetStateSelectionEnum.DELETED,
                                        AdTargetStateSelectionEnum.DELETED,
                                        AdTargetStateSelectionEnum.SUSPENDED)
                )
                        .withFieldNames(WebpageFieldEnum.CAMPAIGN_ID,
                                WebpageFieldEnum.AD_GROUP_ID,
                                WebpageFieldEnum.BID,
                                WebpageFieldEnum.CONDITIONS,
                                WebpageFieldEnum.CONDITION_TYPE,
                                WebpageFieldEnum.CONTEXT_BID,
                                WebpageFieldEnum.ID,
                                WebpageFieldEnum.NAME,
                                WebpageFieldEnum.STATE,
                                WebpageFieldEnum.STATUS_CLARIFICATION,
                                WebpageFieldEnum.STRATEGY_PRIORITY)
                        .getBean());
    }

    public GetResponse dynamicTextAdTargetsGetAllFieldNamesByAdGroupId(Long pid, String login) {
        return defaultClientV5().invokeMethod(ServiceNames.DYNAMIC_TEXT_AD_TARGETS, login, Action.GET, (GetRequest)
                new GetRequestMap().withSelectionCriteria(
                        new WebpagesSelectionCriteriaMap()
                                .withAdGroupIds(pid)
                                .withStates(AdTargetStateSelectionEnum.ON,
                                        AdTargetStateSelectionEnum.DELETED,
                                        AdTargetStateSelectionEnum.DELETED,
                                        AdTargetStateSelectionEnum.SUSPENDED)
                )
                        .withFieldNames(WebpageFieldEnum.CAMPAIGN_ID,
                                WebpageFieldEnum.AD_GROUP_ID,
                                WebpageFieldEnum.BID,
                                WebpageFieldEnum.CONDITIONS,
                                WebpageFieldEnum.CONDITION_TYPE,
                                WebpageFieldEnum.CONTEXT_BID,
                                WebpageFieldEnum.ID,
                                WebpageFieldEnum.NAME,
                                WebpageFieldEnum.STATE,
                                WebpageFieldEnum.STATUS_CLARIFICATION,
                                WebpageFieldEnum.STRATEGY_PRIORITY)
                        .getBean());
    }

    public GetResponse dynamicTextAdTargetsGet(GetRequestMap parameters) {
        return dynamicTextAdTargetsGet(parameters, null);
    }

    public List<WebpageGetItem> dynamicTextAdTargetsGet(WebpagesSelectionCriteriaMap selectionCriteria,
            WebpageFieldEnum... fieldNames)
    {
        return dynamicTextAdTargetsGet(new GetRequestMap().withSelectionCriteria(selectionCriteria)
                .withFieldNames(fieldNames), null).getWebpages();
    }

    public void expectErrorOnDynamicTextAdTargetsGet(GetRequestMap parameters, String login, Api5Error api5Error) {
        shouldGetErrorOn(ServiceNames.DYNAMIC_TEXT_AD_TARGETS, login, Action.GET, parameters, api5Error);
    }

    public void expectErrorOnDynamicTextAdTargetsGet(GetRequestMap parameters, Api5Error api5Error) {
        expectErrorOnDynamicTextAdTargetsGet(parameters, null, api5Error);
    }

    public void expectErrorOnDynamicTextAdTargetsGet(GetRequestMap parameters, JavaOrPerlApi5Error api5Error) {
        shouldGetErrorOn(ServiceNames.DYNAMIC_TEXT_AD_TARGETS, null, Action.GET, parameters, api5Error);
    }

    public void expectErrorOnDynamicTextAdTargetsGet(Object parameters, String login, Api5Error api5Error) {
        shouldGetJSONErrorOn(ServiceNames.DYNAMIC_TEXT_AD_TARGETS, login, Action.GET, parameters, api5Error);
    }

    public void expectErrorOnDynamicTextAdTargetsGet(Object parameters, Api5Error api5Error) {
        expectErrorOnDynamicTextAdTargetsGet(parameters, null, api5Error);
    }
    //endregion

    //region Add
    @Step("[DynamicTextAdTargets]: Add")
    public AddResponse dynamicTextAdTargetsAdd(AddRequestMap parameters, String login) {
        return defaultClientV5().invokeMethod(ServiceNames.DYNAMIC_TEXT_AD_TARGETS, login, Action.ADD,
                (AddRequest) parameters.getBean());
    }

    public AddResponse dynamicTextAdTargetsAdd(AddRequestMap parameters) {
        return dynamicTextAdTargetsAdd(parameters, null);
    }

    public Long addWebpage(WebpageAddItemMap webpageAddItemMap, String login) {
        AddResponse response = dynamicTextAdTargetsAdd(new AddRequestMap()
                .withWebpages(webpageAddItemMap), login);
        List<Long> ids = extractIdsFromAddResponse(response);
        assumeThat("был создан один объект Webpage", ids, hasSize(1));
        return ids.get(0);
    }

    public Long addDefaultWebpage(Long pid, String login) {
        AddResponse response = dynamicTextAdTargetsAdd(new AddRequestMap()
                .withWebpages(
                        new WebpageAddItemMap()
                                .withAdGroupId(pid)
                                .withName("Name")
                                .withConditions(
                                        new WebpageConditionMap().defaultWebpage()
                                )
                                .withBid(30000000l)
                ), login);
        assumeThat("был создан один объект Webpage", response.getAddResults(), hasSize(1));
        return response.getAddResults().get(0).getId();
    }

    public Long addDefaultWebpage(Long pid) {
        return addDefaultWebpage(pid, null);
    }

    public Long addWebpage(WebpageAddItemMap webpageAddItemMap) {
        return addWebpage(webpageAddItemMap, null);
    }

    public List<Long> addWebpages(String login, WebpageAddItemMap... webpageAddItemMap) {
        ExpectedResult[] expectedResults = new ExpectedResult[webpageAddItemMap.length];
        Arrays.fill(expectedResults, ExpectedResult.success());
        AddResponse response = shouldGetResultOnAdd(new AddRequestMap()
                .withWebpages(webpageAddItemMap), login, expectedResults);
        assumeThat(String.format("было создано %d объектов webpage", webpageAddItemMap.length),
                response.getAddResults(), hasSize(webpageAddItemMap.length));
        return response.getAddResults().stream().map(ActionResult::getId).collect(Collectors.toList());
    }

    public List<Long> addWebpages(WebpageAddItemMap... webpageAddItemMap) {
        return addWebpages(null, webpageAddItemMap);
    }

    public void expectErrorOnDynamicTextAdTargetsAdd(AddRequestMap parameters, String login, Api5Error api5Error) {
        shouldGetErrorOn(ServiceNames.DYNAMIC_TEXT_AD_TARGETS, login, Action.ADD, parameters, api5Error);
    }

    public void expectErrorOnDynamicTextAdTargetsAdd(AddRequestMap parameters, Api5Error api5Error) {
        expectErrorOnDynamicTextAdTargetsAdd(parameters, null, api5Error);
    }

    public void expectErrorOnDynamicTextAdTargetsAdd(Object parameters, String login, Api5Error api5Error) {
        shouldGetJSONErrorOn(ServiceNames.DYNAMIC_TEXT_AD_TARGETS, login, Action.ADD, parameters, api5Error);
    }

    public void expectErrorOnDynamicTextAdTargetsAdd(Object parameters, Api5Error api5Error) {
        expectErrorOnDynamicTextAdTargetsAdd(parameters, null, api5Error);
    }

    public AddResponse shouldGetResultOnAdd(AddRequestMap parameters, String login, ExpectedResult... expectedResults) {
        return (AddResponse) shouldGetResultOn(ServiceNames.DYNAMIC_TEXT_AD_TARGETS, login, Action.ADD, parameters,
                expectedResults);
    }

    public AddResponse shouldGetResultOnAdd(AddRequestMap parameters, String login, JavaOrPerlExpectedResult... expectedResults) {
        return (AddResponse) shouldGetResultOn(ServiceNames.DYNAMIC_TEXT_AD_TARGETS, login, Action.ADD, parameters,
                expectedResults);
    }

    public AddResponse shouldGetResultOnAdd(AddRequestMap parameters, ExpectedResult... expectedResults) {
        return shouldGetResultOnAdd(parameters, null, expectedResults);
    }

    public AddResponse shouldGetResultOnAdd(AddRequestMap parameters, JavaOrPerlExpectedResult... expectedResults) {
        return shouldGetResultOnAdd(parameters, null, expectedResults);
    }

    //endregion

    //region Suspend
    @Step("[DynamicTextAdTargets]: Suspend")
    public SuspendResponse dynamicTextAdTargetsSuspend(SuspendRequestMap parameters, String login) {
        return defaultClientV5().invokeMethod(ServiceNames.DYNAMIC_TEXT_AD_TARGETS, login, Action.SUSPEND,
                (SuspendRequest) parameters.getBean());
    }

    public SuspendResponse dynamicTextAdTargetsSuspend(SuspendRequestMap parameters) {
        return dynamicTextAdTargetsSuspend(parameters, null);
    }


    public SuspendResponse dynamicTextAdTargetsSuspend(Long id, String login) {
        return dynamicTextAdTargetsSuspend(
                new SuspendRequestMap()
                        .withSelectionCriteria(
                                new IdsCriteriaMap().
                                        withIds(id)),
                login);
    }


    public SuspendResponse dynamicTextAdTargetsSuspend(Long id) {
        return dynamicTextAdTargetsSuspend(
                new SuspendRequestMap()
                        .withSelectionCriteria(
                                new IdsCriteriaMap().
                                        withIds(id)),
                null);
    }

    public void expectErrorOnDynamicTextAdTargetsSuspend(SuspendRequestMap parameters, String login,
            Api5Error api5Error)
    {
        shouldGetErrorOn(ServiceNames.DYNAMIC_TEXT_AD_TARGETS, login, Action.SUSPEND, parameters, api5Error);
    }

    public void expectErrorOnDynamicTextAdTargetsSuspend(SuspendRequestMap parameters, Api5Error api5Error) {
        expectErrorOnDynamicTextAdTargetsSuspend(parameters, null, api5Error);
    }

    public void expectErrorOnDynamicTextAdTargetsSuspend(SuspendRequestMap parameters, JavaOrPerlApi5Error api5Error) {
        shouldGetErrorOn(ServiceNames.DYNAMIC_TEXT_AD_TARGETS, null, Action.SUSPEND, parameters, api5Error);
    }

    public void expectErrorOnDynamicTextAdTargetsSuspend(Object parameters, String login, Api5Error api5Error) {
        shouldGetJSONErrorOn(ServiceNames.DYNAMIC_TEXT_AD_TARGETS, login, Action.SUSPEND, parameters, api5Error);
    }

    public void expectErrorOnDynamicTextAdTargetsSuspend(Object parameters, Api5Error api5Error) {
        expectErrorOnDynamicTextAdTargetsSuspend(parameters, null, api5Error);
    }

    public SuspendResponse shouldGetResultOnSuspend(IdsCriteriaMap selectionCriteria,
            ExpectedResult... expectedResults)
    {
        return shouldGetResultOnSuspend(new SuspendRequestMap().withSelectionCriteria(selectionCriteria), null,
                expectedResults);
    }

    public SuspendResponse shouldGetResultOnSuspend(SuspendRequestMap parameters, ExpectedResult... expectedResults) {
        return shouldGetResultOnSuspend(parameters, null, expectedResults);
    }

    public SuspendResponse shouldGetResultOnSuspend(SuspendRequestMap parameters,
            JavaOrPerlExpectedResult... expectedResults)
    {
        return (SuspendResponse) shouldGetResultOn(ServiceNames.DYNAMIC_TEXT_AD_TARGETS, null, Action.SUSPEND,
                parameters, expectedResults);
    }

    private SuspendResponse shouldGetResultOnSuspend(SuspendRequestMap parameters, String login,
            ExpectedResult[] expectedResults)
    {
        return (SuspendResponse) shouldGetResultOn(ServiceNames.DYNAMIC_TEXT_AD_TARGETS, login, Action.SUSPEND,
                parameters, expectedResults);
    }

    //endregion

    //region Resume
    @Step("[DynamicTextAdTargets]: Resume")
    public ResumeResponse dynamicTextAdTargetsResume(ResumeRequestMap parameters, String login) {
        return defaultClientV5().invokeMethod(ServiceNames.DYNAMIC_TEXT_AD_TARGETS, login, Action.RESUME,
                (ResumeRequest) parameters.getBean());
    }

    public ResumeResponse dynamicTextAdTargetsResume(ResumeRequestMap parameters) {
        return dynamicTextAdTargetsResume(parameters, null);
    }

    public ResumeResponse dynamicTextAdTargetsResume(Long id, String login) {
        return dynamicTextAdTargetsResume(
                new ResumeRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds(id)),
                login);
    }

    public ResumeResponse dynamicTextAdTargetsResume(Long id) {
        return dynamicTextAdTargetsResume(
                new ResumeRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds(id)),
                null);
    }

    public void expectErrorOnDynamicTextAdTargetsResume(ResumeRequestMap parameters, String login,
            Api5Error api5Error)
    {
        shouldGetErrorOn(ServiceNames.DYNAMIC_TEXT_AD_TARGETS, login, Action.RESUME, parameters, api5Error);
    }

    public void expectErrorOnDynamicTextAdTargetsResume(ResumeRequestMap parameters, Api5Error api5Error) {
        expectErrorOnDynamicTextAdTargetsResume(parameters, null, api5Error);
    }

    public void expectErrorOnDynamicTextAdTargetsResume(ResumeRequestMap parameters, JavaOrPerlApi5Error api5Error) {
        shouldGetErrorOn(ServiceNames.DYNAMIC_TEXT_AD_TARGETS, null, Action.RESUME, parameters, api5Error);
    }

    public void expectErrorOnDynamicTextAdTargetsResume(Object parameters, String login, Api5Error api5Error) {
        shouldGetJSONErrorOn(ServiceNames.DYNAMIC_TEXT_AD_TARGETS, login, Action.RESUME, parameters, api5Error);
    }

    public void expectErrorOnDynamicTextAdTargetsResume(Object parameters, Api5Error api5Error) {
        expectErrorOnDynamicTextAdTargetsResume(parameters, null, api5Error);
    }

    public ResumeResponse shouldGetResultOnResume(ResumeRequestMap parameters, ExpectedResult... expectedResults) {
        return shouldGetResultOnResume(parameters, null, expectedResults);
    }

    public ResumeResponse shouldGetResultOnResume(ResumeRequestMap parameters,
            JavaOrPerlExpectedResult... expectedResults)
    {
        return (ResumeResponse) shouldGetResultOn(ServiceNames.DYNAMIC_TEXT_AD_TARGETS, null, Action.RESUME,
                parameters, expectedResults);
    }

    private ResumeResponse shouldGetResultOnResume(ResumeRequestMap parameters, String login,
            ExpectedResult... expectedResults)
    {
        return (ResumeResponse) shouldGetResultOn(ServiceNames.DYNAMIC_TEXT_AD_TARGETS, login, Action.RESUME,
                parameters, expectedResults);

    }
    //endregion

    //region Delete
    @Step("[DynamicTextAdTargets]: Delete")
    public DeleteResponse dynamicTextAdTargetsDelete(DeleteRequestMap parameters, String login) {
        return defaultClientV5().invokeMethod(ServiceNames.DYNAMIC_TEXT_AD_TARGETS, login, Action.DELETE,
                (DeleteRequest) parameters.getBean());
    }

    public DeleteResponse dynamicTextAdTargetsDelete(DeleteRequestMap parameters) {
        return dynamicTextAdTargetsDelete(parameters, null);
    }

    public DeleteResponse dynamicTextAdTargetsDelete(Long id, String login) {
        return dynamicTextAdTargetsDelete(
                new DeleteRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds(id)), login);
    }

    public DeleteResponse dynamicTextAdTargetsDelete(Long id) {
        return dynamicTextAdTargetsDelete(
                new DeleteRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds(id)), null);
    }

    public void expectErrorOnDynamicTextAdTargetsDelete(DeleteRequestMap parameters, String login,
            Api5Error api5Error)
    {
        shouldGetErrorOn(ServiceNames.DYNAMIC_TEXT_AD_TARGETS, login, Action.DELETE, parameters, api5Error);
    }

    public void expectErrorOnDynamicTextAdTargetsDelete(DeleteRequestMap parameters, Api5Error api5Error) {
        expectErrorOnDynamicTextAdTargetsDelete(parameters, null, api5Error);
    }

    public void expectErrorOnDynamicTextAdTargetsDelete(DeleteRequestMap parameters, JavaOrPerlApi5Error api5Error) {
        shouldGetErrorOn(ServiceNames.DYNAMIC_TEXT_AD_TARGETS, null, Action.DELETE, parameters, api5Error);
    }

    public void expectErrorOnDynamicTextAdTargetsDelete(Object parameters, String login, Api5Error api5Error) {
        shouldGetJSONErrorOn(ServiceNames.DYNAMIC_TEXT_AD_TARGETS, login, Action.DELETE, parameters, api5Error);
    }

    public void expectErrorOnDynamicTextAdTargetsDelete(Object parameters, Api5Error api5Error) {
        expectErrorOnDynamicTextAdTargetsDelete(parameters, null, api5Error);
    }

    public DeleteResponse shouldGetResultOnDelete(IdsCriteriaMap selectionCriteria, ExpectedResult... expectedResults) {
        return shouldGetResultOnDelete(new DeleteRequestMap().withSelectionCriteria(selectionCriteria),
                null, expectedResults);
    }

    public DeleteResponse shouldGetResultOnDelete(DeleteRequestMap parameters, ExpectedResult... expectedResults) {
        return shouldGetResultOnDelete(parameters, null, expectedResults);
    }

    public DeleteResponse shouldGetResultOnDelete(DeleteRequestMap parameters,
            JavaOrPerlExpectedResult... expectedResults)
    {
        return (DeleteResponse) shouldGetResultOn(ServiceNames.DYNAMIC_TEXT_AD_TARGETS,
                null, Action.DELETE, parameters, expectedResults);
    }

    private DeleteResponse shouldGetResultOnDelete(DeleteRequestMap parameters, String login,
            ExpectedResult[] expectedResults)
    {
        return (DeleteResponse) shouldGetResultOn(ServiceNames.DYNAMIC_TEXT_AD_TARGETS
                , login, Action.DELETE, parameters, expectedResults);

    }
    //endregion

    //region SetBids
    @Step("[DynamicTextAdTargets]: SetBids")
    public SetBidsResponse dynamicTextAdTargetsSetBids(SetBidsRequestMap parameters, String login) {
        return defaultClientV5().invokeMethod(
                ServiceNames.DYNAMIC_TEXT_AD_TARGETS, login, Action.SET_BIDS, (SetBidsRequest) parameters.getBean());
    }

    public SetBidsResponse dynamicTextAdTargetsSetBids(SetBidsRequestMap parameters) {
        return dynamicTextAdTargetsSetBids(parameters, null);
    }

    public void expectErrorOnDynamicTextAdTargetsSetBids(SetBidsRequestMap parameters, String login, Api5Error error) {
        shouldGetErrorOn(ServiceNames.DYNAMIC_TEXT_AD_TARGETS, login, Action.SET_BIDS, parameters, error);
    }

    public void expectErrorOnDynamicTextAdTargetsSetBids(SetBidsRequestMap parameters, Api5Error error) {
        expectErrorOnDynamicTextAdTargetsSetBids(parameters, null, error);
    }

    public void expectErrorOnDynamicTextAdTargetsSetBids(Object parameters, String login, Api5Error error) {
        shouldGetJSONErrorOn(ServiceNames.DYNAMIC_TEXT_AD_TARGETS, login, Action.SET_BIDS, parameters, error);
    }

    public void expectErrorOnDynamicTextAdTargetsSetBids(Object parameters, Api5Error error) {
        expectErrorOnDynamicTextAdTargetsSetBids(parameters, null, error);
    }

    public void shouldGetResultOnSetBids(SetBidsRequestMap parameters, SetBidsExpectedResult... expectedResults) {
        shouldGetResultOnSetBids(parameters, null, expectedResults);
    }

    public void shouldGetResultOnSetBids(SetBidsRequestMap parameters,
            JavaOrPerlSetBidsExpectedResult... expectedResults)
    {
        shouldGetSetBidsResultOn(null, ServiceNames.DYNAMIC_TEXT_AD_TARGETS, Action.SET_BIDS, parameters,
                expectedResults);
    }

    public void shouldGetResultOnSetBids(SetBidsRequestMap parameters,
            String login,
            SetBidsExpectedResult[] expectedResults)
    {
        shouldGetSetBidsResultOn(login, ServiceNames.DYNAMIC_TEXT_AD_TARGETS, Action.SET_BIDS, parameters,
                expectedResults);
    }
    //endregion

    private List<Long> extractIdsFromAddResponse(AddResponse addResponse) {
        return filter(notNullValue(), extract(addResponse.getAddResults(), on(ActionResult.class).getId()));
    }
}
