package ru.yandex.autotests.directapi.steps.forecast;

public class ApproximateCompareHelper {
    public static boolean areApproximatelyEqual(Object actual, Object expected, int percents) {
        if (actual == null) {
            return expected == null;
        }
        if (expected == null) {
            return false;
        }
        Number actualNumber = (Number) actual;
        Number expectedNumber = (Number) expected;
        if (actualNumber.doubleValue() == expectedNumber.doubleValue()) {
            return true;
        }
        double max = Math.max(Math.abs(actualNumber.doubleValue()), Math.abs(expectedNumber.doubleValue()));
        if (max == 0) {
            max = Double.MIN_NORMAL;
        }
        double diff = Math.abs(actualNumber.doubleValue() - expectedNumber.doubleValue());
        return 100 * diff / max <= percents;
    }

    public static boolean areIntsApproximatelyEqualWithFlowPercents(int actual, int expected, int percents) {
        if (actual == expected) {
            return true;
        }
        double max = Math.max(Math.abs(actual), Math.abs(expected));
        if (max <= 5) {
            percents *= 3;
        } else if (max <= 25) {
            percents *= 2;
        } else if (max <= 100) {
            percents = (3 * percents) >> 1;
        }
        if (max == 0) {
            max = Double.MIN_NORMAL;
        }
        double diff = Math.abs(actual - expected);
        return 100 * diff / max <= percents;
    }
}
