package ru.yandex.autotests.directapi.steps.getchanges;

import com.yandex.direct.api.v5.changes.CheckCampaignsRequest;
import com.yandex.direct.api.v5.changes.CheckCampaignsResponse;
import com.yandex.direct.api.v5.changes.CheckDictionariesRequest;
import com.yandex.direct.api.v5.changes.CheckDictionariesResponse;
import com.yandex.direct.api.v5.changes.CheckRequest;
import com.yandex.direct.api.v5.changes.CheckResponse;
import org.apache.commons.beanutils.BeanMap;

import ru.yandex.autotests.direct.utils.CommonUtils;
import ru.yandex.autotests.directapi.apiclient.RequestHeader;
import ru.yandex.autotests.directapi.apiclient.config.ConnectionConfig;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.version5.ServiceNames;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.changes.CheckCampaignsRequestMap;
import ru.yandex.autotests.directapi.model.api5.changes.CheckDictionariesRequestMap;
import ru.yandex.autotests.directapi.model.api5.changes.CheckRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlApi5Error;
import ru.yandex.autotests.directapi.steps.BaseApiSteps;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Step;

/**
 * Created by ginger on 25.03.15.
 */
public class ChangesSteps extends BaseApiSteps {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    private static ChangesSteps _instance;

    private ChangesSteps(ConnectionConfig connectionConfig, RequestHeader requestHeader) {
        super(connectionConfig, requestHeader);
    }

    public static ChangesSteps getInstance(ConnectionConfig connectionConfig, RequestHeader requestHeader) {
        if (_instance == null) {
            _instance = new ChangesSteps(connectionConfig, requestHeader);
        } else {
            _instance.setConnectionConfig(connectionConfig);
            _instance.setRequestHeader(requestHeader);
        }
        return _instance;
    }

    //region Check

    @Step("[Changes]: Check")
    public CheckResponse changesCheck(CheckRequestMap parameters, String login) {
        return defaultClientV5().invokeMethod(
                ServiceNames.CHANGES, login, Action.CHECK, (CheckRequest) parameters.getBean()
        );
    }

    @Step("[Changes]: Check")
    public CheckResponse changesCheck(CheckRequestMap parameters) {
        return changesCheck(parameters, null);
    }

    @Step("[Changes]: Check")
    public CheckResponse changesJsonCheck(Object parameters, String login) {
        return jsonClientV5().invokeMethod(
                ServiceNames.CHANGES, login, Action.CHECK, parameters
        );
    }

    public void shouldGetErrorOnCheck(CheckRequestMap parameters, Api5Error api5Error) {
        shouldGetErrorOn(ServiceNames.CHANGES, null, Action.CHECK, parameters, api5Error);
    }

    public void shouldGetErrorOnCheck(CheckRequestMap parameters, JavaOrPerlApi5Error api5Error) {
        shouldGetErrorOn(ServiceNames.CHANGES, null, Action.CHECK, parameters, api5Error);
    }

    public void shouldGetJSONErrorOnCheck(Object parameters, String login, Api5Error api5Error) {
        shouldGetJSONErrorOn(ServiceNames.CHANGES, login, Action.CHECK, parameters, api5Error);
    }

    public void shouldGetJSONErrorOnCheck(Object parameters, String login, JavaOrPerlApi5Error api5Error) {
        shouldGetJSONErrorOn(ServiceNames.CHANGES, login, Action.CHECK, parameters, api5Error);
    }

    // end region

    //  region CheckDictionaries

    @Step("[Changes]: CheckDictionaries")
    public String getTimestamp() {
        CommonUtils.waitFor(1000);
        String timestamp = (String) new BeanMap(
                defaultClientV5().invokeMethod(ServiceNames.CHANGES, null, Action.CHECK_DICTIONARIES,
                        new CheckDictionariesRequest()))
                .get(CheckRequestMap.TIMESTAMP);
        CommonUtils.waitFor(1000);
        return timestamp;
    }

    @Step("[Changes]: CheckDictionaries")
    public String getTimestamp(String login) {
        CommonUtils.waitFor(1000);
        String timestamp = (String) new BeanMap(
                defaultClientV5().invokeMethod(ServiceNames.CHANGES, login, Action.CHECK_DICTIONARIES,
                        new CheckDictionariesRequest()))
                .get(CheckRequestMap.TIMESTAMP);
        CommonUtils.waitFor(1000);
        return timestamp;
    }

    @Step("[Changes]: CheckDictionaries")
    public CheckDictionariesResponse changesCheckDictionaries(CheckDictionariesRequestMap parameters) {
        return defaultClientV5().invokeMethod(
                ServiceNames.CHANGES, null, Action.CHECK_DICTIONARIES, (CheckDictionariesRequest) parameters.getBean()
        );
    }

    @Step("[Changes]: CheckDictionaries")
    public CheckDictionariesResponse changesCheckDictionaries(CheckDictionariesRequestMap parameters, String login) {
        return defaultClientV5().invokeMethod(
                ServiceNames.CHANGES, login, Action.CHECK_DICTIONARIES, (CheckDictionariesRequest) parameters.getBean()
        );
    }

    public CheckDictionariesResponse shouldGetResultOnCheckDictionaries(
            CheckDictionariesRequestMap parameters, String login, ExpectedResult... expectedResults)
    {
        return (CheckDictionariesResponse) shouldGetResultOn(
                ServiceNames.CHANGES, login, Action.CHECK_DICTIONARIES, parameters, expectedResults);
    }


    public void shouldGetErrorOnCheckDictionaries(CheckDictionariesRequestMap parameters, Api5Error api5Error) {
        shouldGetErrorOn(ServiceNames.CHANGES, null, Action.CHECK_DICTIONARIES, parameters, api5Error);
    }

    public void shouldGetErrorOnCheckDictionaries(CheckDictionariesRequestMap parameters, JavaOrPerlApi5Error api5Error) {
        shouldGetErrorOn(ServiceNames.CHANGES, null, Action.CHECK_DICTIONARIES, parameters, api5Error);
    }

    public void shouldGetJSONErrorOnCheckDictionaries(Object parameters, String login, Api5Error api5Error) {
        shouldGetJSONErrorOn(ServiceNames.CHANGES, login, Action.CHECK_DICTIONARIES, parameters, api5Error);
    }

    // end region

    //  region CheckCampaigns

    @Step("[Changes]: CheckCampaigns")
    public CheckCampaignsResponse changesCheckCampaigns(CheckCampaignsRequestMap parameters) {
        return defaultClientV5().invokeMethod(
                ServiceNames.CHANGES, null, Action.CHECK_CAMPAIGNS, (CheckCampaignsRequest) parameters.getBean()
        );
    }

    @Step("[Changes]: CheckCampaigns")
    public CheckCampaignsResponse changesCheckCampaigns(CheckCampaignsRequestMap parameters, String login) {
        return defaultClientV5().invokeMethod(
                ServiceNames.CHANGES, login, Action.CHECK_CAMPAIGNS, (CheckCampaignsRequest) parameters.getBean()
        );
    }

    public void shouldGetErrorOnCheckCampaigns(CheckCampaignsRequestMap parameters, Api5Error api5Error) {
        shouldGetErrorOn(ServiceNames.CHANGES, null, Action.CHECK_CAMPAIGNS, parameters, api5Error);
    }

    public void shouldGetErrorOnCheckCampaigns(CheckCampaignsRequestMap parameters, JavaOrPerlApi5Error api5Error) {
        shouldGetErrorOn(ServiceNames.CHANGES, null, Action.CHECK_CAMPAIGNS, parameters, api5Error);
    }

    public void shouldGetJSONErrorOnCheckCampaigns(Object parameters, String login, Api5Error api5Error) {
        shouldGetJSONErrorOn(ServiceNames.CHANGES, login, Action.CHECK_CAMPAIGNS, parameters, api5Error);
    }

    public void shouldGetJSONErrorOnCheckCampaigns(Object parameters, String login, JavaOrPerlApi5Error api5Error) {
        shouldGetJSONErrorOn(ServiceNames.CHANGES, login, Action.CHECK_CAMPAIGNS, parameters, api5Error);
    }

    // end region

    /**
     * Включаем/отключаем использование таблицы camp_aggregated_lastchange при определении
     * последних изменений по кампании
     */
    public ChangesSteps withUseCampAggregatedLastChange(boolean useCampAggregatedLastChange) {
        requestHeader.setUseCampAggregatedLastChange(useCampAggregatedLastChange);
        return this;
    }

    /**
     * Включаем/отключаем использование таблицы camp_aggregated_lastchange при определении
     * последних изменений по кампании
     */
    public void setUseCampAggregatedLastChange(boolean useCampAggregatedLastChange) {
        requestHeader.setUseCampAggregatedLastChange(useCampAggregatedLastChange);
    }
}

