package ru.yandex.autotests.directapi.steps.getchanges;

import java.util.concurrent.Callable;

import org.apache.commons.beanutils.BeanMap;

import ru.yandex.autotests.direct.utils.CommonUtils;
import ru.yandex.autotests.directapi.apiclient.RequestHeader;
import ru.yandex.autotests.directapi.apiclient.config.ConnectionConfig;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.exceptions.DirectAPIException;
import ru.yandex.autotests.directapi.matchers.getchanges.GetChangesLongDataMatcher;
import ru.yandex.autotests.directapi.model.getchanges.GetChangesRequestMap;
import ru.yandex.autotests.directapi.steps.BaseApiSteps;
import ru.yandex.qatools.allure.annotations.Step;

/**
 * Created with IntelliJ IDEA.
 * User: pavryabov
 * Date: 23.09.13
 * Time: 13:21
 * To change this template use File | Settings | File Templates.
 */
public class GetChangesSteps extends BaseApiSteps {

    private static GetChangesSteps _instance;

    private GetChangesSteps(ConnectionConfig connectionConfig, RequestHeader requestHeader) {
        super(connectionConfig, requestHeader);
    }

    public static GetChangesSteps getInstance(ConnectionConfig connectionConfig, RequestHeader requestHeader) {
        if (_instance == null) {
            _instance = new GetChangesSteps(connectionConfig, requestHeader);
        } else {
            _instance.setConnectionConfig(connectionConfig);
            _instance.setRequestHeader(requestHeader);
        }
        return _instance;

    }

    public String getTimestamp() {
        CommonUtils.waitFor(1000);
        String timestamp = null;
        try {
            timestamp = (String) new BeanMap(
                    getChanges(new GetChangesRequestMap(jsonClient().getPackageName())))
                    .get(GetChangesRequestMap.TIMESTAMP);
        } catch (DirectAPIException directException) {
            throw new DirectAPIException("Запрос timestamp с сервера. ", directException);
        }
        CommonUtils.waitFor(1000);
        return timestamp;
    }

    @Step("[GetChanges]")
    public <T> T getChanges(GetChangesRequestMap getChangesRequest) {
        try {
            return (T) defaultClient().invokeMethod(Method.GET_CHANGES, getChangesRequest.getBean());
        } catch (AxisError axisError) {
            throw new DirectAPIException("Ошибка запроса изменений. ", axisError);
        }
    }

    public <T> T getChangesCampaign(Integer campaignID, String timestamp) {
        return (T) getChanges(new GetChangesRequestMap(jsonClient().getPackageName())
                .withCampaignIDS(campaignID).withTimestamp(timestamp));
    }

    public void shouldGetErrorOnGetChanges(AxisError axisError, GetChangesRequestMap getChangesRequest) {
        shouldGetErrorOn(Method.GET_CHANGES, getChangesRequest, axisError);
    }

    public <GetChangesLongData> Callable<Boolean> isUpdated(final GetChangesLongData updatedBanners,
            final long... bannerIDs)
    {
        return new Callable<Boolean>() {
            public Boolean call() {
                return GetChangesLongDataMatcher.updatedContains(bannerIDs).matches(updatedBanners);
            }
        };
    }

}
