package ru.yandex.autotests.directapi.steps.geteventslog;

import ru.yandex.autotests.directapi.apiclient.RequestHeader;
import ru.yandex.autotests.directapi.apiclient.config.ConnectionConfig;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.model.geteventslog.GetEventsLogRequestMap;
import ru.yandex.autotests.directapi.steps.BaseApiSteps;

/**
 * Created with IntelliJ IDEA.
 * User: pavryabov
 * Date: 10.10.13
 * Time: 16:52
 * To change this template use File | Settings | File Templates.
 */
public class GetEventsLogSteps extends BaseApiSteps {

    private static GetEventsLogSteps _instance;

    private GetEventsLogSteps(ConnectionConfig connectionConfig, RequestHeader requestHeader) {
        super(connectionConfig, requestHeader);
    }

    public static GetEventsLogSteps getInstance(ConnectionConfig connectionConfig, RequestHeader requestHeader) {
        ConnectionConfig modifiedConfig = connectionConfig.clone();
        if (_instance == null) {
            _instance = new GetEventsLogSteps(modifiedConfig, requestHeader);
        } else {
            _instance.setConnectionConfig(modifiedConfig);
            _instance.setRequestHeader(requestHeader);
        }
        return _instance;

    }

    public <EventsLogItem> EventsLogItem[] getEventsLog(GetEventsLogRequestMap getEventsLogRequest) {
        return jsonClient().invokeMethod(Method.GET_EVENTS_LOG, getEventsLogRequest.getBean());
    }

    public void shouldGetErrorOnGetEventsLog(String assertMessage, GetEventsLogRequestMap getEventsLogRequest,
            AxisError error)
    {
        shouldGetErrorOn(assertMessage, Method.GET_EVENTS_LOG, getEventsLogRequest, error);
    }
}