package ru.yandex.autotests.directapi.steps.geteventslog;

import java.util.Set;
import java.util.concurrent.Callable;

import ru.yandex.autotests.directapi.apiclient.RequestHeader;
import ru.yandex.autotests.directapi.apiclient.config.ConnectionConfig;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.matchers.subscription.SubscriptionMatcher;
import ru.yandex.autotests.directapi.model.subscription.SubscriptionMap;
import ru.yandex.autotests.directapi.model.subscription.SubscriptionShortMap;
import ru.yandex.autotests.directapi.rules.Bin;
import ru.yandex.autotests.directapi.rules.Binable;
import ru.yandex.autotests.directapi.steps.BaseApiSteps;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Step;

/**
 * @author xy6er
 */
public class SubscriptionSteps extends BaseApiSteps implements Binable<SubscriptionShortMap> {
    private LogSteps log = LogSteps.getLogger(this.getClass());
    private static SubscriptionSteps _instance;

    public Bin<SubscriptionShortMap> bin = new Bin<>(this);

    private SubscriptionSteps(ConnectionConfig connectionConfig, RequestHeader requestHeader) {
        super(connectionConfig, requestHeader);
    }

    public static SubscriptionSteps getInstance(ConnectionConfig connectionConfig, RequestHeader requestHeader) {
        if (_instance == null) {
            _instance = new SubscriptionSteps(connectionConfig, requestHeader);
        } else {
            _instance.setConnectionConfig(connectionConfig);
            _instance.setRequestHeader(requestHeader);
        }
        return _instance;
    }

    public Callable clearBin(final Set<SubscriptionShortMap> binData) {
        return new Callable() {
            public Object call() throws Exception {
                for (SubscriptionShortMap subscriptionShort : binData.toArray(new SubscriptionShortMap[0])) {
                    try {
                        deleteSubscription(subscriptionShort);
                    } catch (Exception e) {
                        log.info("TRASHER: ошибка удаления подписки");
                    }
                }
                return null;
            }
        };
    }

    @Step("[SaveSubscription]")
    public int saveSubscription(SubscriptionMap subscriptionMap) {
        int result = defaultClient().invokeMethod(Method.SAVE_SUBSCRIPTION, subscriptionMap.getBean());
        bin.throwToBin(new SubscriptionShortMap(subscriptionMap));
        return result;
    }

    @Step("[GetSubscription]")
    @SuppressWarnings("unchecked")
    public <Subscription> Subscription getSubscription(SubscriptionShortMap subscriptionShortMap) {
        if (!properties.isDirectAPIStageTS()) {
            //На ТС скрипт запущен по умолчанию и работает всегда
            getDarkSideSteps().getRunScriptSteps().runPpcPushNotificationsQueue(
                    getDarkSideSteps().getClientFakeSteps().getUserShard(requestHeader.getLogin()));
        }
        return (Subscription) defaultClient().invokeMethod(Method.GET_SUBSCRIPTION, subscriptionShortMap.getBean());
    }

    @Step("[DeleteSubscription]")
    public int deleteSubscription(SubscriptionShortMap subscriptionShortMap) {
        int result = defaultClient().invokeMethod(Method.DELETE_SUBSCRIPTION, subscriptionShortMap.getBean());
        bin.removeFromBin(subscriptionShortMap);
        return result;
    }

    @Step("Ожидание изменения параметров подписки")
    public Callable<Boolean> subscriptionIs(final SubscriptionMap subscriptionMap) {
        final SubscriptionShortMap subscriptionShortMap = new SubscriptionShortMap(subscriptionMap);
        return new Callable<Boolean>() {
            public Boolean call() throws Exception {
                try {
                    Object gotSubscription = getSubscription(subscriptionShortMap);
                    return SubscriptionMatcher.equalTo(subscriptionMap.getBean()).matches(gotSubscription);
                } catch (AxisError axisError) {
                    return false;
                }
            }
        };
    }

    public boolean isSubscriptionExists(SubscriptionShortMap subscriptionShortMap) {
        try {
            getSubscription(subscriptionShortMap);
            return true;
        } catch (AxisError axisError) {
            return (axisError.getErrorCode() != 38);
        }
    }

    public Callable<Boolean> subscriptionDeleted(final SubscriptionShortMap subscriptionShortMap) {
        return new Callable<Boolean>() {
            public Boolean call() throws Exception {
                return !isSubscriptionExists(subscriptionShortMap);
            }
        };
    }

}
