package ru.yandex.autotests.directapi.steps.leads;

import com.yandex.direct.api.v5.leads.GetResponse;

import ru.yandex.autotests.directapi.apiclient.RequestHeader;
import ru.yandex.autotests.directapi.apiclient.config.ConnectionConfig;
import ru.yandex.autotests.directapi.apiclient.version5.ServiceNames;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.leads.GetRequestMap;
import ru.yandex.autotests.directapi.steps.BaseApiSteps;
import ru.yandex.qatools.allure.annotations.Step;

public class LeadsSteps extends BaseApiSteps {
    private static LeadsSteps _instance;


    private LeadsSteps(ConnectionConfig config, RequestHeader header) {
        super(config, header);
    }

    public static LeadsSteps getInstance(ConnectionConfig config, RequestHeader header) {
        if (_instance == null) {
            _instance = new LeadsSteps(config, header);
        } else {
            _instance.setConnectionConfig(config);
            _instance.setRequestHeader(header);
        }
        return _instance;
    }

    @Step("[Leads]: Get")
    public GetResponse leadsGetRawResponse(String login, GetRequestMap request) {
        return ((GetResponse) defaultClientV5().invokeMethod(
                ServiceNames.LEADS, login, Action.GET, request.getBean()));
    }
}
