package ru.yandex.autotests.directapi.steps.prices;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Nullable;

import com.yandex.direct.api.v5.bidmodifiers.AddResponse;
import com.yandex.direct.api.v5.bidmodifiers.BidModifierGetItem;
import com.yandex.direct.api.v5.bidmodifiers.BidModifierToggleTypeEnum;
import com.yandex.direct.api.v5.bidmodifiers.DeleteResponse;
import com.yandex.direct.api.v5.bidmodifiers.GetResponse;
import com.yandex.direct.api.v5.bidmodifiers.SetResponse;
import com.yandex.direct.api.v5.bidmodifiers.ToggleResponse;
import com.yandex.direct.api.v5.bidmodifiers.ToggleResult;
import com.yandex.direct.api.v5.general.ActionResult;
import com.yandex.direct.api.v5.general.MultiIdsActionResult;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.apache.commons.beanutils.BeanMap;
import org.hamcrest.Matcher;

import ru.yandex.autotests.direct.utils.matchers.BeanEquals;
import ru.yandex.autotests.directapi.apiclient.RequestHeader;
import ru.yandex.autotests.directapi.apiclient.config.ConnectionConfig;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.version5.MethodInvocationResult;
import ru.yandex.autotests.directapi.apiclient.version5.ServiceNames;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierAddMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierSetMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierToggleMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifiersSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.DeleteRequestMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.DemographicsAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.DesktopAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.JavaOrPerlToggleExpectedResult;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.MobileAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.RegionalAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.RetargetingAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.SerpLayoutAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.SetRequestMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.SmartTvAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.ToggleExpectedResult;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.ToggleRequestMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.VideoAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlApi5Error;
import ru.yandex.autotests.directapi.model.api5.general.MultiIdsExpectedResult;
import ru.yandex.autotests.directapi.steps.BaseApiSteps;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ch.lambdaj.Lambda.extract;
import static ch.lambdaj.Lambda.having;
import static ch.lambdaj.Lambda.on;
import static ch.lambdaj.Lambda.select;
import static java.util.stream.Collectors.toList;
import static org.hamcrest.Matchers.contains;
import static org.hamcrest.Matchers.either;
import static org.hamcrest.Matchers.emptyIterable;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.not;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by chicos on 13.07.15.
 */
public class BidModifiersSteps extends BaseApiSteps {
    private static final int MAX_GET_CAMPAIGNS = 10;
    private static final int MAX_GET_OFFSET = 120_000;
    private static final Long MAX_GET_LIMIT = 10_000L;
    private static final int MAX_ONETIME_DELETE_SIZE = 10_000;

    private LogSteps log = LogSteps.getLogger(this.getClass());

    private static BidModifiersSteps _instance;

    private BidModifiersSteps(ConnectionConfig connectionConfig, RequestHeader requestHeader) {
        super(connectionConfig, requestHeader);
    }

    public static BidModifiersSteps getInstance(ConnectionConfig connectionConfig, RequestHeader requestHeader) {
        if (_instance == null) {
            _instance = new BidModifiersSteps(connectionConfig, requestHeader);
        } else {
            _instance.setConnectionConfig(connectionConfig);
            _instance.setRequestHeader(requestHeader);
        }
        return _instance;
    }

    @Step("[BidModifiers]: Add")
    public List<Long> bidModifiersAdd(String login, AddRequestMap request) {
        List<MultiIdsActionResult> results = ((AddResponse) defaultClientV5()
                .invokeMethod(ServiceNames.BID_MODIFIERS, login, Action.ADD, request.getBean())).getAddResults();
        lookForResponseExceptionsMultiIds(results);
        return getIDsFromMultiIdsActionResults(results);
    }

    public List<Long> bidModifiersAdd(String login, BidModifierAddMap... bidModifiers) {
        AddRequestMap request = new AddRequestMap().withBidModifiers(bidModifiers);
        return bidModifiersAdd(login, request);
    }

    public List<Long> bidModifiersAdd(BidModifierAddMap... bidModifiers) {
        return bidModifiersAdd(null, bidModifiers);
    }

    //default methods for MobileAdjustment
    public Long addDefaultBidModifierMobile(String login, Integer campaignId, Long adGroupId) {
        List<Long> bidModifierIds = bidModifiersAdd(login, new BidModifierAddMap()
                .withMobileAdjustment(new MobileAdjustmentMap()
                        .defaultMobileAdjustment())
                .withCampaignId((campaignId != null) ? (campaignId.longValue()) : (null))
                .withAdGroupId(adGroupId));
        assumeThat("добавлена мобильная корректировка ставок", bidModifierIds, hasSize(1));
        return bidModifierIds.get(0);
    }

    public Long addBidModifierMobileToGroup(String login, Long adGroupId) {
        return addDefaultBidModifierMobile(login, null, adGroupId);
    }

    public Long addBidModifierMobileToGroup(Long adGroupId) {
        return addDefaultBidModifierMobile(null, null, adGroupId);
    }

    public Long addBidModifierMobileToCampaign(String login, Integer campaignId) {
        return addDefaultBidModifierMobile(login, campaignId, null);
    }

    public Long addBidModifierMobileToCampaign(Integer campaignId) {
        return addDefaultBidModifierMobile(null, campaignId, null);
    }

    public Long addBidModifierMobileToCampaign(Long campaignId) {
        return addBidModifierMobileToCampaign(campaignId.intValue());
    }
    //end MobileAdjustment

    //default methods for DesktopAdjustment
    public Long addDefaultBidModifierDesktop(String login, Integer campaignId, Long adGroupId) {
        List<Long> bidModifierIds = bidModifiersAdd(login, new BidModifierAddMap()
                .withDesktopAdjustment(new DesktopAdjustmentMap()
                        .defaultDesktopAdjustment())
                .withCampaignId((campaignId != null) ? (campaignId.longValue()) : (null))
                .withAdGroupId(adGroupId));
        assumeThat("добавлена дектопная корректировка ставок", bidModifierIds, hasSize(1));
        return bidModifierIds.get(0);
    }

    public Long addBidModifierDesktopToGroup(String login, Long adGroupId) {
        return addDefaultBidModifierDesktop(login, null, adGroupId);
    }

    public Long addBidModifierDesktopToGroup(Long adGroupId) {
        return addDefaultBidModifierDesktop(null, null, adGroupId);
    }
    //end DesktopAdjustment

    //default methods for SmartTvAdjustment
    public Long addDefaultBidModifierSmartTv(String login, Integer campaignId, Long adGroupId) {
        List<Long> bidModifierIds = bidModifiersAdd(login, new BidModifierAddMap()
                .withSmartTvAdjustment(new SmartTvAdjustmentMap()
                        .defaultSmartTvAdjustment())
                .withCampaignId((campaignId != null) ? (campaignId.longValue()) : (null))
                .withAdGroupId(adGroupId));
        assumeThat("добавлена smart tv корректировка ставок", bidModifierIds, hasSize(1));
        return bidModifierIds.get(0);
    }

    public Long addBidModifierSmartTvToGroup(Long adGroupId) {
        return addDefaultBidModifierSmartTv(null, null, adGroupId);
    }
    //end SmartTvAdjustment

    //default methods for DemographicsAdjustment
    public Long addDefaultBidModifierDemographics(String login, Integer campaignId, Long adGroupId) {
        List<Long> bidModifierIds = bidModifiersAdd(login, new BidModifierAddMap()
                .withDemographicsAdjustment(new DemographicsAdjustmentMap()
                        .defaultDemographicsAdjustment())
                .withCampaignId((campaignId != null) ? (campaignId.longValue()) : (null))
                .withAdGroupId(adGroupId));
        assumeThat("добавлена демографическая корректировка ставок", bidModifierIds, hasSize(1));
        return bidModifierIds.get(0);
    }

    public Long addBidModifierDemographicsToGroup(String login, Long adGroupId) {
        return addDefaultBidModifierDemographics(login, null, adGroupId);
    }

    public Long addBidModifierDemographicsToGroup(Long adGroupId) {
        return addDefaultBidModifierDemographics(null, null, adGroupId);
    }

    public Long addBidModifierDemographicsToCampaign(String login, Integer campaignId) {
        return addDefaultBidModifierDemographics(login, campaignId, null);
    }

    public Long addBidModifierDemographicsToCampaign(Integer campaignId) {
        return addDefaultBidModifierDemographics(null, campaignId, null);
    }
    //end DemographicsAdjustment

    //default methods for RetargetingAdjustment
    public Long addDefaultBidModifierRetargeting(String login, Long conditionId, Integer campaignId, Long adGroupId) {
        List<Long> bidModifierIds = bidModifiersAdd(login, new BidModifierAddMap()
                .withRetargetingAdjustment(new RetargetingAdjustmentMap()
                        .defaultRetargetingAdjustment()
                        .withRetargetingConditionId(conditionId))
                .withCampaignId((campaignId != null) ? (campaignId.longValue()) : (null))
                .withAdGroupId(adGroupId));
        assumeThat("добавлена корректировка ставок ретаргетинга", bidModifierIds, hasSize(1));
        return bidModifierIds.get(0);
    }

    public Long addBidModifierRetargetingToGroup(String login, Long conditionId, Long adGroupId) {
        return addDefaultBidModifierRetargeting(login, conditionId, null, adGroupId);
    }

    public Long addBidModifierRetargetingToGroup(Long conditionId, Long adGroupId) {
        return addDefaultBidModifierRetargeting(null, conditionId, null, adGroupId);
    }

    public Long addBidModifierRetargetingToCampaign(Long conditionId, Integer campaignId) {
        return addDefaultBidModifierRetargeting(null, conditionId, campaignId, null);
    }

    public Long addBidModifierRetargetingToCampaign(String login, Long conditionId, Integer campaignId) {
        return addDefaultBidModifierRetargeting(login, conditionId, campaignId, null);
    }
    //end RetargetingAdjustment

    //default methods for RegionalAdjustment
    public Long addDefaultBidModifierRegional(String login, Long regionId, Long campaignId) {
        List<Long> bidModifierIds = bidModifiersAdd(login, new BidModifierAddMap()
                .withRegionalAdjustment(new RegionalAdjustmentMap()
                        .defaultRegionalAdjustment()
                        .withRegionId(regionId))
                .withCampaignId(campaignId));
        assumeThat("добавлена корректировка ставок региона", bidModifierIds, hasSize(1));
        return bidModifierIds.get(0);
    }

    public Long addBidModifierRegionalToCampaign(Long regionId, Long campaignId) {
        return addDefaultBidModifierRegional(null, regionId, campaignId);
    }

    public Long addBidModifierRegionalToCampaign(String login, Long regionId, Long campaignId) {
        return addDefaultBidModifierRegional(login, regionId, campaignId);
    }

    public Long addBidModifierRegionalToCampaign(Long campaignId) {
        return addDefaultBidModifierRegional(null, RegionalAdjustmentMap.DEFAULT_REGION_ID.longValue(), campaignId);
    }

    public Long addBidModifierRegionalToCampaign(String login, Long campaignId) {
        return addDefaultBidModifierRegional(login, RegionalAdjustmentMap.DEFAULT_REGION_ID.longValue(), campaignId);
    }
    //end RegionalAdjustment

    //default methods for VideoAdjustment
    public Long addDefaultBidModifierVideo(String login, Integer campaignId, Long adGroupId) {
        List<Long> bidModifierIds = bidModifiersAdd(login, new BidModifierAddMap()
                .withVideoAdjustment(new VideoAdjustmentMap()
                        .defaultVideoAdjustment())
                .withCampaignId((campaignId != null) ? (campaignId.longValue()) : (null))
                .withAdGroupId(adGroupId));
        assumeThat("добавлена видео корректировка ставок", bidModifierIds, hasSize(1));
        return bidModifierIds.get(0);
    }

    public Long addBidModifierVideoToGroup(String login, Long adGroupId) {
        return addDefaultBidModifierVideo(login, null, adGroupId);
    }

    public Long addBidModifierVideoToGroup(Long adGroupId) {
        return addDefaultBidModifierVideo(null, null, adGroupId);
    }

    public Long addBidModifierVideoToCampaign(String login, Integer campaignId) {
        return addDefaultBidModifierVideo(login, campaignId, null);
    }

    public Long addBidModifierVideoToCampaign(Integer campaignId) {
        return addDefaultBidModifierVideo(null, campaignId, null);
    }

    public Long addBidModifierVideoToCampaign(Long campaignId) {
        return addBidModifierVideoToCampaign(campaignId.intValue());
    }
    //end VideoAdjustment

    //default methods for SerpLayoutAdjustment
    public Long addDefaultBidModifierSerpLayout(String login, Long campaignId) {
        List<Long> bidModifierIds = bidModifiersAdd(login, new BidModifierAddMap()
                .withSerpLayoutAdjustment(new SerpLayoutAdjustmentMap()
                        .defaultSerpLayoutAdjustment())
                .withCampaignId(campaignId));
        assumeThat("добавлена корректировка ставок на позицию", bidModifierIds, hasSize(1));
        return bidModifierIds.get(0);
    }

    public Long addBidModifierSerpLayoutToCampaign(Long campaignId) {
        return addDefaultBidModifierSerpLayout(null, campaignId);
    }
    //end SerpLayoutAdjustment

    @Step("[BidModifiers]: Get")
    public List<BidModifierGetItem> bidModifiersGet(String login, GetRequestMap request) {
        List<BidModifierGetItem> results = ((GetResponse) defaultClientV5()
                .invokeMethod(ServiceNames.BID_MODIFIERS, login, Action.GET, request.getBean())).getBidModifiers();
        return results;
    }

    public List<BidModifierGetItem> bidModifiersGet(GetRequestMap request) {
        return bidModifiersGet(null, request);
    }

    @Step("[BidModifiers]: Get")
    public GetResponse bidModifiersGetRawResponse(String login, GetRequestMap request) {
        return (GetResponse) this.defaultClientV5()
                .invokeMethod(ServiceNames.BID_MODIFIERS, login, Action.GET, request.getBean());
    }

    public GetResponse bidModifiersGetRawResponse(GetRequestMap request) {
        return bidModifiersGetRawResponse(null, request);
    }

    public List<BidModifierGetItem> bidModifiersGetById(Long... bmId) {
        return bidModifiersGetById(null, bmId);
    }

    public List<BidModifierGetItem> bidModifiersGetById(String login, Long... bmId) {
        return bidModifiersGetWithSelectionCriteria(login, new BidModifiersSelectionCriteriaMap()
                .withAllLevels()
                .withIds(bmId));
    }

    public List<BidModifierGetItem> bidModifiersGetByCampaignId(Integer campaignId) {
        return bidModifiersGetByCampaignId(null, campaignId);
    }

    public List<BidModifierGetItem> bidModifiersGetByCampaignId(Long campaignId) {
        return bidModifiersGetByCampaignId(campaignId.intValue());
    }

    public List<BidModifierGetItem> bidModifiersGetByCampaignId(String login, Integer campaignId) {
        assumeThat("передан campaignID", campaignId, notNullValue());
        return bidModifiersGetWithSelectionCriteria(login, new BidModifiersSelectionCriteriaMap()
                .withAllLevels()
                .withCampaignIds(campaignId.longValue()));
    }

    public List<BidModifierGetItem> bidModifiersGetByAdGroupId(Long adGroupId) {
        return bidModifiersGetByAdGroupId(null, adGroupId);
    }

    public List<BidModifierGetItem> bidModifiersGetByAdGroupId(String login, Long adGroupId) {
        return bidModifiersGetWithSelectionCriteria(login, new BidModifiersSelectionCriteriaMap()
                .withAllLevels()
                .withAdGroupIds(adGroupId));
    }

    public List<BidModifierGetItem> bidModifiersGetWithSelectionCriteria(
            BidModifiersSelectionCriteriaMap selectionCriteria) {
        return bidModifiersGetWithSelectionCriteria(null, selectionCriteria);
    }

    public List<BidModifierGetItem> bidModifiersGetWithSelectionCriteria(String login,
                                                                         BidModifiersSelectionCriteriaMap selectionCriteria) {
        return bidModifiersGet(login, new GetRequestMap()
                .withSelectionCriteria(selectionCriteria)
                .withAllFieldNames()
                .withAllVideoFieldNames()
                .withAllDemographicsFieldNames()
                .withAllRetargetingFieldNames()
                .withAllRegionalFieldNames()
                .withAllMobileFieldNames()
                .withAllSerpLayoutFieldNames()
                .withAllIncomeGradeFieldNames());
    }

    @Step("[BidModifiers]: Delete")
    public List<Long> bidModifiersDelete(String login, Long... bmIds) {
        DeleteRequestMap request = new DeleteRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds(bmIds));
        List<ActionResult> results = ((DeleteResponse) defaultClientV5()
                .invokeMethod(ServiceNames.BID_MODIFIERS, login, Action.DELETE, request.getBean())).getDeleteResults();
        lookForResponseExceptions(results);
        return getIDsFromActionResults(results);
    }

    public List<Long> bidModifiersDelete(Long... bmIds) {
        return bidModifiersDelete(null, bmIds);
    }

    @Step("[BidModifiers]: Set")
    public List<Long> bidModifiersSet(String login, SetRequestMap setRequestMap) {
        List<ActionResult> results = ((SetResponse) defaultClientV5()
                .invokeMethod(ServiceNames.BID_MODIFIERS, login, Action.SET, setRequestMap.getBean())).getSetResults();
        lookForResponseExceptions(results);
        return getIDsFromActionResults(results);
    }

    public List<Long> bidModifiersSet(SetRequestMap setRequestMap) {
        return bidModifiersSet(null, setRequestMap);
    }

    public List<Long> bidModifiersSet(String login, Long bmId, Integer bmValue) {
        SetRequestMap request = new SetRequestMap().withBidModifiers(new BidModifierSetMap()
                .withId(bmId)
                .withBidModifier(bmValue));
        return bidModifiersSet(login, request);
    }

    public List<Long> bidModifiersSet(Long bmId, Integer bmValue) {
        return bidModifiersSet(null, bmId, bmValue);
    }

    public List<ToggleResult> bidModifiersToggle(BidModifierToggleMap... toggleItemMap) {
        return bidModifiersToggle(null, toggleItemMap);
    }

    public List<ToggleResult> bidModifiersToggle(String login, BidModifierToggleMap... toggleItemMap) {
        ToggleRequestMap request = new ToggleRequestMap().withBidModifierToggleItems(toggleItemMap);
        return bidModifiersToggle(login, request);
    }

    public List<ToggleResult> bidModifiersToggle(String login, Long campaignId, Long groupId,
                                                 BidModifierToggleTypeEnum type, YesNoEnum enabled) {
        ToggleRequestMap request = new ToggleRequestMap().withBidModifierToggleItems(new BidModifierToggleMap()
                .withCampaignId(campaignId)
                .withAdGroupId(groupId)
                .withType(type)
                .withEnabled(enabled));
        return bidModifiersToggle(login, request);
    }

    public List<ToggleResult> bidModifiersToggle(Long campaignId, Long groupId, BidModifierToggleTypeEnum type,
                                                 YesNoEnum enabled) {
        return bidModifiersToggle(null, campaignId, groupId, type, enabled);
    }

    public List<ToggleResult> toggleBidModifiersCampaign(String login, Long campaignId, BidModifierToggleTypeEnum type,
                                                         YesNoEnum enabled) {
        return bidModifiersToggle(login, campaignId, null, type, enabled);
    }

    public List<ToggleResult> toggleBidModifiersCampaign(Long campaignId, BidModifierToggleTypeEnum type,
                                                         YesNoEnum enabled) {
        return bidModifiersToggle(null, campaignId, null, type, enabled);
    }

    public List<ToggleResult> toggleBidModifiersGroup(String login, Long groupId, BidModifierToggleTypeEnum type,
                                                      YesNoEnum enabled) {
        return bidModifiersToggle(login, null, groupId, type, enabled);
    }

    public List<ToggleResult> toggleBidModifiersGroup(Long groupId, BidModifierToggleTypeEnum type, YesNoEnum enabled) {
        return bidModifiersToggle(null, null, groupId, type, enabled);
    }

    @Step("[BidModifiers]: Toggle")
    public List<ToggleResult> bidModifiersToggle(String login, ToggleRequestMap request) {
        List<ToggleResult> results = ((ToggleResponse) defaultClientV5()
                .invokeMethod(ServiceNames.BID_MODIFIERS, login, Action.TOGGLE, request.getBean())).getToggleResults();
        lookForResponseExceptionsToggle(results);
        return results;
    }

    public List<ToggleResult> bidModifiersToggle(ToggleRequestMap request) {
        return bidModifiersToggle(null, request);
    }

    private void lookForResponseExceptions(List<ActionResult> results) {
        List<ActionResult> errors = select(results, having(on(ActionResult.class).getErrors(), not(emptyIterable())));

        assertThat("отсутствуют ошибки при вызове метода", errors, emptyIterable());
    }

    private List<Long> getIDsFromActionResults(List<ActionResult> results) {
        return extract(results, on(ActionResult.class).getId());
    }

    private void lookForResponseExceptionsMultiIds(List<MultiIdsActionResult> results) {
        List<MultiIdsActionResult> errors =
                select(results, having(on(MultiIdsActionResult.class).getErrors(), not(emptyIterable())));

        assertThat("отсутствуют ошибки при вызове метода", errors, emptyIterable());
    }

    private List<Long> getIDsFromMultiIdsActionResults(List<MultiIdsActionResult> results) {
        List<Long> idsFlatList = extract(results, on(MultiIdsActionResult.class).getIds())
                .stream().flatMap(l -> l.stream()).collect(toList());

        return idsFlatList;
    }

    private void lookForResponseExceptionsToggle(List<ToggleResult> results) {
        List<ToggleResult> errors = select(results, having(on(ToggleResult.class).getErrors(), not(emptyIterable())));

        assertThat("отсутствуют ошибки при вызове метода", errors, emptyIterable());
    }

    public <T extends BeanMap> void shouldGetBidModifierErrorOn(Action action, T request, Api5Error api5Error) {
        shouldGetErrorOn("", ServiceNames.BID_MODIFIERS, null, action, request, api5Error);
    }

    public <T extends BeanMap> void shouldGetBidModifierErrorOn(Action action, T request,
                                                                JavaOrPerlApi5Error api5Error) {
        shouldGetErrorOn("", ServiceNames.BID_MODIFIERS, null, action, request, api5Error);
    }

    public <T extends BeanMap> void shouldGetBidModifierErrorOn(Action action, T request, Api5Error api5Error,
                                                                Api5Error alternativeApi5Error) {
        shouldGetErrorOn("", ServiceNames.BID_MODIFIERS, null, action, request, api5Error, alternativeApi5Error);
    }

    public <T extends BeanMap> void shouldGetBidModifierErrorOn(String message, Action action, T request,
                                                                Api5Error api5Error) {
        shouldGetErrorOn(message, ServiceNames.BID_MODIFIERS, null, action, request, api5Error);
    }

    public <T extends BeanMap> void shouldGetBidModifierErrorOn(String message, Action action, T request,
                                                                Api5Error api5Error, Api5Error api5AlternativeError) {
        shouldGetErrorOn(message, ServiceNames.BID_MODIFIERS, null, action, request, api5Error, api5AlternativeError);
    }

    public <T extends BeanMap> void shouldGetBidModifierErrorOn(Action action, String login, T request,
                                                                Api5Error api5Error) {
        shouldGetErrorOn("", ServiceNames.BID_MODIFIERS, login, action, request, api5Error);
    }

    public <T extends BeanMap> void shouldGetBidModifierErrorOn(String message, Action action, String login, T request,
                                                                Api5Error api5Error) {
        shouldGetErrorOn(message, ServiceNames.BID_MODIFIERS, login, action, request, api5Error);
    }

    public <T> void shouldGetBidModifierErrorJsonOn(Action action, String login, T request, Api5Error api5Error) {
        shouldGetJSONErrorOn(ServiceNames.BID_MODIFIERS, login, action, request, api5Error);
    }

    public <T> void shouldGetBidModifierErrorJsonOn(Action action, T request, Api5Error api5Error) {
        shouldGetJSONErrorOn(ServiceNames.BID_MODIFIERS, null, action, request, api5Error);
    }

    public <T> void shouldGetBidModifierErrorJsonOn(Action action, T request, Api5Error api5Error,
                                                    Api5Error alternativeError) {
        shouldGetJSONErrorOn(ServiceNames.BID_MODIFIERS, null, action, request, api5Error, alternativeError);
    }

    public <T extends BeanMap> Object shouldGetResultOn(Action action,
                                                        T args,
                                                        ExpectedResult... expectedResults) {
        return shouldGetResultOn(null, action, args, expectedResults);
    }

    public <T extends BeanMap> AddResponse shouldGetResultOnAdd(T args, ExpectedResult... expectedResults) {
        return (AddResponse) shouldGetResultOn(null, Action.ADD, args, expectedResults);
    }

    public <T extends BeanMap> AddResponse shouldGetResultOnAdd(T args, MultiIdsExpectedResult... expectedResults) {
        return (AddResponse) shouldGetResultOn(null, Action.ADD, args, expectedResults);
    }

    public <T extends BeanMap> Object shouldGetEitherResultOn(Action action,
                                                              T args,
                                                              List<ExpectedResult> expectedResults,
                                                              @Nullable List<ExpectedResult> alternativeResults) {
        return shouldGetEitherResultOn(null, action, args, expectedResults, alternativeResults);
    }

    public <T extends BeanMap> Object shouldGetResultOn(Action action,
                                                        T args,
                                                        MultiIdsExpectedResult... expectedResults) {
        return shouldGetResultOn(null, action, args, expectedResults);
    }

    public <T extends BeanMap> Object shouldGetResultOn(Action action,
                                                        T args,
                                                        ToggleExpectedResult... expectedResults) {
        return shouldGetResultOn(null, action, args, expectedResults);
    }

    public <T extends BeanMap> Object shouldGetResultOn(Action action,
                                                        T args,
                                                        List<MultiIdsExpectedResult> expectedResults,
                                                        @Nullable List<MultiIdsExpectedResult> alternativeResults) {
        return shouldGetResultOn(null, action, args, expectedResults, alternativeResults);
    }

    @Step("Проверяем ID/Warnings/Errors в ответе сервиса BidModifiers")
    public <T extends BeanMap> Object shouldGetResultOn(String login, Action action, T args,
                                                        ExpectedResult... expectedResults) {
        Object response = defaultClientV5()
                .invokeMethod(ServiceNames.BID_MODIFIERS, login, action, (args == null ? null : args.getBean()));
        ArrayList<ActionResult> actualResult = extractActionResults(response, action);
        checkActionResults(actualResult, expectedResults);
        return response;
    }

    @Step("Проверяем ID/Warnings/Errors в ответе сервиса BidModifiers")
    public <T extends BeanMap> Object shouldGetResultOn(String login, Action action, T args,
                                                        MultiIdsExpectedResult... expectedResults) {
        Object response = defaultClientV5()
                .invokeMethod(ServiceNames.BID_MODIFIERS, login, action, (args == null ? null : args.getBean()));
        List<MultiIdsActionResult> actualResult = extractActionResults(response, action);
        checkMultiIdsActionResults(actualResult, expectedResults);
        return response;
    }

    /**
     * Позволяет проверить одновременно perl и java реализацию (если ошибки отличаются).
     */
    @Step("Проверяем ID/Warnings/Errors в ответе сервиса BidModifiers")
    public <T extends BeanMap> Object shouldGetResultOn(String login, Action action, T args,
                                                        List<MultiIdsExpectedResult> expectedResults,
                                                        @Nullable List<MultiIdsExpectedResult> alternativeResults) {
        Object response = defaultClientV5()
                .invokeMethod(ServiceNames.BID_MODIFIERS, login, action, (args == null ? null : args.getBean()));
        List<MultiIdsActionResult> actualResult = extractActionResults(response, action);
        if (alternativeResults != null) {
            checkMultiIdsActionResults(actualResult, expectedResults, alternativeResults);
        } else {
            checkMultiIdsActionResults(actualResult,
                    expectedResults.toArray(new MultiIdsExpectedResult[expectedResults.size()]));
        }
        return response;
    }

    /**
     * Позволяет проверить одновременно perl и java реализацию (если ошибки отличаются).
     */
    @Step("Проверяем ID/Warnings/Errors в ответе сервиса BidModifiers")
    public <T extends BeanMap> Object shouldGetEitherResultOn(String login, Action action, T args,
                                                              List<ExpectedResult> expectedResults,
                                                              @Nullable List<ExpectedResult> alternativeResults) {
        Object response = defaultClientV5()
                .invokeMethod(ServiceNames.BID_MODIFIERS, login, action, (args == null ? null : args.getBean()));
        List<ActionResult> actualResult = extractActionResults(response, action);
        if (alternativeResults != null) {
            checkActionResultsMatchEither(actualResult, expectedResults, alternativeResults);
        } else {
            checkActionResults(actualResult,
                    expectedResults.toArray(new ExpectedResult[expectedResults.size()]));
        }
        return response;
    }

    @Step("Проверяем ID/Warnings/Errors в ответе сервиса BidModifiers")
    public <T extends BeanMap> Object shouldGetResultOn(String login, Action action, T args,
                                                        ToggleExpectedResult... expectedResults) {
        Object response = defaultClientV5()
                .invokeMethod(ServiceNames.BID_MODIFIERS, login, action, (args == null ? null : args.getBean()));
        ArrayList<ToggleResult> actualResult = extractActionResults(response, action);
        checkToggleActionResults(actualResult, expectedResults);
        return response;
    }

    private void checkMultiIdsActionResults(List<MultiIdsActionResult> actualResults,
                                            MultiIdsExpectedResult... expectedResults) {
        List<BeanEquals<MultiIdsActionResult>> expectedMatchers = new ArrayList<>();

        for (MultiIdsExpectedResult expResult : expectedResults) {
            expectedMatchers.add(BeanEquals.beanEquals((MultiIdsActionResult) expResult.getBean())
                    .accordingStrategy(expResult.getActionResultCompareStrategy())
            );
        }

        BeanEquals[] array = new BeanEquals[expectedMatchers.size()];
        assertThat("содержание результатов соответствует ожидаемому", actualResults,
                contains(expectedMatchers.toArray(array)));
    }

    private static void checkMultiIdsActionResults(List<MultiIdsActionResult> actualResults,
                                                   List<MultiIdsExpectedResult> expectedResults,
                                                   List<MultiIdsExpectedResult> alternativeExpectedResults) {
        BeanEquals[] beanEquals = multiIdsExpectedResultsToBeanEquals(expectedResults);
        BeanEquals[] alternativeBeanEquals = multiIdsExpectedResultsToBeanEquals(alternativeExpectedResults);
        assertThat("содержание результатов соответствует ожидаемому", actualResults,
                either(contains(beanEquals)).or(contains(alternativeBeanEquals)));
    }

    private static BeanEquals[] multiIdsExpectedResultsToBeanEquals(List<MultiIdsExpectedResult> expectedResults) {
        List<BeanEquals<MultiIdsActionResult>> expectedMatchers = new ArrayList<>();

        for (MultiIdsExpectedResult expResult : expectedResults) {
            expectedMatchers.add(BeanEquals.beanEquals((MultiIdsActionResult) expResult.getBean())
                    .accordingStrategy(expResult.getActionResultCompareStrategy())
            );
        }

        BeanEquals[] array = new BeanEquals[expectedMatchers.size()];
        return expectedMatchers.toArray(array);
    }

    private void checkToggleActionResults(List<ToggleResult> actualResults, ToggleExpectedResult... expectedResults) {
        List<BeanEquals<ToggleResult>> expectedMatchers = new ArrayList<>();

        for (ToggleExpectedResult expResult : expectedResults) {
            expectedMatchers.add(BeanEquals.beanEquals((ToggleResult) expResult.getBean())
                    .accordingStrategy(expResult.getActionResultCompareStrategy())
            );
        }

        BeanEquals[] array = new BeanEquals[expectedMatchers.size()];
        assertThat("содержание результатов соответствует ожидаемому", actualResults,
                contains(expectedMatchers.toArray(array)));
    }

    public <T extends BeanMap> Object shouldGetToggleResultOn(String login, T args,
                                                              JavaOrPerlToggleExpectedResult... expectedResults) {
        @SuppressWarnings("unchecked")
        MethodInvocationResult response = defaultClientV5().invokeMethodEx(ServiceNames.BID_MODIFIERS, login,
                Action.TOGGLE, (args == null ? null : args.getBean()));
        ArrayList<ToggleResult> actualResult = extractActionResults(response.getResponseObject(), Action.TOGGLE);
        checkToggleActionResults(actualResult, response.isJavaResponse(), expectedResults);
        return response.getResponseObject();
    }

    private void checkToggleActionResults(
            List<ToggleResult> actualResults, boolean isJavaResponse,
            JavaOrPerlToggleExpectedResult[] expectedResults) {
        List<Matcher<? super ToggleResult>> expectedMatchers = new ArrayList<>();

        for (JavaOrPerlToggleExpectedResult javaOrPerlExpectedResult : expectedResults) {
            ToggleExpectedResult expectedResult = isJavaResponse
                    ? javaOrPerlExpectedResult.getJavaResult()
                    : javaOrPerlExpectedResult.getPerlResult();
            expectedMatchers.add(BeanEquals.beanEquals((ToggleResult) expectedResult.getBean())
                    .accordingStrategy(expectedResult.getActionResultCompareStrategy()));
        }

        Matcher<Iterable<? extends ToggleResult>> resultMatcher = contains(expectedMatchers);
        assertThat("содержание результатов соответствует ожидаемому", actualResults, resultMatcher);
    }
}
