package ru.yandex.autotests.directapi.steps.prices;

import java.util.List;

import com.yandex.direct.api.v5.bids.BidFieldEnum;
import com.yandex.direct.api.v5.bids.GetRequest;
import com.yandex.direct.api.v5.bids.GetResponse;
import com.yandex.direct.api.v5.bids.SetAutoRequest;
import com.yandex.direct.api.v5.bids.SetAutoResponse;
import com.yandex.direct.api.v5.bids.SetRequest;
import com.yandex.direct.api.v5.bids.SetResponse;

import ru.yandex.autotests.directapi.apiclient.RequestHeader;
import ru.yandex.autotests.directapi.apiclient.config.ConnectionConfig;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.version5.ServiceNames;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.bids.BidExpectedResult;
import ru.yandex.autotests.directapi.model.api5.bids.BidsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.bids.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.bids.SetAutoRequestMap;
import ru.yandex.autotests.directapi.model.api5.bids.SetRequestMap;
import ru.yandex.autotests.directapi.steps.BaseApiSteps;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Step;

/**
 * Created by ginger on 29.05.14.
 */
public class BidsSteps extends BaseApiSteps {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    private static BidsSteps _instance;

    private BidsSteps(ConnectionConfig connectionConfig, RequestHeader requestHeader) {
        super(connectionConfig, requestHeader);
    }

    public static BidsSteps getInstance(ConnectionConfig connectionConfig, RequestHeader requestHeader) {
        if (_instance == null) {
            _instance = new BidsSteps(connectionConfig, requestHeader);
        } else {
            _instance.setConnectionConfig(connectionConfig);
            _instance.setRequestHeader(requestHeader);
        }
        return _instance;
    }

    @Step("[Bids]: Get")
    public GetResponse bidsGet(GetRequestMap parameters, String login) {
        return defaultClientV5().invokeMethod(ServiceNames.BIDS, login, Action.GET, (GetRequest) parameters.getBean());
    }

    public GetResponse bidsGet(GetRequestMap parameters) {
        return bidsGet(parameters, null);
    }

    public GetResponse bidsGetByKeywordIdsWithFields(List<BidFieldEnum> fields, Long... keywordIds) {
        return bidsGet(
                new GetRequestMap().withSelectionCriteria(
                        new BidsSelectionCriteriaMap().withKeywordIds(keywordIds)
                ).withFieldNames(fields.toArray(new BidFieldEnum[fields.size()]))
        );
    }

    public void shouldGetErrorOnBidsGet(GetRequestMap parameters, String login, Api5Error api5Error) {
        shouldGetErrorOn(ServiceNames.BIDS, login, Action.GET, parameters, api5Error);
    }

    public void shouldGetErrorOnBidsGet(GetRequestMap parameters, Api5Error api5Error) {
        shouldGetErrorOnBidsGet(parameters, null, api5Error);
    }

    public void shouldGetBidResultOnGet(GetRequestMap parameters, String login, BidExpectedResult... expectedResults) {
        shouldGetBidResultOn(login, ServiceNames.BIDS, Action.GET, parameters, expectedResults);
    }

    public void shouldGetJSONErrorOnBidsGet(Object parameters, String login, Api5Error api5Error) {
        shouldGetJSONErrorOn(ServiceNames.BIDS, login, Action.GET, parameters, api5Error);
    }

    @Step("[Bids]: Set")
    public SetResponse bidsSet(SetRequestMap parameters, String login) {
        return defaultClientV5().invokeMethod(ServiceNames.BIDS, login, Action.SET, (SetRequest) parameters.getBean());
    }

    public SetResponse bidsSet(SetRequestMap parameters) {
        return bidsSet(parameters, null);
    }

    public void shouldGetErrorOnBidsSet(SetRequestMap parameters, String login, Api5Error api5Error) {
        shouldGetErrorOn(ServiceNames.BIDS, login, Action.SET, parameters, api5Error);
    }

    public void shouldGetJSONErrorOnBidsSet(Object parameters, String login, Api5Error api5Error) {
        shouldGetJSONErrorOn(ServiceNames.BIDS, login, Action.SET, parameters, api5Error);
    }

    public void shouldGetBidResultOnSet(SetRequestMap parameters, String login, BidExpectedResult... expectedResults) {
        shouldGetBidResultOn(login, ServiceNames.BIDS, Action.SET, parameters, expectedResults);
    }

    public void shouldGetBidResultOnSet(SetRequestMap parameters, BidExpectedResult... expectedResults) {
        shouldGetBidResultOn(null, ServiceNames.BIDS, Action.SET, parameters, expectedResults);
    }

    @Step("[Bids]: SetAuto")
    public SetAutoResponse bidsSetAuto(SetAutoRequestMap parameters, String login) {
        return defaultClientV5()
                .invokeMethod(ServiceNames.BIDS, login, Action.SET_AUTO, (SetAutoRequest) parameters.getBean());
    }

    public void shouldGetErrorOnBidsSetAuto(SetAutoRequestMap parameters, String login, Api5Error api5Error) {
        shouldGetErrorOn(ServiceNames.BIDS, login, Action.SET_AUTO, parameters, api5Error);
    }

    public void shouldGetJSONErrorOnBidsSetAuto(Object parameters, String login, Api5Error api5Error) {
        shouldGetJSONErrorOn(ServiceNames.BIDS, login, Action.SET_AUTO, parameters, api5Error);
    }

    public void shouldGetBidResultOnSetAuto(SetAutoRequestMap parameters, String login,
            BidExpectedResult... expectedResults)
    {
        shouldGetBidResultOn(login, ServiceNames.BIDS, Action.SET_AUTO, parameters, expectedResults);
    }

    public void shouldGetBidResultOnSetAuto(SetAutoRequestMap parameters, BidExpectedResult... expectedResults) {
        shouldGetBidResultOn(null, ServiceNames.BIDS, Action.SET_AUTO, parameters, expectedResults);
    }

    //JSON

    public <T> void shouldGetBidResultOnJson(Action action,
            String login,
            T args,
            BidExpectedResult... expectedResults)
    {
        shouldGetBidResultOnJson(ServiceNames.BIDS, login, action, args, expectedResults);
    }
}
