package ru.yandex.autotests.directapi.steps.prices;

import java.util.ArrayList;
import java.util.List;

import com.yandex.direct.api.v5.keywordbids.GetResponse;
import com.yandex.direct.api.v5.keywordbids.KeywordBidActionResult;
import com.yandex.direct.api.v5.keywordbids.KeywordBidFieldEnum;
import com.yandex.direct.api.v5.keywordbids.SetAutoResponse;
import com.yandex.direct.api.v5.keywordbids.SetResponse;
import org.apache.commons.beanutils.BeanMap;
import org.hamcrest.Matcher;

import ru.yandex.autotests.direct.utils.matchers.BeanEquals;
import ru.yandex.autotests.directapi.apiclient.RequestHeader;
import ru.yandex.autotests.directapi.apiclient.config.ConnectionConfig;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.version5.ServiceNames;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.keywordbids.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.keywordbids.KeywordBidExpectedResult;
import ru.yandex.autotests.directapi.model.api5.keywordbids.KeywordBidsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.keywordbids.SetAutoRequestMap;
import ru.yandex.autotests.directapi.model.api5.keywordbids.SetRequestMap;
import ru.yandex.autotests.directapi.steps.BaseApiSteps;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static org.hamcrest.Matchers.contains;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

public class KeywordBidsSteps extends BaseApiSteps {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    private static KeywordBidsSteps _instance;

    private KeywordBidsSteps(ConnectionConfig connectionConfig, RequestHeader requestHeader) {
        super(connectionConfig, requestHeader);
    }

    public static KeywordBidsSteps getInstance(ConnectionConfig connectionConfig, RequestHeader requestHeader) {
        if (_instance == null) {
            _instance = new KeywordBidsSteps(connectionConfig, requestHeader);
        } else {
            _instance.setConnectionConfig(connectionConfig);
            _instance.setRequestHeader(requestHeader);
        }
        return _instance;
    }

    @Step("[KeywordBids]: Get")
    public GetResponse keywordBidsGet(GetRequestMap parameters) {
        return keywordBidsGet(parameters, null);
    }

    @Step("[KeywordBids]: Get")
    public GetResponse keywordBidsGet(GetRequestMap parameters, String login) {
        return defaultClientV5()
                .invokeMethod(ServiceNames.KEYWORD_BIDS, login, Action.GET, parameters.getBean());
    }

    @Step("[KeywordBids]: Set")
    public SetResponse keywordBidsSet(SetRequestMap parameters) {
        return keywordBidsSet(parameters, null);
    }

    @Step("[KeywordBids]: Set")
    public SetResponse keywordBidsSet(SetRequestMap parameters, String login) {
        return defaultClientV5()
                .invokeMethod(ServiceNames.KEYWORD_BIDS, login, Action.SET, parameters.getBean());
    }

    @Step("[Bids]: SetAuto")
    public SetAutoResponse keywordBidsSetAuto(SetAutoRequestMap parameters, String login) {
        return defaultClientV5()
                .invokeMethod(ServiceNames.KEYWORD_BIDS, login, Action.SET_AUTO, parameters.getBean());
    }

    public void shouldGetErrorOnKeywordBidsSet(SetRequestMap parameters, String login, Api5Error api5Error) {
        shouldGetErrorOn(ServiceNames.KEYWORD_BIDS, login, Action.SET, parameters, api5Error);
    }

    public void shouldGetErrorOnKeywordBidsGet(GetRequestMap parameters, String login, Api5Error api5Error) {
        shouldGetErrorOn(ServiceNames.KEYWORD_BIDS, login, Action.GET, parameters, api5Error);
    }

    public void shouldGetKeywordBidResultOnSet(SetRequestMap parameters, String login,
            KeywordBidExpectedResult... expectedResults)
    {
        shouldGetKeywordBidResultOn(login, ServiceNames.KEYWORD_BIDS, Action.SET, parameters, expectedResults);
    }

    public void shouldGetKeywordBidResultOnSet(SetRequestMap parameters, KeywordBidExpectedResult... expectedResults) {
        shouldGetKeywordBidResultOnSet(parameters, null, expectedResults);
    }

    public void shouldGetKeywordBidResultOnSetAuto(SetAutoRequestMap parameters, String login,
            KeywordBidExpectedResult... expectedResults)
    {
        shouldGetKeywordBidResultOn(login, ServiceNames.KEYWORD_BIDS, Action.SET_AUTO, parameters, expectedResults);
    }

    public void shouldGetKeywordBidResultOnSetAuto(SetAutoRequestMap parameters,
            KeywordBidExpectedResult... expectedResults)
    {
        shouldGetKeywordBidResultOnSetAuto(parameters, null, expectedResults);
    }

    public void shouldGetErrorOnBidsSetAuto(SetAutoRequestMap parameters, String login, Api5Error api5Error) {
        shouldGetErrorOn(ServiceNames.KEYWORD_BIDS, login, Action.SET_AUTO, parameters, api5Error);
    }

    public <T extends BeanMap> void shouldGetKeywordBidResultOn(
            String login, ServiceNames serviceName, Action action, T args, KeywordBidExpectedResult... expectedResults)
    {
        shouldGetKeywordBidResultOn("", login, serviceName, action, args, expectedResults);
    }

    public void shouldGetErrorOnBidsSet(SetRequestMap parameters, String login, Api5Error api5Error) {
        shouldGetErrorOn(ServiceNames.KEYWORD_BIDS, login, Action.SET, parameters, api5Error);
    }

    @Step("Проверяем ID/Warnings/Errors в ответе сервиса Bid")
    public <T extends BeanMap> void shouldGetKeywordBidResultOn(
            String assertMessage,
            String login,
            ServiceNames serviceName,
            Action action,
            T args,
            KeywordBidExpectedResult... expectedResults)
    {
        Object response = defaultClientV5().invokeMethod(serviceName, login, action, args.getBean());
        ArrayList<KeywordBidActionResult> actualResult = extractActionResults(response, action);
        checkKeywordBidActionResults(assertMessage, actualResult, expectedResults);
    }

    public void shouldGetJSONErrorOnBidsSet(Object parameters, String login, Api5Error api5Error) {
        shouldGetJSONErrorOn(ServiceNames.KEYWORD_BIDS, login, Action.SET, parameters, api5Error);
    }

    public GetResponse bidsGetByKeywordIdsWithFields(List<KeywordBidFieldEnum> fields, Long... keywordIds) {
        return keywordBidsGet(
                new GetRequestMap().withSelectionCriteria(
                        new KeywordBidsSelectionCriteriaMap().withKeywordIds(keywordIds)
                ).withFieldNames(fields.toArray(new KeywordBidFieldEnum[fields.size()]))
        );
    }

    private void checkKeywordBidActionResults(
            String message, List<KeywordBidActionResult> actualResults, KeywordBidExpectedResult... expectedResults)
    {
        List<Matcher<? super KeywordBidActionResult>> expectedMatchers = new ArrayList<>();

        for (KeywordBidExpectedResult expResult : expectedResults) {
            expectedMatchers.add(BeanEquals.beanEquals((KeywordBidActionResult) expResult.getBean())
                    .accordingStrategy(expResult.getActionResultCompareStrategy())
            );
        }

        Matcher<Iterable<? extends KeywordBidActionResult>> resultMatcher = contains(expectedMatchers);
        assertThat(message, actualResults, resultMatcher);
    }

    //JSON

    public <T> void shouldGetBidResultOnJson(Action action,
            String login,
            T args,
            KeywordBidExpectedResult... expectedResults)
    {
        shouldGetBidResultOnJson(ServiceNames.KEYWORD_BIDS, login, action, args, expectedResults);
    }

    @Step("Проверяем ID/Warnings/Errors в ответе сервиса")
    protected <T> Object shouldGetBidResultOnJson(
            ServiceNames serviceName, String login, Action action, T args, KeywordBidExpectedResult... expectedResults)
    {
        Object response = jsonClientV5().invokeMethod(serviceName, login, action, args);
        ArrayList<KeywordBidActionResult> actualResult = extractActionResults(response, action);
        checkKeywordBidActionResults("", actualResult, expectedResults);
        return response;
    }

}
