package ru.yandex.autotests.directapi.steps.prices;

import java.util.List;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.apiclient.RequestHeader;
import ru.yandex.autotests.directapi.apiclient.config.ConnectionConfig;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.exceptions.DirectAPIException;
import ru.yandex.autotests.directapi.model.prices.AutoPriceInfoMap;
import ru.yandex.autotests.directapi.model.prices.BannersType;
import ru.yandex.autotests.directapi.model.prices.PhrasePriceInfoMap;
import ru.yandex.autotests.directapi.model.prices.PriceBase;
import ru.yandex.autotests.directapi.steps.BaseApiSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ch.lambdaj.Lambda.convert;

/**
 * Created with IntelliJ IDEA.
 * User: pavryabov
 * Date: 20.09.13
 * Time: 9:33
 * To change this template use File | Settings | File Templates.
 */
public class PricesSteps extends BaseApiSteps {

    private static PricesSteps _instance;

    private PricesSteps(ConnectionConfig connectionConfig, RequestHeader requestHeader) {
        super(connectionConfig, requestHeader);
    }

    public static PricesSteps getInstance(ConnectionConfig connectionConfig, RequestHeader requestHeader) {
        if (_instance == null) {
            _instance = new PricesSteps(connectionConfig, requestHeader);
        } else {
            _instance.setConnectionConfig(connectionConfig);
            _instance.setRequestHeader(requestHeader);
        }
        return _instance;

    }

    @Step(value = "[SetAutoPrice]")
    public <T> T[] setAutoPrice(AutoPriceInfoMap autoPriceInfo) {
        return (T[]) defaultClient().invokeMethod(Method.SET_AUTO_PRICE, autoPriceInfo.getBean());
    }

    public <T> T[] setAutoPriceSingle(Long[] bannerIDS, float price) {
        try {
            return (T[]) setAutoPrice(new AutoPriceInfoMap(jsonClient().getPackageName()).withSinglePriceMode()
                    .withBannersType(BannersType.ALL)
                    .withBannerIDS(bannerIDS).withPrice(price));
        } catch (AxisError axisFault) {
            throw new DirectAPIException("Ошибка установки ставок", axisFault);
        }
    }

    public <T> T[] setAutoPriceSingleMode(int campaignID, float price) {
        try {
            return (T[]) setAutoPrice(new AutoPriceInfoMap(jsonClient().getPackageName()).withSinglePriceMode()
                    .withCampaignID(campaignID).withPrice(price));
        } catch (AxisError axisFault) {
            throw new DirectAPIException("Ошибка установки ставок", axisFault);
        }
    }

    public <T> T[] setAutoPriceSingle(int campaignID, Long bannerID, float price) {
        return setAutoPriceSingle(campaignID, bannerID, price, null);
    }

    public <T> T[] setAutoPriceSingle(int campaignID, Long bannerID, float price, String currency) {
        try {
            return (T[]) setAutoPrice(new AutoPriceInfoMap(jsonClient().getPackageName())
                    .withSinglePriceMode().withBannersType(BannersType.ALL)
                    .withBannerIDS(bannerID).withCampaignID(campaignID).withPrice(price).withCurrency(currency));
        } catch (AxisError axisFault) {
            throw new DirectAPIException("Ошибка установки ставок", axisFault);
        }
    }

    public <T> T[] setAutoPriceSingleForCampaign(int campaignID, float price) {
        return (T[]) setAutoPrice(new AutoPriceInfoMap(jsonClient().getPackageName())
                .withSinglePriceMode().withBannersType(BannersType.ALL)
                .withCampaignID(campaignID).withPrice(price));
    }

    public void shouldGetErrorOnSetAutoPriceSingleForCampaign(AxisError axisError, int campaignID, float price) {
        shouldGetErrorOn(
                Method.SET_AUTO_PRICE,
                new AutoPriceInfoMap(jsonClient().getPackageName())
                        .withSinglePriceMode().withBannersType(BannersType.ALL)
                        .withCampaignID(campaignID).withPrice(price),
                axisError
        );
    }

    public <T> T[] setAutoPriceWizard(int campaignID, Long[] bannerIDS) {
        try {
            return (T[]) setAutoPrice(new AutoPriceInfoMap(jsonClient().getPackageName())
                    .withWizardMode().withBannersType(BannersType.ALL)
                    .withPriceBase(PriceBase.MAX).withCampaignID(campaignID).withBannerIDS(bannerIDS));
        } catch (AxisError axisFault) {
            throw new DirectAPIException("Ошибка установки ставок", axisFault);
        }
    }

    public <T> T[] setAutoPriceWizard(int campaignID, Long bannerID) {
        try {
            return (T[]) setAutoPrice(new AutoPriceInfoMap(jsonClient().getPackageName())
                    .withWizardMode().withBannersType(BannersType.ALL)
                    .withPriceBase(PriceBase.MAX).withCampaignID(campaignID).withBannerIDS(bannerID));
        } catch (AxisError axisFault) {
            throw new DirectAPIException("Ошибка установки ставок", axisFault);
        }
    }

    public <T> T[] setAutoPriceWizardForCampaign(int campaignID) {
        return (T[]) setAutoPrice(new AutoPriceInfoMap(jsonClient().getPackageName())
                .withWizardMode().withBannersType(BannersType.ALL)
                .withPriceBase(PriceBase.MAX).withCampaignID(campaignID));
    }

    public void shouldGetErrorOnSetAutoPriceWizardForCampaign(AxisError axisError, int campaignID) {
        shouldGetErrorOn(
                Method.SET_AUTO_PRICE,
                new AutoPriceInfoMap(jsonClient().getPackageName())
                        .withWizardMode().withBannersType(BannersType.ALL)
                        .withPriceBase(PriceBase.MAX).withCampaignID(campaignID),
                axisError
        );
    }


    @Step(value = "[UpdatePrices]")
    public int updatePrices(PhrasePriceInfoMap... phrasePriceInfo) {
        List<Object> phrasePriceInfos = convert(phrasePriceInfo, new BeanMapToBeanConverter());
        return defaultClient().invokeMethod(Method.UPDATE_PRICES, phrasePriceInfos.toArray());
    }

    public void updatePrices(int campaignID, long phraseID, float price) {
        updatePrices(new PhrasePriceInfoMap(jsonClient().getPackageName())
                .withCampaignID(campaignID)
                .withPhraseID(phraseID)
                .withPrice(price));
    }

    public void updatePrices(int campaignID, long phraseID, float price, Currency currency) {
        updatePrices(new PhrasePriceInfoMap(jsonClient().getPackageName())
                .withCampaignID(campaignID)
                .withPhraseID(phraseID)
                .withPrice(price)
                .withCurrency(currency));
    }

    public void updateContextPrices(int campaignID, long phraseID, float contextPrice, Currency currency) {
        updatePrices(new PhrasePriceInfoMap(jsonClient().getPackageName())
                .withCampaignID(campaignID)
                .withPhraseID(phraseID)
                .withContextPrice(contextPrice)
                .withCurrency(currency));
    }
}

