package ru.yandex.autotests.directapi.steps.sandbox;

import ru.yandex.autotests.direct.httpclient.UserSteps;
import ru.yandex.autotests.direct.httpclient.core.DirectResponse;
import ru.yandex.autotests.direct.httpclient.data.sandbox.APISandboxClientTypeEnum;
import ru.yandex.autotests.direct.httpclient.data.sandbox.SandboxResponseBean;
import ru.yandex.autotests.direct.utils.clients.blackbox.PassportUserInfo;
import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.apiclient.RequestHeader;
import ru.yandex.autotests.directapi.apiclient.config.ConnectionConfig;
import ru.yandex.autotests.directapi.darkside.model.SandboxSettings;
import ru.yandex.autotests.directapi.exceptions.DirectAPIException;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.steps.BaseApiSteps;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static org.hamcrest.core.IsEqual.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;


/**
 * Created by chicos on 21.05.14.
 */
public class SandboxSteps extends BaseApiSteps {
    public static final String ERROR_EMPTY_SANDBOX_TOKEN = "Вернулся пустой sandbox token.";

    private LogSteps log = LogSteps.getLogger(this.getClass());

    private static SandboxSteps _instance;

    private UserSteps userSteps;

    private SandboxSteps(ConnectionConfig connectionConfig, RequestHeader requestHeader) {
        super(connectionConfig, requestHeader);
        userSteps = new UserSteps(properties);
        userSteps.getConfig().getClientConfig().host(DirectTestRunProperties.getInstance()
                .resolveDirectStageTypeToHost(properties.getDirectApiSandboxUiStage()).replace("https://", ""));
    }

    public static SandboxSteps getInstance(ConnectionConfig connectionConfig, RequestHeader requestHeader) {
        ConnectionConfig modifiedConfig = connectionConfig.clone();
        if (_instance == null) {
            _instance = new SandboxSteps(modifiedConfig, requestHeader);
        } else {
            _instance.setConnectionConfig(modifiedConfig);
            _instance.setRequestHeader(requestHeader);
        }
        return _instance;
    }

    @Step("Инициализация песочницы: login {0}, type {1}, initData {2}")
    public void enableSandbox(String login, APISandboxClientTypeEnum clientType, boolean initTestData) {
        enableSandbox(login, clientType, initTestData, Currency.RUB, false);
    }

    @Step("Инициализация песочницы: login {0}, type {1}, initData {2}")
    public void enableSandbox(
            String login,
            APISandboxClientTypeEnum clientType,
            boolean initTestData,
            Currency initialCurrency,
            boolean enableSharedAccount)
    {
        User user = User.get(login);
        userSteps.onPassport().authoriseAs(login, user.getPassword());
        DirectResponse response = userSteps.apiSandboxSteps()
                .startUseSandboxAPI(clientType, initTestData, initialCurrency, enableSharedAccount);
        assumeThat("Не удалось инициировать песочницу для пользователя " + login,
                response.getStatusLine().getStatusCode(), equalTo(200));

        user.setSandboxToken(
                extractSandboxToken(response.getResponseContent().toString()));

        user.saveInMongo();
        log.info("Обновлен sandbox token пользователя " + login);
    }

    @Step("Инициализация песочницы: login {0}, type {1}, initData {2}")
    public void enableSandboxByApi(String login, APISandboxClientTypeEnum clientType, boolean initTestData) {
        enableSandboxByApi(login, clientType, initTestData, Currency.RUB, false);
    }

    @Step("Инициализация песочницы c помощью Api: login {0}, type {1}, initData {2}, currency {3}, sharedAccount {4}")
    public void enableSandboxByApi(
            String login,
            APISandboxClientTypeEnum clientType,
            boolean initTestData,
            Currency initialCurrency,
            boolean enableSharedAccount)
    {
        User user = User.get(login);

        ApiSteps api = new ApiSteps().as(login);

        PassportUserInfo userInfo = api.userSteps.getDarkSideSteps()
                .getBlackboxSteps()
                .getUserInfoByLogin(login);

        SandboxSettings settings = new SandboxSettings(
                clientType.getClientType(),
                initialCurrency.value(),
                initTestData,
                enableSharedAccount);

        String sandboxToken = api.userSteps.getDarkSideSteps()
                .getSandboxServiceSteps()
                .create(userInfo, settings);
        if (sandboxToken == null) {
            throw new DirectAPIException(ERROR_EMPTY_SANDBOX_TOKEN);
        }

        user.setSandboxToken(sandboxToken);
        user.saveInMongo();
        log.info("Обновлен sandbox token пользователя " + login);
    }

    @Step("Остановка песочницы: login {0}")
    public void closeSandbox(String login) {
        User user = User.get(login);
        userSteps.onPassport().authoriseAs(login, user.getPassword());
        DirectResponse response = userSteps.apiSandboxSteps().stopUseSandboxAPI();
        assumeThat("удалось закрыть песочницу для пользователя " + login,
                response.getStatusLine().getStatusCode(), equalTo(200));

    }

    @Step("Остановка песочницы c помощью Api: login {0}")
    public void closeSandboxByApi(String login) {
        ApiSteps api = new ApiSteps().as(login);

        PassportUserInfo userInfo = api.userSteps.getDarkSideSteps()
                .getBlackboxSteps()
                .getUserInfoByLogin(login);

        api.userSteps.getDarkSideSteps()
                .getSandboxServiceSteps()
                .drop(userInfo.getUid());
    }

    private String extractSandboxToken(String responseContent) {
        try {
            String sandboxToken = SandboxResponseBean.readJson(responseContent)
                    .getCurrentSandboxState()
                    .getMasterToken();
            if (sandboxToken == null) {
                throw new DirectAPIException(ERROR_EMPTY_SANDBOX_TOKEN);
            }
            return sandboxToken;
        } catch (RuntimeException ex) {
            throw new DirectAPIException("Не удалось извлечь sandbox token. ", ex);
        }
    }
}
