package ru.yandex.autotests.directapi.utils;

import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5JsonError;
import ru.yandex.autotests.directapi.apiclient.errors.Api5JsonErrorMatcher;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

public class AccessRightsErrorHelper {
    /**
     * Метод ловит ошибки доступа для Java, поскольку отлуп в этом случае идет на весь запрос, что
     * отличается от поведения перла
     *
     * @param expectedError Ожидаемая ошибка от Java
     * @param perlCheck     Проверка для Perl
     */
    public static void checkCatchingJavaAccessError(Api5Error expectedError, Runnable perlCheck) {
        try {
            perlCheck.run();
        } catch (Api5JsonError jsonError) {
            // Java версия сервиса возвращает ошибку доступа на весь запрос
            if (expectedError == null) {
                throw new AssertionError("неожиданная ошибка", jsonError);
            }
            assertThat("совпал текст ошибки (JSON)", jsonError,
                    Api5JsonErrorMatcher.equalToIgnoreLocale(expectedError.toJsonError()));
        }
    }
}
