package ru.yandex.autotests.directapi.utils;

/**
 * Created by gerdler on 29.11.16.
 */
public class CallerUtils {
    /**
     * Возвращает строку с названием вызывающего (в контексте места вызова getCallerClassAndMethodNames())
     * класса и метода в виде "ClassName.MethodName"
     */
    public static String getCallerClassAndMethodNames() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        String reflectionPackage = "sun.reflect";
        int i = 0;
        while (i < stackTrace.length && !stackTrace[i].getClassName().startsWith(reflectionPackage)) {
            i++;
        }
        String info = "";
        if (i < stackTrace.length) {
            i--;
            while (i >= 0 && stackTrace[i].getMethodName().matches("<.*>")) {
                i--;
            }
            if (i >= 0) {
                String[] classFullName = stackTrace[i].getClassName().split("\\.");
                String className = classFullName[classFullName.length - 1];
                String methodName = stackTrace[i].getMethodName();
                info = className + "." + methodName;
            }
        }
        return info;
    }
}
