package ru.yandex.autotests.directapi.utils;

import ru.yandex.autotests.direct.utils.DirectUtilsException;

/**
 * Created by buhter on 05/02/16.
 */
public class ErrorTextUtils {
    public static final int DEFAULT_PARAMETER_LENGTH = 200;

    /**
     * Укорачивает textParameter для ошибки до parameterLength символов и добавляет многоточие
     * По возможности обрезает по границе слова
     */
    public static String getShortTextParameter(String textParameter, int parameterLength) {
        if (textParameter == null) {
            throw new DirectUtilsException("Нельзя укоротить null");
        }
        if (textParameter.length() < parameterLength) {
            return textParameter;
        }

        String truncatedText = textParameter.substring(0, parameterLength - 1);
        int lastSpaceIndex = truncatedText.lastIndexOf(" ");

        if (lastSpaceIndex != -1) {
            truncatedText = truncatedText.substring(0, lastSpaceIndex);
        }

        return truncatedText + "...";
    }


    /**
     * Укорачивает textParameter для ошибки до 200 символов и добавляет многоточие
     */
    public static String getShortTextParameter(String textParameter) {
        return getShortTextParameter(textParameter, DEFAULT_PARAMETER_LENGTH);
    }
}
