package ru.yandex.autotests.directapi.utils;

import java.io.IOException;
import java.net.URL;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

import ru.yandex.autotests.directapi.exceptions.DirectAPIException;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;

/**
 * Created by ginger on 25.04.16.
 */
public class ImageBase64Utils {
    private static Logger log4j = LogManager.getLogger(ImageBase64Utils.class);

    public static byte[] getBase64EncodedFileData(String url) {
        log4j.info("Формирование base64 для картинки " + url);
        int tries = 0;
        while (tries < 3) {
            try {
                return Base64.encodeBase64(IOUtils.toByteArray(new URL(url).openStream()));
            } catch (IOException e) {
                log4j.info(JsonUtils.toString(e));
            }
            tries++;
        }
        throw new DirectAPIException("Ошибка чтения картинки");
    }

    public static byte[] getFileData(String url) {
        log4j.info("Формирование массива байтов из картинки " + url);
        int tries = 0;
        while (tries < 3) {
            try {
                return IOUtils.toByteArray(new URL(url).openStream());
            } catch (IOException e) {
                log4j.info(JsonUtils.toString(e));
            }
            tries++;
        }
        throw new DirectAPIException("Ошибка чтения картинки");
    }

}
