package ru.yandex.autotests.direct.fakebsproxy.beans;


import java.net.URI;
import java.util.*;

/**
 * Created by buhter on 29/07/15.
 */
public class FakeBSProxyLogBean extends BaseBean<FakeBSProxyLogBean>{
    private String requestUUID;
    private Long requestTime;
    private List<Object> objectIds;
    private Map<String, String> headers;
    private String requestEntity;
    private String responseEntity;
    private URI proxyURI;

    public FakeBSProxyLogBean(){
        this.requestUUID = null;
        this.requestTime = null;
        this.objectIds = new ArrayList<>();
        this.headers = new HashMap<>();
        this.requestEntity = null;
        this.responseEntity = null;
        this.proxyURI = null;
    }

    public FakeBSProxyLogBean(FakeBSProxyLogBean preloadedLogBean) {
        this.requestUUID = preloadedLogBean.requestUUID;
        this.requestTime = preloadedLogBean.requestTime;
        this.objectIds = preloadedLogBean.objectIds;
        this.headers = preloadedLogBean.headers;
        this.requestEntity = preloadedLogBean.requestEntity;
        this.responseEntity = preloadedLogBean.responseEntity;
        this.proxyURI = preloadedLogBean.proxyURI;
    }
    
    public String getRequestUUID() {
        return requestUUID;
    }

    public void setRequestUUID(String requestUUID) {
        this.requestUUID = requestUUID;
    }

    public Long getRequestTime() {
        return requestTime;
    }

    public void setRequestTime(Long requestTime) {
        this.requestTime = requestTime;
    }

    public Map<String, String> getHeaders() {
        return headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public String getRequestEntity() {
        return requestEntity;
    }

    public void setRequestEntity(String requestEntity) {
        this.requestEntity = requestEntity;
    }

    public String getResponseEntity() {
        return responseEntity;
    }

    public void setResponseEntity(String responseEntity) {
        this.responseEntity = responseEntity;
    }

    public List<Object> getObjectIds() {
        return objectIds;
    }

    public void setObjectIds(List<Object> objectIds) {
        this.objectIds = objectIds;
    }

    public URI getProxyURI() {
        return proxyURI;
    }

    public void setProxyURI(URI proxyURI) {
        this.proxyURI = proxyURI;
    }

    public FakeBSProxyLogBean withRequestUUID(String requestUUID) {
        this.requestUUID = requestUUID;
        return this;
    }

    public FakeBSProxyLogBean withRequestTime(Long requestTime) {
        this.requestTime = requestTime;
        return this;
    }

    public FakeBSProxyLogBean withHeaders(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public FakeBSProxyLogBean withRequestEntity(String requestEntity) {
        this.requestEntity = requestEntity;
        return this;
    }

    public FakeBSProxyLogBean withResponseEntity(String responseEntity) {
        this.responseEntity = responseEntity;
        return this;
    }

    public FakeBSProxyLogBean withObjectIds(List<Object> objectIds) {
        this.objectIds = objectIds;
        return this;
    }
    public FakeBSProxyLogBean withObjectIds(Object... objectIds) {
        this.objectIds = Arrays.asList(objectIds);
        return this;
    }


}
