package ru.yandex.autotests.direct.fakebsproxy.beans.moderate;

import com.google.gson.annotations.SerializedName;
import ru.yandex.autotests.direct.fakebsproxy.beans.BaseBean;

public class CanvasData extends BaseBean<CanvasData> {
    @SerializedName("preview_url")
    private String previewUrl;
    @SerializedName("creative_id")
    private Long creativeId;
    @SerializedName("width")
    private Integer width;
    @SerializedName("height")
    private Integer height;
    @SerializedName("creative_json")
    private String creativeJson;

    public String getPreviewUrl() {
        return previewUrl;
    }

    public Long getCreativeId() {
        return creativeId;
    }

    public Integer getWidth() {
        return width;
    }

    public Integer getHeight() {
        return height;
    }

    public String getCreativeJson() {
        return creativeJson;
    }

    public void setPreviewUrl(String previewUrl) {
        this.previewUrl = previewUrl;
    }

    public void setCreativeId(Long creativeId) {
        this.creativeId = creativeId;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public void setCreativeJson(String creativeJson) {
        this.creativeJson = creativeJson;
    }

    public CanvasData withPreviewUrl(String previewUrl) {
        this.previewUrl = previewUrl;
        return this;
    }

    public CanvasData withCreativeId(Long creativeId) {
        this.creativeId = creativeId;
        return this;
    }

    public CanvasData withWidth(Integer width) {
        this.width = width;
        return this;
    }

    public CanvasData withHeight(Integer height) {
        this.height = height;
        return this;
    }

    public CanvasData withCreativeJson(String creativeJson) {
        this.creativeJson = creativeJson;
        return this;
    }

}