package ru.yandex.autotests.direct.fakebsproxy.beans.moderate;

import com.google.gson.annotations.SerializedName;
import ru.yandex.autotests.direct.fakebsproxy.beans.BaseBean;

public class ImageData extends BaseBean<ImageData> {

    @SerializedName("md5")
    private String md5;

    @SerializedName("name")
    private String name;            //заполняется только для старой аватарницы

    @SerializedName("image_id")
    private Long imageId;          //заполняется только для старой аватарницы

    @SerializedName("file")
    private String file;

    @SerializedName("date_added")
    private String dateAdded;      //заполняется только для старой аватарницы

    @SerializedName("image_hash")
    private String imageHash;

    @SerializedName("image_source_hash")
    private String imageSourceHash; //заполняется только для старой аватарницы

    @SerializedName("mds_group_id")
    private String mdsGroupId;      //только для новой аватарницы

    @SerializedName("namespace")
    private String namespace;       //только для новой аватарницы

    @SerializedName("host")
    private String host;            //только для новой аватарницы

    public String getMd5() {
        return md5;
    }

    public String getName() {
        return name;
    }

    public Long getImageId() {
        return imageId;
    }

    public String getFile() {
        return file;
    }

    public String getDateAdded() {
        return dateAdded;
    }

    public String getImageHash() {
        return imageHash;
    }

    public String getImageSourceHash() {
        return imageSourceHash;
    }

    public String getMdsGroupId() {
        return mdsGroupId;
    }

    public String getNamespace() {
        return namespace;
    }

    public String getHost() {
        return host;
    }

    public void setMd5(String md5) {
        this.md5 = md5;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setImageId(Long imageId) {
        this.imageId = imageId;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public void setDateAdded(String dateAdded) {
        this.dateAdded = dateAdded;
    }

    public void setImageHash(String imageHash) {
        this.imageHash = imageHash;
    }

    public void setImageSourceHash(String imageSourceHash) {
        this.imageSourceHash = imageSourceHash;
    }

    public void setMdsGroupId(String mdsGroupId) {
        this.mdsGroupId = mdsGroupId;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public ImageData withMd5(String md5) {
        this.md5 = md5;
        return this;
    }

    public ImageData withName(String name) {
        this.name = name;
        return this;
    }

    public ImageData withImageId(Long imageId) {
        this.imageId = imageId;
        return this;
    }

    public ImageData withFile(String file) {
        this.file = file;
        return this;
    }

    public ImageData withDateAdded(String dateAdded) {
        this.dateAdded = dateAdded;
        return this;
    }

    public ImageData withImageHash(String imageHash) {
        this.imageHash = imageHash;
        return this;
    }

    public ImageData withImageSourceHash(String imageSourceHash) {
        this.imageSourceHash = imageSourceHash;
        return this;
    }

    public ImageData withMdsGroupId(String mdsGroupId) {
        this.mdsGroupId = mdsGroupId;
        return this;
    }

    public ImageData withNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public ImageData withHost(String host) {
        this.host = host;
        return this;
    }
}