
package ru.yandex.autotests.direct.fakebsproxy.beans.moderate;

import java.util.ArrayList;
import java.util.List;

import com.google.gson.annotations.SerializedName;

import ru.yandex.autotests.direct.fakebsproxy.beans.BaseBean;
import ru.yandex.autotests.direct.fakebsproxy.beans.moderate.enums.ModerationBannerTypeEnum;
import ru.yandex.autotests.direct.fakebsproxy.beans.moderate.enums.ModerationCampaignTypeEnum;
import ru.yandex.autotests.direct.fakebsproxy.beans.moderate.enums.ModerationObjectTypeEnum;

public class PutRecordsParam extends BaseBean<PutRecordsParam> {

    @SerializedName("type")
    private ModerationObjectTypeEnum type;
    @SerializedName("id")
    private Long id;
    @SerializedName("client_id")
    private Long clientId;
    @SerializedName("uid")
    private Long uid;
    @SerializedName("cid")
    private Long cid;
    @SerializedName("pid")
    private Long pid;
    @SerializedName("bid")
    private Long bid;
    @SerializedName("data")
    private Object data;
    @SerializedName("auto_moderate")
    private Integer autoModerate;
    @SerializedName("userPostModerate")
    private String userPostModerate;
    @SerializedName("statusPostModerate")
    private String statusPostModerate;
    @SerializedName("user_features")
    private UserFeatures userFeatures;
    @SerializedName("statusServicing")
    private String statusServicing;
    @SerializedName("statusModerate")
    private String statusModerate;
    @SerializedName("typeCampaign")
    private ModerationCampaignTypeEnum typeCampaign;
    @SerializedName("banner_type")
    private ModerationBannerTypeEnum bannerType;
    @SerializedName("re-moderation")
    private Integer reModeration;
    @SerializedName("goodUserDirectFlag")
    private String goodUserDirectFlag;
    @SerializedName("dynamic")
    private Integer dynamic;
    @SerializedName("export_version")
    private String exportVersion;
    @SerializedName("mobile")
    private Integer mobile;
    @SerializedName("content_id")
    private Long contentId;
    @SerializedName("callout_id")
    private Long calloutId;


    public ModerationObjectTypeEnum getType() {
        return type;
    }

    public void setType(ModerationObjectTypeEnum type) {
        this.type = type;
    }

    public PutRecordsParam withType(ModerationObjectTypeEnum type) {
        this.type = type;
        return this;
    }

    public Long getClientId() {
        return clientId;
    }

    public void setClientId(Long clientId) {
        this.clientId = clientId;
    }

    public PutRecordsParam withClientId(Long clientId) {
        this.clientId = clientId;
        return this;
    }

    public Object getData() {
        return data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public PutRecordsParam withData(Object data) {
        this.data = data;
        return this;
    }

    public Integer getAutoModerate() {
        return autoModerate;
    }

    public void setAutoModerate(Integer autoModerate) {
        this.autoModerate = autoModerate;
    }

    public PutRecordsParam withAutoModerate(Integer autoModerate) {
        this.autoModerate = autoModerate;
        return this;
    }

    public String getUserPostModerate() {
        return userPostModerate;
    }

    public void setUserPostModerate(String userPostModerate) {
        this.userPostModerate = userPostModerate;
    }

    public PutRecordsParam withUserPostModerate(String userPostModerate) {
        this.userPostModerate = userPostModerate;
        return this;
    }

    public String getStatusPostModerate() {
        return statusPostModerate;
    }

    public void setStatusPostModerate(String statusPostModerate) {
        this.statusPostModerate = statusPostModerate;
    }

    public PutRecordsParam withStatusPostModerate(String statusPostModerate) {
        this.statusPostModerate = statusPostModerate;
        return this;
    }

    public UserFeatures getUserFeatures() {
        return userFeatures;
    }

    public void setUserFeatures(UserFeatures userFeatures) {
        this.userFeatures = userFeatures;
    }

    public PutRecordsParam withUserFeatures(UserFeatures userFeatures) {
        this.userFeatures = userFeatures;
        return this;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public PutRecordsParam withId(Long id) {
        this.id = id;
        return this;
    }

    public String getStatusServicing() {
        return statusServicing;
    }

    public void setStatusServicing(String statusServicing) {
        this.statusServicing = statusServicing;
    }

    public PutRecordsParam withStatusServicing(String statusServicing) {
        this.statusServicing = statusServicing;
        return this;
    }

    public Long getCid() {
        return cid;
    }

    public void setCid(Long cid) {
        this.cid = cid;
    }

    public PutRecordsParam withCid(Long cid) {
        this.cid = cid;
        return this;
    }

    public Long getUid() {
        return uid;
    }

    public void setUid(Long uid) {
        this.uid = uid;
    }

    public PutRecordsParam withUid(Long uid) {
        this.uid = uid;
        return this;
    }

    public String getStatusModerate() {
        return statusModerate;
    }

    public void setStatusModerate(String statusModerate) {
        this.statusModerate = statusModerate;
    }

    public PutRecordsParam withStatusModerate(String statusModerate) {
        this.statusModerate = statusModerate;
        return this;
    }

    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    public PutRecordsParam withPid(Long pid) {
        this.pid = pid;
        return this;
    }

    public ModerationCampaignTypeEnum getTypeCampaign() {
        return typeCampaign;
    }

    public void setTypeCampaign(ModerationCampaignTypeEnum typeCampaign) {
        this.typeCampaign = typeCampaign;
    }

    public PutRecordsParam withTypeCampaign(ModerationCampaignTypeEnum typeCampaign) {
        this.typeCampaign = typeCampaign;
        return this;
    }

    public Integer getReModeration() {
        return reModeration;
    }

    public void setReModeration(Integer reModeration) {
        this.reModeration = reModeration;
    }

    public PutRecordsParam withReModeration(Integer reModeration) {
        this.reModeration = reModeration;
        return this;
    }

    public String getGoodUserDirectFlag() {
        return goodUserDirectFlag;
    }

    public void setGoodUserDirectFlag(String goodUserDirectFlag) {
        this.goodUserDirectFlag = goodUserDirectFlag;
    }

    public PutRecordsParam withGoodUserDirectFlag(String goodUserDirectFlag) {
        this.goodUserDirectFlag = goodUserDirectFlag;
        return this;
    }

    public Integer getDynamic() {
        return dynamic;
    }

    public void setDynamic(Integer dynamic) {
        this.dynamic = dynamic;
    }

    public PutRecordsParam withDynamic(Integer dynamic) {
        this.dynamic = dynamic;
        return this;
    }

    public String getExportVersion() {
        return exportVersion;
    }

    public void setExportVersion(String exportVersion) {
        this.exportVersion = exportVersion;
    }

    public PutRecordsParam withExportVersion(String exportVersion) {
        this.exportVersion = exportVersion;
        return this;
    }

    public Integer getMobile() {
        return mobile;
    }

    public void setMobile(Integer mobile) {
        this.mobile = mobile;
    }

    public PutRecordsParam withMobile(Integer mobile) {
        this.mobile = mobile;
        return this;
    }

    public Long getBid() {
        return bid;
    }

    public void setBid(Long bid) {
        this.bid = bid;
    }

    public PutRecordsParam withBid(Long bid) {
        this.bid = bid;
        return this;
    }

    public Long getContentId() {
        return contentId;
    }

    public void setContentId(Long contentId) {
        this.contentId = contentId;
    }

    public PutRecordsParam withContentId(Long contentId) {
        this.contentId = contentId;
        return this;
    }

    public Long getCalloutId() {
        return calloutId;
    }

    public void setCalloutId(Long calloutId) {
        this.calloutId = calloutId;
    }

    public PutRecordsParam withCalloutId(Long calloutId) {
        this.calloutId = calloutId;
        return this;
    }

    public ModerationBannerTypeEnum getBannerType() {
        return bannerType;
    }

    public void setBannerType(ModerationBannerTypeEnum bannerType) {
        this.bannerType = bannerType;
    }

    public PutRecordsParam withBannerType(ModerationBannerTypeEnum bannerType) {
        this.bannerType = bannerType;
        return this;
    }

    public <T> T getDeserializedData() {
        switch (this.getType()) {
            case BANNER:
                return (T) new BannerData().fromString(GSON.toJson(this.getData()));
            case CALLOUT:
                return (T) new CalloutData().fromString(GSON.toJson(this.getData()));
            case CAMPAIGN:
                return (T) new CampaignData().fromString(GSON.toJson(this.getData()));
            case CONTACTINFO:
                return (T) new ContactInfoData().fromString(GSON.toJson(this.getData()));
            case DISPLAY_HREF:
                return (T) new DisplayHrefData().fromString(GSON.toJson(this.getData()));
            case IMAGE:
                return (T) new ImageData().fromString(GSON.toJson(this.getData()));
            case IMAGE_AD:
                return (T) new ImageAdData().fromString(GSON.toJson(this.getData()));
            case CANVAS:
                return (T) new CanvasData().fromString(GSON.toJson(this.getData()));
            case HTML5:
                return (T) new HTML5Data().fromString(GSON.toJson(this.getData()));
            case VIDEO_ADDITION:
                return (T) new VideoAdditionData().fromString(GSON.toJson(this.getData()));
            case MOBILE_CONTENT:
                return (T) new MobileContentData().fromString(GSON.toJson(this.getData()));
            case PHRASES:
                return (T) new PhrasesData().fromString(GSON.toJson(this.getData()));
            case SITELINKS_SET:
                List<SitelinksSetData> sitelinksSetDataList = new ArrayList<>();
                for (Object o : GSON.fromJson(GSON.toJson(this.getData()), List.class)) {
                    sitelinksSetDataList.add(new SitelinksSetData().fromString(GSON.toJson(o)));
                }
                return (T) sitelinksSetDataList;
            default:
                return null;
        }
    }

}
