package ru.yandex.autotests.direct.fakebsproxy.beans.moderate;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import com.google.gson.annotations.SerializedName;

import ru.yandex.autotests.direct.fakebsproxy.beans.BaseBean;
import ru.yandex.autotests.direct.fakebsproxy.beans.moderate.enums.ModerationMethodEnum;

public class Request extends BaseBean<Request> {

    @SerializedName("version")
    private String version;
    @SerializedName("params")
    private List<Object> params;
    @SerializedName("id")
    private Long id;
    @SerializedName("method")
    private ModerationMethodEnum method;

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Request withVersion(String version) {
        this.version = version;
        return this;
    }

    public List<Object> getParams() {
        return params;
    }

    public void setParams(List<Object> params) {
        this.params = params;
    }

    public Request withParams(List<Object> params) {
        this.params = params;
        return this;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Request withId(Long id) {
        this.id = id;
        return this;
    }

    public ModerationMethodEnum getMethod() {
        return method;
    }

    public void setMethod(ModerationMethodEnum method) {
        this.method = method;
    }

    public Request withMethod(ModerationMethodEnum method) {
        this.method = method;
        return this;
    }

    public List getDeserealizedParams() {
        switch (this.method) {
            case PUT_RECORDS:
                return this.getParams().stream().filter(param -> param instanceof List)
                        .map(param -> (List) param).flatMap(List::stream)
                        .map(GSON::toJson).map(o -> GSON.fromJson(o, PutRecordsParam.class))
                        .collect(Collectors.toList());
            case PROCESS_MAGIC_QUEUE:
                return this.getParams().stream().filter(param -> param instanceof List)
                        .map(param -> (List) param).flatMap(List::stream)
                        .map(GSON::toJson).map(o -> GSON.fromJson(o, ProcessMagicQueueParam.class))
                        .collect(Collectors.toList());
        }
        return null;
    }

}
