
package ru.yandex.autotests.direct.fakebsproxy.beans.moderate;

import com.google.gson.annotations.SerializedName;
import ru.yandex.autotests.direct.fakebsproxy.beans.BaseBean;
import ru.yandex.autotests.direct.fakebsproxy.beans.moderate.enums.ModerationUserPriorityEnum;

public class UserFeatures extends BaseBean<UserFeatures> {

    @SerializedName("passport_karma")
    private Integer passportKarma;

    @SerializedName("priority")
    private ModerationUserPriorityEnum priority;

    @SerializedName("createtime")
    private Long createTime;

    @SerializedName("discount")
    private Float discount;

    public Integer getPassportKarma() {
        return passportKarma;
    }

    public UserFeatures withPassportKarma(Integer passportKarma) {
        this.passportKarma = passportKarma;
        return this;
    }

    public ModerationUserPriorityEnum getPriority() {
        return priority;
    }

    public UserFeatures withPriority(ModerationUserPriorityEnum priority) {
        this.priority = priority;
        return this;
    }

    public Long getCreateTime() {
        return createTime;
    }

    public UserFeatures withCreateTime(Long createTime) {
        this.createTime = createTime;
        return this;
    }

    public Float getDiscount() {
        return discount;
    }

    public UserFeatures withDiscount(Float discount) {
        this.discount = discount;
        return this;
    }
}
