package ru.yandex.autotests.direct.fakebsproxy.beans.moderate;

import com.google.gson.annotations.SerializedName;

import ru.yandex.autotests.direct.fakebsproxy.beans.BaseBean;

public class VideoAdditionData extends BaseBean<VideoAdditionData> {

    @SerializedName("preview_url")
    private String previewUrl;

    @SerializedName("creative_id")
    private Long creativeId;

    @SerializedName("creative_json")
    private String creativeJson;

    public String getPreviewUrl() {
        return previewUrl;
    }

    public Long getCreativeId() {
        return creativeId;
    }

    public String getCreativeJson() {
        return creativeJson;
    }

    public void setPreviewUrl(String previewUrl) {
        this.previewUrl = previewUrl;
    }

    public void setCreativeId(Long creativeId) {
        this.creativeId = creativeId;
    }

    public void setCreativeJson(String creativeJson) {
        this.creativeJson = creativeJson;
    }

    public VideoAdditionData withPreviewUrl(String previewUrl) {
        this.previewUrl = previewUrl;
        return this;
    }

    public VideoAdditionData withCreativeId(Long creativeId) {
        this.creativeId = creativeId;
        return this;
    }

    public VideoAdditionData withCreativeJson(String creativeJson) {
        this.creativeJson = creativeJson;
        return this;
    }
}