package ru.yandex.autotests.direct.fakebsproxy.beans.ppccampgetgoals;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import ru.yandex.autotests.direct.fakebsproxy.beans.BaseBean;

/**
 * Created by buhter on 09/03/2017.
 */
public class OrderCounterGoalStatItemBean extends BaseBean<OrderCounterGoalStatItemBean> {
    public static final String ORDER_ID = "OrderID";
    public static final String GOAL_ID = "GoalID";
    public static final String ATTRIBUTION_TYPE = "AttributionType";
    public static final String SEARCH_GOALS_COUNT = "SearchGoalsCount";
    public static final String СONTEXT_GOALS_COUNT = "ContextGoalsCount";
    private static final Pattern PARSE_PATTERN = Pattern.compile("(\\d*)\t(\\d*)\t(\\d*)\t(.*)\t(\\d*)");
    private static final String TO_STRING_FORMAT = "%s\t%s\t%s\t%s\t%s\n";

    private Long orderId;
    private Long goalId;
    private Integer attributionType;
    private Integer searchGoalsCount;
    private Integer сontextGoalsCount;

    public Long getOrderId() {
        return orderId;
    }

    public OrderCounterGoalStatItemBean withOrderId(Long orderId) {
        this.orderId = orderId;
        return this;
    }

    public Long getGoalId() {
        return goalId;
    }

    public OrderCounterGoalStatItemBean withGoalId(Long goalId) {
        this.goalId = goalId;
        return this;
    }

    public Integer getAttributionType() {
        return attributionType;
    }

    public OrderCounterGoalStatItemBean withAttributionType(Integer attributionType) {
        this.attributionType = attributionType;
        return this;
    }

    public Integer getSearchGoalsCount() {
        return searchGoalsCount;
    }

    public OrderCounterGoalStatItemBean withSearchGoalsCount(Integer searchGoalsCount) {
        this.searchGoalsCount = searchGoalsCount;
        return this;
    }

    public Integer getСontextGoalsCount() {
        return сontextGoalsCount;
    }

    public OrderCounterGoalStatItemBean withСontextGoalsCount(Integer сontextGoalsCount) {
        this.сontextGoalsCount = сontextGoalsCount;
        return this;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }

    public void setGoalId(Long goalId) {
        this.goalId = goalId;
    }

    public void setAttributionType(Integer attributionType) {
        this.attributionType = attributionType;
    }

    public void setSearchGoalsCount(Integer searchGoalsCount) {
        this.searchGoalsCount = searchGoalsCount;
    }

    public void setСontextGoalsCount(Integer сontextGoalsCount) {
        this.сontextGoalsCount = сontextGoalsCount;
    }

    public OrderCounterGoalStatItemBean(Long orderId, Long goalId, Integer attributionType,
            Integer searchGoalsCount, Integer сontextGoalsCount)
    {
        this.orderId = orderId;
        this.goalId = goalId;
        this.attributionType = attributionType;
        this.searchGoalsCount = searchGoalsCount;
        this.сontextGoalsCount = сontextGoalsCount;
    }

    public static OrderCounterGoalStatItemBean parseTSVLine(String tsvLine) {
        if (tsvLine != null && tsvLine.startsWith("#")) {
            Matcher matcher = PARSE_PATTERN.matcher(tsvLine);
            if (matcher.matches()) {
                Long orderId = Long.parseLong(matcher.group(1));
                Long goalId = Long.parseLong(matcher.group(2));
                Integer attributionType = Integer.parseInt(matcher.group(3));
                Integer searchGoalsCount = Integer.parseInt(matcher.group(4));
                Integer сontextGoalsCount = Integer.parseInt(matcher.group(5));
                return new OrderCounterGoalStatItemBean(orderId, goalId, attributionType, searchGoalsCount,
                        сontextGoalsCount);
            }
        }
        return null;
    }

    @Override
    public String toString() {
        return String.format(TO_STRING_FORMAT, orderId, goalId, attributionType, searchGoalsCount,
                сontextGoalsCount);
    }
}
