package ru.yandex.autotests.direct.fakebsproxy.beans.ppccampgetgoals;

import java.util.ArrayList;
import java.util.List;

import static ru.yandex.autotests.direct.fakebsproxy.beans.ppccampgetgoals.OrderCounterGoalStatItemBean.ATTRIBUTION_TYPE;
import static ru.yandex.autotests.direct.fakebsproxy.beans.ppccampgetgoals.OrderCounterGoalStatItemBean.GOAL_ID;
import static ru.yandex.autotests.direct.fakebsproxy.beans.ppccampgetgoals.OrderCounterGoalStatItemBean.ORDER_ID;
import static ru.yandex.autotests.direct.fakebsproxy.beans.ppccampgetgoals.OrderCounterGoalStatItemBean.SEARCH_GOALS_COUNT;
import static ru.yandex.autotests.direct.fakebsproxy.beans.ppccampgetgoals.OrderCounterGoalStatItemBean.СONTEXT_GOALS_COUNT;

public class PpcCampGetGoalsResponseBean {
    public static final String HEADER =
            "0\n#" + ORDER_ID + "\t" + GOAL_ID + "\t" + ATTRIBUTION_TYPE + "\t" + SEARCH_GOALS_COUNT + "\t"
                    + СONTEXT_GOALS_COUNT + "\n";
    public static final String END = "#End";

    private List<OrderCounterGoalStatItemBean> data;


    public PpcCampGetGoalsResponseBean(List<OrderCounterGoalStatItemBean> data) {
        this.data = data;
    }

    public List<OrderCounterGoalStatItemBean> getData() {
        return data;
    }

    public void setData(List<OrderCounterGoalStatItemBean> data) {
        this.data = data;
    }

    public PpcCampGetGoalsResponseBean withData(List<OrderCounterGoalStatItemBean> data) {
        this.data = data;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(HEADER);
        for (OrderCounterGoalStatItemBean datum : this.data) {
            builder.append(datum.toString());
        }
        builder.append(END);
        return builder.toString();
    }

    public static PpcCampGetGoalsResponseBean fromString(String tsvData) {
        String[] tsvLines = tsvData.split("\n");
        ArrayList<OrderCounterGoalStatItemBean> data = new ArrayList<>();
        for (String line : tsvLines) {
            if (!line.startsWith("#")) {
                data.add(OrderCounterGoalStatItemBean.parseTSVLine(line));
            }
        }
        return new PpcCampGetGoalsResponseBean(data);
    }

}
