package ru.yandex.autotests.direct.fakebsproxy.dao;

import ru.yandex.autotests.direct.fakebsproxy.beans.FakeBSProxyLogBean;
import ru.yandex.autotests.irt.restheart.config.BaseMongoHelper;

/**
 * Created by buhter on 29/07/15.
 */
public class FakeBSProxyLogBeanMongoHelper extends BaseMongoHelper<FakeBSProxyLogBean> {
    //TODO: перенести имя базы
    private static final String DB_NAME = "BeanTemplates";
    private static final String COLLECTION = "FakeBSProxyLogs";
    private static final String QUERY_TEMPLATE = "{requestUUID:\"%s\"}";
    private static final String QUERY_BY_MOBILE_ID_TEMPLATE = "{objectIds:%s}";

    public FakeBSProxyLogBeanMongoHelper() {
        super(FakeBSProxyLogBean.class);
    }

    @Override
    public String getDb() {
        return DB_NAME;
    }

    public FakeBSProxyLogBean getFakeBSProxyLogBean(String requestUUID) {
        String query = String.format(QUERY_TEMPLATE, requestUUID);
        return getMongoBean(query);
    }

    public FakeBSProxyLogBean getFakeBSProxyLogBeanById(Object id) {
        String query;
        if (id instanceof String) {
            query = String.format(QUERY_BY_MOBILE_ID_TEMPLATE, "\"" + id + "\"");
        } else {
            query = String.format(QUERY_BY_MOBILE_ID_TEMPLATE, id);
        }
        return getMongoBean(query);
    }

    public void deleteFakeBSProxyLogBean(String requestUUID) {
        String query = String.format(QUERY_TEMPLATE, requestUUID);
        deleteMongoBean(query);
    }

    public void deleteFakeBSProxyLogBeansById(Object id) {
        String query;
        if (id instanceof String) {
            query = String.format(QUERY_BY_MOBILE_ID_TEMPLATE, "\"" + id + "\"");
        } else {
            query = String.format(QUERY_BY_MOBILE_ID_TEMPLATE, id);
        }
        deleteMongoBean(query);
    }

    public void saveFakeBSProxyLogBean(FakeBSProxyLogBean fakeBSProxyLogBean) {
        addMongoBean(fakeBSProxyLogBean);
    }

    @Override
    public String getUniqueFilter(FakeBSProxyLogBean fakeBSProxyLogBean) {
        return String.format(QUERY_TEMPLATE, fakeBSProxyLogBean.getRequestUUID());
    }

    @Override
    public String getCollection() {
        return COLLECTION;
    }
}


