package ru.yandex.autotests.direct.fakebsproxy.rest;

import org.eclipse.jetty.server.*;
import org.eclipse.jetty.webapp.WebAppContext;

public class JettyDebugStarter {

    private static final String WAR_PATH = "fake-bs-proxy-rest/target/fake-bs-proxy-rest.war";
    private static final String CONTEXT_PATH = "/";
    private static final int PORT = 9010;

    public static void main(String... args) throws Exception {
        Server server = new Server();
        server.setConnectors(new Connector[]{buildConnector(server)});
        server.setHandler(buildHandlers());
        server.start();
    }

    private static Connector buildConnector(Server server) {
        ServerConnector http = new ServerConnector(server, new HttpConnectionFactory(new HttpConfiguration()));
        http.setPort(PORT);
        return http;
    }

    private static Handler buildHandlers() {
        return buildWebAppContextHandler();
    }

    private static WebAppContext buildWebAppContextHandler() {
        return new WebAppContext(WAR_PATH, CONTEXT_PATH);
    }

}
